/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class YSkewSelectionPanel
extends AbstractRegionSelectionPanel {
    private static final int STARTING_WIDTH = 25;

    public int getNumberOfControlPoints() {
        return 6;
    }

    /*
     * WARNING - void declaration
     */
    public Cursor getControlPointCursor(int index) {
        void var2_2;
        switch (index) {
            case 0: 
            case 3: {
                int k = 4;
                break;
            }
            case 1: 
            case 2: {
                int k = 5;
                break;
            }
            case 4: 
            case 5: {
                return FreeHepImage.getCursor("0_MoveCursor", 16, 16);
            }
            default: {
                return FreeHepImage.getCursor("YSkewCursor");
            }
        }
        return YSkewSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[var2_2], this.yCtrlPts[index] - this.yCtrlPts[var2_2], 4, false);
    }

    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.yCtrlPts, y);
        this.xCtrlPts[0] = x - 25;
        this.xCtrlPts[1] = x - 25;
        this.xCtrlPts[2] = x + 25;
        this.xCtrlPts[3] = x + 25;
        this.xCtrlPts[4] = x;
        this.xCtrlPts[5] = x;
    }

    public void updateActiveControlPoint(int x, int y) {
        x = this.forceXCoordinateWithinBounds(x);
        y = this.forceYCoordinateWithinBounds(y);
        switch (this.activeCtrlPt) {
            case 0: {
                int width = x - this.xCtrlPts[4];
                this.xCtrlPts[0] = this.xCtrlPts[4] + width;
                this.xCtrlPts[1] = this.xCtrlPts[5] + width;
                this.xCtrlPts[2] = this.xCtrlPts[5] - width;
                this.xCtrlPts[3] = this.xCtrlPts[4] - width;
                break;
            }
            case 1: {
                int width = x - this.xCtrlPts[5];
                this.xCtrlPts[0] = this.xCtrlPts[4] + width;
                this.xCtrlPts[1] = this.xCtrlPts[5] + width;
                this.xCtrlPts[2] = this.xCtrlPts[5] - width;
                this.xCtrlPts[3] = this.xCtrlPts[4] - width;
                break;
            }
            case 2: {
                int width = x - this.xCtrlPts[5];
                this.xCtrlPts[0] = this.xCtrlPts[4] - width;
                this.xCtrlPts[1] = this.xCtrlPts[5] - width;
                this.xCtrlPts[2] = this.xCtrlPts[5] + width;
                this.xCtrlPts[3] = this.xCtrlPts[4] + width;
                break;
            }
            case 3: {
                int width = x - this.xCtrlPts[4];
                this.xCtrlPts[0] = this.xCtrlPts[4] - width;
                this.xCtrlPts[1] = this.xCtrlPts[5] - width;
                this.xCtrlPts[2] = this.xCtrlPts[5] + width;
                this.xCtrlPts[3] = this.xCtrlPts[4] + width;
                break;
            }
            case 4: {
                int width = this.xCtrlPts[4] - this.xCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x;
                this.yCtrlPts[this.activeCtrlPt] = y;
                this.xCtrlPts[0] = x - width;
                this.yCtrlPts[0] = y;
                this.xCtrlPts[3] = x + width;
                this.yCtrlPts[3] = y;
                break;
            }
            case 5: {
                int width = this.xCtrlPts[4] - this.xCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x;
                this.yCtrlPts[this.activeCtrlPt] = y;
                this.xCtrlPts[1] = x - width;
                this.yCtrlPts[1] = y;
                this.xCtrlPts[2] = x + width;
                this.yCtrlPts[2] = y;
                break;
            }
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, 2 * ctrlPtSize + 3, 2 * ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize, 2 * ctrlPtSize + 1, 2 * ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 0;
        int xSavedValue = this.xCtrlPts[first];
        int ySavedValue = this.yCtrlPts[first];
        for (int i = 1; i < 4; ++i) {
            int xValue = this.xCtrlPts[i];
            int yValue = this.yCtrlPts[i];
            if (yValue < ySavedValue) {
                xSavedValue = xValue;
                ySavedValue = yValue;
                first = i;
                continue;
            }
            if (yValue != ySavedValue || xValue >= xSavedValue) continue;
            xSavedValue = xValue;
            ySavedValue = yValue;
            first = i;
        }
        int third = (first + 2) % 4;
        int dx0 = this.xCtrlPts[third] - this.xCtrlPts[first];
        int second = (first + 1) % 4;
        int dy1 = this.yCtrlPts[second] - this.yCtrlPts[first];
        int dy0 = this.yCtrlPts[third] - this.yCtrlPts[first];
        int dx1 = this.xCtrlPts[second] - this.xCtrlPts[first];
        if (dx0 * dy1 - dy0 * dx1 > 0) {
            second = (first + 3) % 4;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && this.yCtrlPts[4] != this.yCtrlPts[5] && this.xCtrlPts[0] != this.xCtrlPts[3];
    }
}

