/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.julbridge;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.logging.julbridge.JULLevelConverter;

public class JULLog4jEventConverter {
    private final LoggerRepository repository;
    private final JULLevelConverter levelConverter;
    public static final JULLevelConverter DEFAULT_LEVEL_CONVERTER = new DefaultLevelConverter();

    public JULLog4jEventConverter() {
        this(LogManager.getLoggerRepository());
    }

    public JULLog4jEventConverter(LoggerRepository repository) {
        this(repository, DEFAULT_LEVEL_CONVERTER);
    }

    public JULLog4jEventConverter(LoggerRepository repository, JULLevelConverter levelConverter) {
        this.repository = repository;
        this.levelConverter = levelConverter;
    }

    public LoggingEvent convert(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = this.repository.getLogger(loggerName);
        String sourceClassName = record.getSourceClassName();
        String sourceMethodName = record.getSourceMethodName();
        LocationInfo locationInfo = new LocationInfo("?", sourceClassName, sourceMethodName, "?");
        String ndc = null;
        String threadName = String.valueOf(record.getThreadID());
        ThrowableInformation throwableInformation = record.getThrown() == null ? null : new ThrowableInformation(record.getThrown());
        LoggingEvent event = new LoggingEvent(loggerName, (Category)logger, record.getMillis(), this.levelConverter.convertJuliLevel(record.getLevel()), (Object)record.getMessage(), threadName, throwableInformation, ndc, locationInfo, (Map)new Properties());
        return event;
    }

    private static final class DefaultLevelConverter
    implements JULLevelConverter {
        private DefaultLevelConverter() {
        }

        public org.apache.log4j.Level convertJuliLevel(Level juliLevel) {
            if (juliLevel.equals(Level.FINEST)) {
                return org.apache.log4j.Level.TRACE;
            }
            if (juliLevel.equals(Level.FINER)) {
                return org.apache.log4j.Level.DEBUG;
            }
            if (juliLevel.equals(Level.FINE)) {
                return org.apache.log4j.Level.DEBUG;
            }
            if (juliLevel.equals(Level.INFO)) {
                return org.apache.log4j.Level.INFO;
            }
            if (juliLevel.equals(Level.WARNING)) {
                return org.apache.log4j.Level.WARN;
            }
            if (juliLevel.equals(Level.SEVERE)) {
                return org.apache.log4j.Level.ERROR;
            }
            if (juliLevel.equals(Level.ALL)) {
                return org.apache.log4j.Level.ALL;
            }
            if (juliLevel.equals(Level.OFF)) {
                return org.apache.log4j.Level.OFF;
            }
            return org.apache.log4j.Level.DEBUG;
        }

        public Level convertLog4jLevel(org.apache.log4j.Level log4jLevel) {
            if (log4jLevel.equals((Object)org.apache.log4j.Level.TRACE)) {
                return Level.FINEST;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.DEBUG)) {
                return Level.FINER;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.INFO)) {
                return Level.INFO;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.WARN)) {
                return Level.WARNING;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.ERROR)) {
                return Level.SEVERE;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.FATAL)) {
                return Level.SEVERE;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.ALL)) {
                return Level.ALL;
            }
            if (log4jLevel.equals((Object)org.apache.log4j.Level.OFF)) {
                return Level.OFF;
            }
            return Level.FINE;
        }
    }
}

