/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.PBCryptdec;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PBAES128Cryptdec
extends PBCryptdec {
    public PBAES128Cryptdec(String string, byte[] byArray, char[] cArray, byte[] byArray2, int n) throws GeneralSecurityException {
        super(string, byArray, cArray, byArray2);
        this.init(cArray, byArray2, n);
    }

    protected String getCipherAlgorithmId() {
        return "AES";
    }

    protected String getCipherId() {
        return "AES/CBC/PKCS5Padding";
    }

    protected int getKeyLength() {
        return 128;
    }

    protected String getPBKeyFactoryId() {
        return "PBKDF2WithHmacSHA1";
    }

    private void init(char[] cArray, byte[] byArray, int n) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, this.getKeyLength());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.getPBKeyFactoryId());
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), this.getCipherAlgorithmId());
        this.setEcipher(Cipher.getInstance(this.getCipherId()));
        this.setDcipher(Cipher.getInstance(this.getCipherId()));
        if (this.getInitializationVector() != null) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.getInitializationVector());
            this.getEcipher().init(1, (Key)secretKeySpec, ivParameterSpec);
            this.getDcipher().init(2, (Key)secretKeySpec, ivParameterSpec);
        } else {
            this.getEcipher().init(1, secretKeySpec);
            this.setInitializationVector(this.getEcipher().getIV());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.getInitializationVector());
            this.getDcipher().init(2, (Key)secretKeySpec, ivParameterSpec);
        }
    }
}

