/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business;

import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class WorkExecutor {
    private static final Logger log = Logger.getLogger(WorkExecutor.class.getPackage().getName());
    private static WorkExecutor executor;
    private Configuration config;
    private WorkQueue workQueue = new WorkQueue(1);

    private WorkExecutor() {
        this.workQueue.startWorkQueue();
        this.config = Configuration.getInstance();
    }

    public static synchronized WorkExecutor getInstance() {
        if (executor == null) {
            executor = new WorkExecutor();
        }
        return executor;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone WorkExecutor object.");
    }

    public void execute(Runnable r) {
        this.workQueue.execute(r);
    }

    public int getRunningThreads() {
        return this.workQueue.getRunning();
    }

    public class WorkQueue {
        private final PoolWorker[] threads;
        private final LinkedList<Runnable> queue = new LinkedList();
        private int running = 0;

        public WorkQueue() {
            this(1);
        }

        public WorkQueue(int nThreads) {
            this.threads = new PoolWorker[nThreads];
        }

        public void startWorkQueue() {
            if (this.threads != null) {
                for (int i = 0; i < this.threads.length; ++i) {
                    this.threads[i] = new PoolWorker();
                    this.threads[i].start();
                }
            }
        }

        public synchronized void incRunningCounter() {
            ++this.running;
        }

        public synchronized void deincRunningCounter() {
            --this.running;
        }

        public int getRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable r) {
            LinkedList<Runnable> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(r);
                this.queue.notify();
            }
        }

        private class PoolWorker
        extends Thread {
            private PoolWorker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Runnable r;
                    LinkedList linkedList = WorkQueue.this.queue;
                    synchronized (linkedList) {
                        while (WorkQueue.this.queue.isEmpty()) {
                            try {
                                WorkQueue.this.queue.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        r = (Runnable)WorkQueue.this.queue.removeFirst();
                    }
                    if (r == null) continue;
                    try {
                        WorkQueue.this.incRunningCounter();
                        r.run();
                        continue;
                    }
                    catch (RuntimeException e) {
                        log.error(GettextResource.gettext((ResourceBundle)WorkExecutor.this.config.getI18nResourceBundle(), (String)"Error: "), e);
                        continue;
                    }
                    finally {
                        WorkQueue.this.deincRunningCounter();
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

