/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.expr.AbsFunction;
import org.apache.fop.fo.expr.BodyStartFunction;
import org.apache.fop.fo.expr.CIELabColorFunction;
import org.apache.fop.fo.expr.CMYKColorFunction;
import org.apache.fop.fo.expr.CeilingFunction;
import org.apache.fop.fo.expr.FloorFunction;
import org.apache.fop.fo.expr.FromNearestSpecifiedValueFunction;
import org.apache.fop.fo.expr.FromParentFunction;
import org.apache.fop.fo.expr.FromTableColumnFunction;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.InheritedPropFunction;
import org.apache.fop.fo.expr.LabelEndFunction;
import org.apache.fop.fo.expr.MaxFunction;
import org.apache.fop.fo.expr.MinFunction;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.OCAColorFunction;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyTokenizer;
import org.apache.fop.fo.expr.ProportionalColumnWidthFunction;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.expr.RGBICCColorFunction;
import org.apache.fop.fo.expr.RGBNamedColorFunction;
import org.apache.fop.fo.expr.RoundFunction;
import org.apache.fop.fo.expr.SystemColorFunction;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.StringProperty;

public final class PropertyParser
extends PropertyTokenizer {
    private PropertyInfo propInfo;
    private static final String RELUNIT = "em";
    private static final HashMap FUNCTION_TABLE = new HashMap();

    public static Property parse(String expr, PropertyInfo propInfo) throws PropertyException {
        try {
            return new PropertyParser(expr, propInfo).parseProperty();
        }
        catch (PropertyException exc) {
            exc.setPropertyInfo(propInfo);
            throw exc;
        }
    }

    private PropertyParser(String propExpr, PropertyInfo pInfo) {
        super(propExpr);
        this.propInfo = pInfo;
    }

    private Property parseProperty() throws PropertyException {
        this.next();
        if (this.currentToken == 0) {
            return StringProperty.getInstance("");
        }
        ListProperty propList = null;
        while (true) {
            Property prop = this.parseAdditiveExpr();
            if (this.currentToken == 0) {
                if (propList != null) {
                    propList.addProperty(prop);
                    return propList;
                }
                return prop;
            }
            if (propList == null) {
                propList = new ListProperty(prop);
                continue;
            }
            propList.addProperty(prop);
        }
    }

    private Property parseAdditiveExpr() throws PropertyException {
        Property prop = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 8: {
                    this.next();
                    prop = this.evalAddition(prop.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
                case 9: {
                    this.next();
                    prop = this.evalSubtraction(prop.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
            }
            break;
        }
        return prop;
    }

    private Property parseMultiplicativeExpr() throws PropertyException {
        Property prop = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 11: {
                    this.next();
                    prop = this.evalDivide(prop.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
                case 10: {
                    this.next();
                    prop = this.evalModulo(prop.getNumber(), this.parseUnaryExpr().getNumber());
                    continue block5;
                }
                case 2: {
                    this.next();
                    prop = this.evalMultiply(prop.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
            }
            break;
        }
        return prop;
    }

    private Property parseUnaryExpr() throws PropertyException {
        if (this.currentToken == 9) {
            this.next();
            return this.evalNegate(this.parseUnaryExpr().getNumeric());
        }
        return this.parsePrimaryExpr();
    }

    private void expectRpar() throws PropertyException {
        if (this.currentToken != 4) {
            throw new PropertyException("expected )");
        }
        this.next();
    }

    private Property parsePrimaryExpr() throws PropertyException {
        Property prop;
        if (this.currentToken == 13) {
            this.next();
        }
        switch (this.currentToken) {
            case 3: {
                this.next();
                Property prop2 = this.parseAdditiveExpr();
                this.expectRpar();
                return prop2;
            }
            case 5: {
                prop = StringProperty.getInstance(this.currentTokenValue);
                break;
            }
            case 1: {
                prop = new NCnameProperty(this.currentTokenValue);
                break;
            }
            case 16: {
                prop = NumberProperty.getInstance(new Double(this.currentTokenValue));
                break;
            }
            case 17: {
                prop = NumberProperty.getInstance(new Integer(this.currentTokenValue));
                break;
            }
            case 14: {
                double pcval = Double.parseDouble(this.currentTokenValue.substring(0, this.currentTokenValue.length() - 1)) / 100.0;
                PercentBase pcBase = this.propInfo.getPercentBase();
                if (pcBase != null) {
                    if (pcBase.getDimension() == 0) {
                        prop = NumberProperty.getInstance(pcval * pcBase.getBaseValue());
                        break;
                    }
                    if (pcBase.getDimension() == 1) {
                        if (pcBase instanceof LengthBase) {
                            if (pcval == 0.0) {
                                prop = FixedLength.ZERO_FIXED_LENGTH;
                                break;
                            }
                            Length base = ((LengthBase)pcBase).getBaseLength();
                            if (base != null && base.isAbsolute()) {
                                prop = FixedLength.getInstance(pcval * (double)base.getValue());
                                break;
                            }
                        }
                        prop = new PercentLength(pcval, pcBase);
                        break;
                    }
                    throw new PropertyException("Illegal percent dimension value");
                }
                prop = NumberProperty.getInstance(pcval);
                break;
            }
            case 12: {
                int numLen = this.currentTokenValue.length() - this.currentUnitLength;
                String unitPart = this.currentTokenValue.substring(numLen);
                double numPart = Double.parseDouble(this.currentTokenValue.substring(0, numLen));
                if (RELUNIT.equals(unitPart)) {
                    prop = (Property)((Object)NumericOp.multiply(NumberProperty.getInstance(numPart), this.propInfo.currentFontSize()));
                    break;
                }
                if ("px".equals(unitPart)) {
                    float resolution = this.propInfo.getPropertyList().getFObj().getUserAgent().getSourceResolution();
                    prop = FixedLength.getInstance(numPart, unitPart, 72.0f / resolution);
                    break;
                }
                prop = FixedLength.getInstance(numPart, unitPart);
                break;
            }
            case 15: {
                prop = ColorProperty.getInstance(this.propInfo.getUserAgent(), this.currentTokenValue);
                break;
            }
            case 7: {
                Function function = (Function)FUNCTION_TABLE.get(this.currentTokenValue);
                if (function == null) {
                    throw new PropertyException("no such function: " + this.currentTokenValue);
                }
                this.next();
                this.propInfo.pushFunction(function);
                Property prop3 = function.eval(this.parseArgs(function), this.propInfo);
                this.propInfo.popFunction();
                return prop3;
            }
            default: {
                throw new PropertyException("syntax error");
            }
        }
        this.next();
        return prop;
    }

    Property[] parseArgs(Function function) throws PropertyException {
        int i;
        int numReq = function.getRequiredArgsCount();
        int numOpt = function.getOptionalArgsCount();
        boolean hasVar = function.hasVariableArgs();
        ArrayList<Property> args = new ArrayList<Property>(numReq + numOpt);
        if (this.currentToken == 4) {
            this.next();
        } else {
            while (true) {
                Property p = this.parseAdditiveExpr();
                i = args.size();
                if (i >= numReq && i - numReq >= numOpt && !hasVar) {
                    throw new PropertyException("Unexpected function argument at index " + i);
                }
                args.add(p);
                if (this.currentToken != 13) break;
                this.next();
            }
            this.expectRpar();
        }
        int numArgs = args.size();
        if (numArgs < numReq) {
            throw new PropertyException("Expected " + numReq + " required arguments, but only " + numArgs + " specified");
        }
        for (i = 0; i < numOpt; ++i) {
            if (args.size() >= numReq + i + 1) continue;
            args.add(function.getOptionalArgDefault(i, this.propInfo));
        }
        return args.toArray(new Property[args.size()]);
    }

    private Property evalAddition(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in addition");
        }
        return (Property)((Object)NumericOp.addition(op1, op2));
    }

    private Property evalSubtraction(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in subtraction");
        }
        return (Property)((Object)NumericOp.subtraction(op1, op2));
    }

    private Property evalNegate(Numeric op) throws PropertyException {
        if (op == null) {
            throw new PropertyException("Non numeric operand to unary minus");
        }
        return (Property)((Object)NumericOp.negate(op));
    }

    private Property evalMultiply(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in multiplication");
        }
        return (Property)((Object)NumericOp.multiply(op1, op2));
    }

    private Property evalDivide(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in division");
        }
        return (Property)((Object)NumericOp.divide(op1, op2));
    }

    private Property evalModulo(Number op1, Number op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non number operand to modulo");
        }
        return NumberProperty.getInstance(op1.doubleValue() % op2.doubleValue());
    }

    static {
        FUNCTION_TABLE.put("ceiling", new CeilingFunction());
        FUNCTION_TABLE.put("floor", new FloorFunction());
        FUNCTION_TABLE.put("round", new RoundFunction());
        FUNCTION_TABLE.put("min", new MinFunction());
        FUNCTION_TABLE.put("max", new MaxFunction());
        FUNCTION_TABLE.put("abs", new AbsFunction());
        FUNCTION_TABLE.put("rgb", new RGBColorFunction());
        FUNCTION_TABLE.put("system-color", new SystemColorFunction());
        FUNCTION_TABLE.put("from-table-column", new FromTableColumnFunction());
        FUNCTION_TABLE.put("inherited-property-value", new InheritedPropFunction());
        FUNCTION_TABLE.put("from-nearest-specified-value", new FromNearestSpecifiedValueFunction());
        FUNCTION_TABLE.put("from-parent", new FromParentFunction());
        FUNCTION_TABLE.put("proportional-column-width", new ProportionalColumnWidthFunction());
        FUNCTION_TABLE.put("label-end", new LabelEndFunction());
        FUNCTION_TABLE.put("body-start", new BodyStartFunction());
        FUNCTION_TABLE.put("rgb-icc", new RGBICCColorFunction());
        FUNCTION_TABLE.put("rgb-named-color", new RGBNamedColorFunction());
        FUNCTION_TABLE.put("cie-lab-color", new CIELabColorFunction());
        FUNCTION_TABLE.put("cmyk", new CMYKColorFunction());
        FUNCTION_TABLE.put("oca", new OCAColorFunction());
    }
}

