/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class ImageRawPNGAdapter
extends AbstractImageAdapter {
    private static Log log = LogFactory.getLog(ImageRawPNGAdapter.class);
    private static final PDFName RI_PERCEPTUAL = new PDFName("Perceptual");
    private static final PDFName RI_RELATIVE_COLORIMETRIC = new PDFName("RelativeColorimetric");
    private static final PDFName RI_SATURATION = new PDFName("Saturation");
    private static final PDFName RI_ABSOLUTE_COLORIMETRIC = new PDFName("AbsoluteColorimetric");
    private PDFFilter pdfFilter;
    private String maskRef;
    private PDFReference softMask;
    private int numberOfInterleavedComponents;

    public ImageRawPNGAdapter(ImageRawPNG image, String key) {
        super((Image)image, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(PDFDocument doc) {
        FlateFilter flate;
        super.setup(doc);
        ColorModel cm = ((ImageRawPNG)this.image).getColorModel();
        this.numberOfInterleavedComponents = cm instanceof IndexColorModel ? 1 : cm.getNumComponents();
        try {
            flate = new FlateFilter();
            flate.setApplied(true);
            flate.setPredictor(15);
            if (this.numberOfInterleavedComponents < 3) {
                flate.setColors(1);
            } else {
                flate.setColors(3);
            }
            flate.setColumns(this.image.getSize().getWidthPx());
            flate.setBitsPerComponent(this.getBitsPerComponent());
        }
        catch (PDFFilterException e) {
            throw new RuntimeException("FlateFilter configuration error", e);
        }
        this.pdfFilter = flate;
        this.disallowMultipleFilters();
        if (cm.hasAlpha() && cm.getTransparency() == 3) {
            doc.getProfile().verifyTransparencyAllowed(this.image.getInfo().getOriginalURI());
            ByteArrayOutputStream baos = null;
            DeflaterOutputStream dos = null;
            InputStream in = null;
            InflaterInputStream infStream = null;
            DataInputStream dataStream = null;
            try {
                FlateFilter transFlate;
                baos = new ByteArrayOutputStream();
                dos = new DeflaterOutputStream((OutputStream)baos, new Deflater());
                in = ((ImageRawStream)this.image).createInputStream();
                try {
                    int filter;
                    infStream = new InflaterInputStream(in, new Inflater());
                    dataStream = new DataInputStream(infStream);
                    int offset = this.numberOfInterleavedComponents - 1;
                    int numColumns = this.image.getSize().getWidthPx();
                    int bytesPerRow = this.numberOfInterleavedComponents * numColumns;
                    while ((filter = dataStream.read()) != -1) {
                        byte[] bytes = new byte[bytesPerRow];
                        dataStream.readFully(bytes, 0, bytesPerRow);
                        dos.write((byte)filter);
                        for (int j = 0; j < numColumns; ++j) {
                            dos.write(bytes, offset, 1);
                            offset += this.numberOfInterleavedComponents;
                        }
                        offset = this.numberOfInterleavedComponents - 1;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error processing transparency channel:", e);
                }
                try {
                    transFlate = new FlateFilter();
                    transFlate.setApplied(true);
                    transFlate.setPredictor(15);
                    transFlate.setColors(1);
                    transFlate.setColumns(this.image.getSize().getWidthPx());
                    transFlate.setBitsPerComponent(this.getBitsPerComponent());
                }
                catch (PDFFilterException e) {
                    throw new RuntimeException("FlateFilter configuration error", e);
                }
                BitmapImage alphaMask = new BitmapImage("Mask:" + this.getKey(), this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx(), baos.toByteArray(), null);
                alphaMask.setPDFFilter(transFlate);
                alphaMask.disallowMultipleFilters();
                alphaMask.setColorSpace(new PDFDeviceColorSpace(1));
                this.softMask = doc.addImage(null, alphaMask).makeReference();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(infStream);
                IOUtils.closeQuietly(dataStream);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(dos);
                IOUtils.closeQuietly((OutputStream)baos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)infStream);
            IOUtils.closeQuietly((InputStream)dataStream);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)dos);
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public PDFDeviceColorSpace getColorSpace() {
        return ImageRawPNGAdapter.toPDFColorSpace(this.image.getColorSpace());
    }

    public int getBitsPerComponent() {
        return ((ImageRawPNG)this.image).getBitDepth();
    }

    public boolean isTransparent() {
        return ((ImageRawPNG)this.image).isTransparent();
    }

    public PDFColor getTransparentColor() {
        return new PDFColor(((ImageRawPNG)this.image).getTransparentColor());
    }

    public String getMask() {
        return this.maskRef;
    }

    public String getSoftMask() {
        return this.softMask.toString();
    }

    public PDFReference getSoftMaskReference() {
        return this.softMask;
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputContents(OutputStream out) throws IOException {
        InputStream in = ((ImageRawStream)this.image).createInputStream();
        InflaterInputStream infStream = null;
        DataInputStream dataStream = null;
        DeflaterOutputStream dos = null;
        try {
            if (this.numberOfInterleavedComponents == 1 || this.numberOfInterleavedComponents == 3) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                int filter;
                int numBytes = this.numberOfInterleavedComponents - 1;
                int numColumns = this.image.getSize().getWidthPx();
                infStream = new InflaterInputStream(in, new Inflater());
                dataStream = new DataInputStream(infStream);
                int offset = 0;
                int bytesPerRow = this.numberOfInterleavedComponents * numColumns;
                dos = new DeflaterOutputStream(out, new Deflater());
                while ((filter = dataStream.read()) != -1) {
                    byte[] bytes = new byte[bytesPerRow];
                    dataStream.readFully(bytes, 0, bytesPerRow);
                    dos.write((byte)filter);
                    for (int j = 0; j < numColumns; ++j) {
                        dos.write(bytes, offset, numBytes);
                        offset += this.numberOfInterleavedComponents;
                    }
                    offset = 0;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(dos);
            IOUtils.closeQuietly(dataStream);
            IOUtils.closeQuietly(infStream);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public String getFilterHint() {
        return "precompressed";
    }

    public void populateXObjectDictionary(PDFDictionary dict) {
        ColorModel cm;
        int renderingIntent = ((ImageRawPNG)this.image).getRenderingIntent();
        if (renderingIntent != -1) {
            switch (renderingIntent) {
                case 0: {
                    dict.put("Intent", RI_PERCEPTUAL);
                    break;
                }
                case 1: {
                    dict.put("Intent", RI_RELATIVE_COLORIMETRIC);
                    break;
                }
                case 2: {
                    dict.put("Intent", RI_SATURATION);
                    break;
                }
                case 3: {
                    dict.put("Intent", RI_ABSOLUTE_COLORIMETRIC);
                    break;
                }
            }
        }
        if ((cm = ((ImageRawPNG)this.image).getColorModel()) instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            super.populateXObjectDictionaryForIndexColorModel(dict, icm);
        }
    }

    protected boolean issRGB() {
        return ((ImageRawPNG)this.image).getRenderingIntent() != -1;
    }
}

