/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrintable;
import org.gjt.sp.util.Log;

public class BufferPrinter1_4 {
    private static PrintRequestAttributeSet format;
    private static PrinterJob job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrinterJob getPrintJob(String string) {
        String string2;
        File file;
        job = PrinterJob.getPrinterJob();
        format = new HashPrintRequestAttributeSet();
        String string3 = jEdit.getSettingsDirectory();
        if (string3 != null && (file = new File(string2 = MiscUtilities.constructPath(string3, "printspec"))).exists()) {
            ObjectInputStream objectInputStream = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                format = (HashPrintRequestAttributeSet)objectInputStream.readObject();
            }
            catch (Exception exception) {
                Log.log(9, BufferPrinter1_4.class, exception);
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (jEdit.getBooleanProperty("print.color")) {
                format.add(Chromaticity.COLOR);
            } else {
                format.add(Chromaticity.MONOCHROME);
            }
            format.add(new JobName(string, null));
        }
        return job;
    }

    public static void pageSetup(View view) {
        PrinterJob printerJob = BufferPrinter1_4.getPrintJob("PageSetupOnly");
        if (printerJob.pageDialog(format) != null) {
            BufferPrinter1_4.savePrintSpec();
        }
    }

    public static void print(View view, Buffer buffer, boolean bl) {
        job = BufferPrinter1_4.getPrintJob(MiscUtilities.abbreviateView(buffer.getPath()));
        boolean bl2 = jEdit.getBooleanProperty("print.header");
        boolean bl3 = jEdit.getBooleanProperty("print.footer");
        boolean bl4 = jEdit.getBooleanProperty("print.lineNumbers");
        boolean bl5 = jEdit.getBooleanProperty("print.color");
        Font font = jEdit.getFontProperty("print.font");
        BufferPrintable bufferPrintable = new BufferPrintable(job, format, view, buffer, font, bl2, bl3, bl4, bl5);
        job.setPrintable(bufferPrintable);
        if (!job.printDialog(format)) {
            return;
        }
        BufferPrinter1_4.savePrintSpec();
        bufferPrintable.print();
    }

    public static PageFormat getPageFormat() {
        PrinterJob printerJob = BufferPrinter1_4.getPrintJob(" ");
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        MediaSizeName mediaSizeName = (MediaSizeName)format.get(Media.class);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)format.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            paper.setImageableArea(mediaPrintableArea.getX(25400) * 72.0f, mediaPrintableArea.getY(25400) * 72.0f, mediaPrintableArea.getWidth(25400) * 72.0f, mediaPrintableArea.getHeight(25400) * 72.0f);
        }
        if (mediaSize != null) {
            paper.setSize(mediaSize.getX(25400) * 72.0f, mediaSize.getY(25400) * 72.0f);
        }
        pageFormat.setPaper(paper);
        OrientationRequested orientationRequested = (OrientationRequested)format.get(OrientationRequested.class);
        if (orientationRequested != null) {
            if (orientationRequested.getValue() == OrientationRequested.LANDSCAPE.getValue()) {
                pageFormat.setOrientation(0);
            } else if (orientationRequested.getValue() == OrientationRequested.REVERSE_LANDSCAPE.getValue()) {
                pageFormat.setOrientation(2);
            } else if (orientationRequested.getValue() == OrientationRequested.PORTRAIT.getValue()) {
                pageFormat.setOrientation(1);
            } else if (orientationRequested.getValue() == OrientationRequested.REVERSE_PORTRAIT.getValue()) {
                pageFormat.setOrientation(1);
            }
        }
        return pageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrintSpec() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        String string2 = MiscUtilities.constructPath(string, "printspec");
        File file = new File(string2);
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(format);
            Chromaticity chromaticity = (Chromaticity)format.get(Chromaticity.class);
            if (chromaticity != null) {
                jEdit.setBooleanProperty("print.color", chromaticity.getValue() == Chromaticity.COLOR.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

