/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.JSONEncodable;
import javajs.util.PT;
import javajs.util.SB;

public class BS
implements Cloneable,
JSONEncodable {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int WORD_MASK = -1;
    private int[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final int[] emptyBitmap = new int[0];

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private void recalculateWordsInUse() {
        int i = this.wordsInUse - 1;
        while (i >= 0) {
            if (this.words[i] != 0) break;
            --i;
        }
        this.wordsInUse = i + 1;
    }

    public BS() {
        this.initWords(32);
        this.sizeIsSticky = false;
    }

    public static BS newN(int nbits) {
        BS bs = new BS();
        bs.init(nbits);
        return bs;
    }

    private void init(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
        this.sizeIsSticky = true;
    }

    private void initWords(int nbits) {
        this.words = new int[BS.wordIndex(nbits - 1) + 1];
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            this.setLength(request);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BS.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1 << bitIndex;
    }

    public void setBitTo(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void setBits(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BS.wordIndex(fromIndex);
        int endWordIndex = BS.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                this.words[i] = -1;
                ++i;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BS.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & ~(1 << bitIndex);
        this.recalculateWordsInUse();
    }

    public void clearBits(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BS.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = BS.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse - 1;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & ~(firstWordMask & lastWordMask);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & ~firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                this.words[i] = 0;
                ++i;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & ~lastWordMask;
        }
        this.recalculateWordsInUse();
    }

    public void clearAll() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BS.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1 << bitIndex) != 0;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = BS.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        int word = this.words[u] & -1 << fromIndex;
        while (word == 0) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 32 + Integer.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = BS.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        int word = ~this.words[u] & -1 << fromIndex;
        while (word == 0) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 32;
            }
            word = ~this.words[u];
        }
        return u * 32 + Integer.numberOfTrailingZeros(word);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 32 * (this.wordsInUse - 1) + (32 - Integer.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BS set) {
        int i = Math.min(this.wordsInUse, set.wordsInUse) - 1;
        while (i >= 0) {
            if ((this.words[i] & set.words[i]) != 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        int i = 0;
        while (i < this.wordsInUse) {
            sum += Integer.bitCount(this.words[i]);
            ++i;
        }
        return sum;
    }

    /*
     * Unable to fully structure code
     */
    public void and(BS set) {
        if (this != set) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.words[--this.wordsInUse] = 0;
lbl4:
            // 2 sources

            ** while (this.wordsInUse > set.wordsInUse)
        }
lbl5:
        // 1 sources

        i = 0;
        while (i < this.wordsInUse) {
            v0 = i;
            this.words[v0] = this.words[v0] & set.words[i];
            ++i;
        }
        this.recalculateWordsInUse();
    }

    public void or(BS set) {
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        int i = 0;
        while (i < wordsInCommon) {
            int n = i;
            this.words[n] = this.words[n] | set.words[i];
            ++i;
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
    }

    public void xor(BS set) {
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        int i = 0;
        while (i < wordsInCommon) {
            int n = i;
            this.words[n] = this.words[n] ^ set.words[i];
            ++i;
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse - wordsInCommon);
        }
        this.recalculateWordsInUse();
    }

    public void andNot(BS set) {
        int i = Math.min(this.wordsInUse, set.wordsInUse) - 1;
        while (i >= 0) {
            int n = i;
            this.words[n] = this.words[n] & ~set.words[i];
            --i;
        }
        this.recalculateWordsInUse();
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse;
        while (--i >= 0) {
            h ^= (long)(this.words[i] * (i + 1));
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.words.length * 32;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BS)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BS set = (BS)obj;
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        int i = 0;
        while (i < this.wordsInUse) {
            if (this.words[i] != set.words[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky && this.wordsInUse != this.words.length) {
            this.setLength(this.wordsInUse);
        }
        return BS.copy(this);
    }

    private void setLength(int n) {
        int[] a = new int[n];
        System.arraycopy(this.words, 0, a, 0, Math.min(this.wordsInUse, n));
        this.words = a;
    }

    public String toString() {
        return BS.escape(this, '{', '}');
    }

    public static BS copy(BS bitsetToCopy) {
        BS bs = new BS();
        int wordCount = bitsetToCopy.wordsInUse;
        if (wordCount == 0) {
            bs.words = emptyBitmap;
        } else {
            bs.wordsInUse = wordCount;
            bs.words = new int[bs.wordsInUse];
            System.arraycopy(bitsetToCopy.words, 0, bs.words, 0, wordCount);
        }
        return bs;
    }

    public int cardinalityN(int max) {
        int n = this.cardinality();
        int i = this.length();
        while (--i >= max) {
            if (!this.get(i)) continue;
            --n;
        }
        return n;
    }

    @Override
    public String toJSON() {
        int numBits = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 32;
        SB b = SB.newN(6 * numBits + 2);
        b.appendC('[');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.appendI(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").appendI(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.appendC(']');
        return b.toString();
    }

    public static String escape(BS bs, char chOpen, char chClose) {
        if (bs == null) {
            return String.valueOf(chOpen) + "{}" + chClose;
        }
        SB s = new SB();
        s.append(String.valueOf(chOpen) + "{");
        int imax = bs.length();
        int iLast = -1;
        int iFirst = -2;
        int i = -1;
        while (++i <= imax) {
            boolean isSet = bs.get(i);
            if (i == imax || iLast >= 0 && !isSet) {
                if (iLast >= 0 && iFirst != iLast) {
                    s.append(String.valueOf(iFirst == iLast - 1 ? " " : ":") + iLast);
                }
                if (i == imax) break;
                iLast = -1;
            }
            if (!bs.get(i)) continue;
            if (iLast < 0) {
                s.append(String.valueOf(iFirst == -2 ? "" : " ") + i);
                iFirst = i;
            }
            iLast = i;
        }
        s.append("}").appendC(chClose);
        return s.toString();
    }

    public static BS unescape(String str) {
        char ch;
        int len;
        if (str == null || (len = (str = str.trim()).length()) < 4 || str.equalsIgnoreCase("({null})") || (ch = str.charAt(0)) != '(' && ch != '[' || str.charAt(len - 1) != (ch == '(' ? (char)')' : ']') || str.charAt(1) != '{' || str.indexOf(125) != len - 2) {
            return null;
        }
        int i = len -= 2;
        while (--i >= 2) {
            ch = str.charAt(i);
            if (PT.isDigit(ch) || ch == ' ' || ch == '\t' || ch == ':') continue;
            return null;
        }
        int lastN = len;
        while (PT.isDigit(str.charAt(--lastN))) {
        }
        if (++lastN == len) {
            lastN = 0;
        } else {
            try {
                lastN = Integer.parseInt(str.substring(lastN, len));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        BS bs = BS.newN(lastN);
        lastN = -1;
        int iPrev = -1;
        int iThis = -2;
        int i2 = 2;
        while (i2 <= len) {
            ch = str.charAt(i2);
            switch (ch) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (iThis < 0) break;
                    if (iThis < lastN) {
                        return null;
                    }
                    lastN = iThis;
                    if (iPrev < 0) {
                        iPrev = iThis;
                    }
                    bs.setBits(iPrev, iThis + 1);
                    iPrev = -1;
                    iThis = -2;
                    break;
                }
                case ':': {
                    iPrev = lastN = iThis;
                    iThis = -2;
                    break;
                }
                default: {
                    if (!PT.isDigit(ch)) break;
                    if (iThis < 0) {
                        iThis = 0;
                    }
                    iThis = iThis * 10 + (ch - 48);
                }
            }
            ++i2;
        }
        return iPrev >= 0 ? null : bs;
    }
}

