/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.util.TriangleData;

public class MarchingCubes
extends TriangleData {
    protected VertexDataServer surfaceReader;
    protected VolumeData volumeData;
    protected int contourType;
    protected boolean isContoured;
    protected float cutoff;
    protected boolean isCutoffAbsolute;
    protected boolean isSquared;
    protected boolean isXLowToHigh;
    protected int cubeCountX;
    protected int cubeCountY;
    protected int cubeCountZ;
    protected int nY;
    protected int nZ;
    protected int yzCount;
    protected boolean colorDensity;
    protected boolean integrateSquared = true;
    public BS bsVoxels;
    protected BS bsExcludedVertices;
    protected BS bsExcludedTriangles;
    protected BS bsExcludedPlanes;
    protected SB edgeData = new SB();
    private boolean excludePartialCubes = true;
    protected int mode;
    protected static final int MODE_CUBE = 1;
    protected static final int MODE_JVXL = 2;
    protected static final int MODE_PLANES = 3;
    protected final float[] vertexValues = new float[8];
    protected int edgeCount;
    protected final V3[] voxelVertexVectors = new V3[8];
    protected final V3[] edgeVectors = new V3[12];
    protected static int[] yzPlanePts = new int[]{0, 1, 1, 0, 0, 1, 1, 0};
    protected final int[] edgePointIndexes;
    protected int[][][] isoPointIndexPlanes;
    protected float[][] yzPlanes;
    private P4 mappingPlane;
    private boolean allInside;
    private boolean isInside;
    private P3i offset;
    private float[][][] voxelData;
    protected int nTriangles;
    protected BS bsValues;
    protected final P3 pt0;
    protected final P3 pointA;
    protected static final int[] edgeVertexPointersLowToHigh = new int[]{1, 1, 2, 0, 5, 5, 6, 4, 0, 1, 2, 3};
    protected static final int[] edgeVertexPointersHighToLow = new int[]{0, 1, 3, 0, 4, 5, 7, 4, 0, 1, 2, 3};
    protected int[] edgeVertexPointers;
    protected static final int[] edgeVertexPlanesLowToHigh = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0};
    protected static final int[] edgeVertexPlanesHighToLow = new int[]{1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1};
    protected int[] edgeVertexPlanes;
    protected float[] fReturn;
    protected static final V3[] cubeVertexVectors = new V3[]{V3.new3(0.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 1.0f), V3.new3(0.0f, 0.0f, 1.0f), V3.new3(0.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 1.0f), V3.new3(0.0f, 1.0f, 1.0f)};
    protected static final int[] edgeTypeTable = new int[]{0, 2, 0, 2, 0, 2, 0, 2, 1, 1, 1, 1};
    protected final int[] linearOffsets;
    protected static final short[] insideMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};

    public MarchingCubes() {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
    }

    public MarchingCubes(VertexDataServer vertexDataServer, VolumeData volumeData, Parameters parameters, BS bS) {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
        this.excludePartialCubes = true;
        this.surfaceReader = vertexDataServer;
        this.bsVoxels = bS;
        BS[] bSArray = parameters.bsExcluded;
        this.bsExcludedVertices = bSArray[0] == null ? new BS() : bSArray[0];
        this.bsExcludedPlanes = bSArray[2] == null ? new BS() : bSArray[2];
        BS bS2 = this.bsExcludedTriangles = bSArray[3] == null ? new BS() : bSArray[3];
        this.mode = volumeData.getVoxelData() != null || volumeData.mappingPlane != null ? 1 : (bS != null ? 2 : 3);
        this.setParameters(volumeData, parameters);
    }

    protected void setParameters(VolumeData volumeData, Parameters parameters) {
        this.volumeData = volumeData;
        this.colorDensity = parameters.colorDensity;
        this.isContoured = parameters.thePlane == null && parameters.isContoured && !this.colorDensity;
        this.cutoff = parameters.cutoff;
        this.isCutoffAbsolute = parameters.isCutoffAbsolute;
        this.contourType = parameters.contourType;
        this.isSquared = parameters.isSquared;
        this.isXLowToHigh = parameters.isXLowToHigh;
        this.cubeCountX = volumeData.voxelCounts[0] - 1;
        this.cubeCountY = volumeData.voxelCounts[1] - 1;
        this.cubeCountZ = volumeData.voxelCounts[2] - 1;
        volumeData.getYzCount();
        if (parameters.mapLattice != null) {
            this.cubeCountX = (int)((float)this.cubeCountX * Math.abs(parameters.mapLattice.x));
            this.cubeCountY = (int)((float)this.cubeCountY * Math.abs(parameters.mapLattice.y));
            this.cubeCountZ = (int)((float)this.cubeCountZ * Math.abs(parameters.mapLattice.z));
        }
        this.nY = this.cubeCountY + 1;
        this.nZ = this.cubeCountZ + 1;
        this.yzCount = this.nY * this.nZ;
        if (this.bsVoxels == null) {
            this.bsVoxels = new BS();
        }
        this.edgeVertexPointers = this.isXLowToHigh ? edgeVertexPointersLowToHigh : edgeVertexPointersHighToLow;
        this.edgeVertexPlanes = this.isXLowToHigh ? edgeVertexPlanesLowToHigh : edgeVertexPlanesHighToLow;
        this.isoPointIndexPlanes = new int[2][this.yzCount][3];
        this.yzPlanes = this.mode == 3 ? new float[2][this.yzCount] : (float[][])null;
        this.setLinearOffsets();
        this.calcVoxelVertexVectors();
    }

    protected void calcVoxelVertexVectors() {
        int n = 8;
        while (--n >= 0) {
            this.voxelVertexVectors[n] = new V3();
            this.volumeData.transform(cubeVertexVectors[n], this.voxelVertexVectors[n]);
        }
        n = 12;
        while (--n >= 0) {
            this.edgeVectors[n].sub2(this.voxelVertexVectors[edgeVertexes[n + n + 1]], this.voxelVertexVectors[edgeVertexes[n + n]]);
        }
    }

    protected int[][] resetIndexPlane(int[][] nArray) {
        for (int i = 0; i < this.yzCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                nArray[i][j] = Integer.MIN_VALUE;
            }
        }
        return nArray;
    }

    public String getEdgeData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.cubeCountX < 0 || this.cubeCountY < 0 || this.cubeCountZ < 0) {
            return "";
        }
        this.mappingPlane = this.volumeData.mappingPlane;
        this.edgeCount = 0;
        if (this.isXLowToHigh) {
            n5 = 0;
            n4 = this.cubeCountX + (this.colorDensity ? 1 : 0);
            if (this.colorDensity) {
                n4 = this.cubeCountX + 1;
                n3 = this.yzCount - 1;
            } else {
                n4 = this.cubeCountX;
                n3 = this.yzCount - 1 - this.nZ - 1;
            }
            n2 = 1;
            n = this.yzCount;
        } else {
            if (this.colorDensity) {
                n5 = this.cubeCountX;
                n3 = (this.cubeCountX + 1) * this.yzCount - 1;
            } else {
                n5 = this.cubeCountX - 1;
                n3 = this.cubeCountX * this.yzCount - 1 - this.nZ - 1;
            }
            n4 = -1;
            n2 = -1;
            n = -this.yzCount;
        }
        int n6 = n3;
        this.resetIndexPlane(this.isoPointIndexPlanes[1]);
        this.voxelData = null;
        int n7 = this.cubeCountY + (this.colorDensity ? 1 : 0);
        int n8 = this.cubeCountZ + (this.colorDensity ? 1 : 0);
        switch (this.mode) {
            case 3: {
                this.getPlane(n5, false);
                break;
            }
            case 1: {
                this.voxelData = this.volumeData.getVoxelData();
            }
        }
        this.allInside = this.colorDensity && (this.cutoff == 0.0f || this.mode == 2 && this.bsVoxels.nextSetBit(0) < 0);
        boolean bl = this.colorDensity && this.cutoff == 0.0f;
        float f = 0.0f;
        for (int i = n5; i != n4; i += n2) {
            if (this.mode == 3 && i + n2 <= n4) {
                this.getPlane(i + n2, true);
            }
            if (!this.bsExcludedPlanes.get(i) || !this.bsExcludedPlanes.get(i + n2)) {
                int n9;
                if (this.colorDensity) {
                    int n10 = n7;
                    while (--n10 >= 0) {
                        n9 = n8;
                        while (--n9 >= 0) {
                            f = this.getValue(i, n10, n9, n6, 0);
                            if (bl || this.isInside) {
                                this.addVertex(i, n10, n9, n6, f);
                            }
                            --n6;
                        }
                    }
                } else {
                    int[][] nArray = this.isoPointIndexPlanes[0];
                    this.isoPointIndexPlanes[0] = this.isoPointIndexPlanes[1];
                    this.isoPointIndexPlanes[1] = this.resetIndexPlane(nArray);
                    n9 = 1;
                    int n11 = n7;
                    while (--n11 >= 0) {
                        int n12 = n8;
                        while (--n12 >= 0) {
                            int n13 = 0;
                            int n14 = 8;
                            while (--n14 >= 0) {
                                f = this.getValue(i, n11, n12, n6, n14);
                                if (!this.isInside) continue;
                                n13 |= Pwr2[n14];
                            }
                            if (n9 != 0 && !Float.isNaN(f)) {
                                n9 = 0;
                            }
                            if (n13 != 0 && n13 != 255 && this.processOneCubical(n13, i, n11, n12, n6) && !this.isContoured && !this.colorDensity) {
                                this.processTriangles(n13);
                            }
                            --n6;
                        }
                        --n6;
                    }
                    if (n9 != 0) {
                        this.bsExcludedPlanes.set(i);
                    }
                }
            }
            n6 = n3 += n;
        }
        return this.edgeData.toString();
    }

    private float getValue(int n, int n2, int n3, int n4, int n5) {
        float f;
        this.offset = cubeVertexOffsets[n5];
        int n6 = n4 + this.linearOffsets[n5];
        switch (this.mode) {
            case 3: {
                f = this.vertexValues[n5] = this.getValueArray(n + this.offset.x, n2 + this.offset.y, n3 + this.offset.z, n6, this.yzPlanes[yzPlanePts[n5]]);
                this.isInside = this.allInside || this.bsVoxels.get(n6);
                break;
            }
            case 2: {
                boolean bl = this.isInside = this.allInside || this.bsVoxels.get(n6);
                this.vertexValues[n5] = this.bsExcludedVertices.get(n6) ? Float.NaN : (this.isInside ? 1.0f : 0.0f);
                f = this.vertexValues[n5];
                break;
            }
            default: {
                if (this.mappingPlane == null) {
                    f = this.vertexValues[n5] = this.voxelData[n + this.offset.x][n2 + this.offset.y][n3 + this.offset.z];
                } else {
                    this.volumeData.voxelPtToXYZ(n + this.offset.x, n2 + this.offset.y, n3 + this.offset.z, this.pt0);
                    f = this.vertexValues[n5] = this.volumeData.distanceToMappingPlane(this.pt0);
                }
                if (this.isSquared) {
                    int n7 = n5;
                    this.vertexValues[n7] = this.vertexValues[n7] * this.vertexValues[n5];
                }
                boolean bl = this.isInside = this.allInside ? true : MarchingCubes.isInside(this.vertexValues[n5], this.cutoff, this.isCutoffAbsolute);
                if (!this.isInside) break;
                this.bsVoxels.set(n6);
            }
        }
        return f;
    }

    private void getPlane(int n, boolean bl) {
        if (n < 0 || n > this.cubeCountX) {
            return;
        }
        this.surfaceReader.getPlane(n);
        if (bl) {
            float[] fArray = this.yzPlanes[0];
            this.yzPlanes[0] = this.yzPlanes[1];
            this.yzPlanes[1] = fArray;
        }
    }

    protected void processTriangles(int n) {
        byte[] byArray = triangleTable2[n];
        int n2 = byArray.length;
        while ((n2 -= 4) >= 0) {
            this.addTriangle(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
        }
    }

    protected void addVertex(int n, int n2, int n3, int n4, float f) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        if (this.surfaceReader.addVertexCopy(this.pt0, f, -4, true) < 0) {
            this.bsExcludedVertices.set(n4);
        }
    }

    protected void addTriangle(int n, int n2, int n3, int n4) {
        if (!this.bsExcludedTriangles.get(this.nTriangles) && this.surfaceReader.addTriangleCheck(this.edgePointIndexes[n], this.edgePointIndexes[n2], this.edgePointIndexes[n3], n4, 0, this.isCutoffAbsolute, 0) < 0) {
            this.bsExcludedTriangles.set(this.nTriangles);
        }
        ++this.nTriangles;
    }

    protected float getValueArray(int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = n4 % this.yzCount;
        this.bsValues.set(n4);
        float f = this.surfaceReader.getValue(n, n2, n3, n5);
        if (this.isSquared) {
            f *= f;
        }
        fArray[n5] = f;
        if (MarchingCubes.isInside(f, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(n4);
        }
        return f;
    }

    public static boolean isInside(float f, float f2, boolean bl) {
        return f2 > 0.0f && (bl ? Math.abs(f) : f) >= f2 || f2 <= 0.0f && f <= f2;
    }

    protected boolean processOneCubical(int n, int n2, int n3, int n4, int n5) {
        short s = insideMaskTable[n];
        boolean bl = false;
        int n6 = 12;
        while (--n6 >= 0) {
            int n7 = Pwr2[n6];
            if ((s & n7) == 0) continue;
            int n8 = this.edgeVertexPlanes[n6];
            int n9 = (n5 + this.linearOffsets[this.edgeVertexPointers[n6]]) % this.yzCount;
            int n10 = edgeTypeTable[n6];
            this.edgePointIndexes[n6] = this.isoPointIndexPlanes[n8][n9][n10];
            int n11 = this.edgePointIndexes[n6];
            if (n11 != Integer.MIN_VALUE) {
                if (n11 != -1) continue;
                bl = this.excludePartialCubes;
                continue;
            }
            byte by = edgeVertexes[n6 << 1];
            byte by2 = edgeVertexes[(n6 << 1) + 1];
            float f = this.vertexValues[by];
            float f2 = this.vertexValues[by2];
            this.calcVertexPoint(n2, n3, n4, by, this.pointA);
            ++this.edgeCount;
            int n12 = this.surfaceReader.getSurfacePointIndexAndFraction(this.cutoff, this.isCutoffAbsolute, n2, n3, n4, cubeVertexOffsets[by], by, by2, f, f2, this.pointA, this.edgeVectors[n6], n10 == this.contourType, this.fReturn);
            this.isoPointIndexPlanes[n8][n9][n10] = n12;
            this.edgePointIndexes[n6] = n12;
            int n13 = n12;
            this.addEdgeData(n13 < 0 ? Float.NaN : this.fReturn[0]);
            if (!Float.isNaN(this.fReturn[0]) && n13 >= 0) continue;
            bl = this.excludePartialCubes;
        }
        return !bl;
    }

    protected void addEdgeData(float f) {
        char c = JvxlCoder.jvxlFractionAsCharacter(f);
        this.edgeData.appendC(c);
    }

    public void calcVertexPoint(int n, int n2, int n3, int n4, P3 p3) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        p3.add2(this.pt0, this.voxelVertexVectors[n4]);
    }

    protected void setLinearOffsets() {
        this.linearOffsets[0] = 0;
        this.linearOffsets[1] = this.yzCount;
        this.linearOffsets[2] = this.yzCount + 1;
        this.linearOffsets[3] = 1;
        this.linearOffsets[4] = this.nZ;
        this.linearOffsets[5] = this.yzCount + this.nZ;
        this.linearOffsets[6] = this.yzCount + this.nZ + 1;
        this.linearOffsets[7] = this.nZ + 1;
    }

    public int getLinearOffset(int n, int n2, int n3, int n4) {
        return n * this.yzCount + n2 * this.nZ + n3 + this.linearOffsets[n4];
    }
}

