/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericMenuInterface;
import javajs.api.SC;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.popup.AwtSwingComponent;
import org.jmol.popup.PopupHelper;

public class AwtSwingPopupHelper
implements ActionListener,
ItemListener,
MouseListener,
PopupHelper {
    private GenericMenuInterface popup;
    private Map<Object, SC> htSources = new Hashtable<Object, SC>();
    private ButtonGroup buttonGroup;

    public AwtSwingPopupHelper(GenericMenuInterface genericMenuInterface) {
        this.popup = genericMenuInterface;
    }

    @Override
    public SC menuCreatePopup(String string, Object object) {
        return AwtSwingComponent.getPopup(string, this.htSources);
    }

    @Override
    public SC getRadio(String string) {
        return AwtSwingComponent.getRadio(string, this.htSources);
    }

    @Override
    public SC getCheckBox(String string) {
        return AwtSwingComponent.getCheckBox(string, this.htSources);
    }

    @Override
    public SC getMenu(String string) {
        return AwtSwingComponent.getMenu(string, this.htSources);
    }

    @Override
    public SC getMenuItem(String string) {
        return AwtSwingComponent.getMenuItem(string, this.htSources);
    }

    @Override
    public void menuAddButtonGroup(SC sC) {
        if (sC == null) {
            this.buttonGroup = null;
            return;
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        this.buttonGroup.add((AbstractButton)sC);
    }

    @Override
    public Object getButtonGroup() {
        return this.buttonGroup;
    }

    @Override
    public void menuInsertSubMenu(SC sC, SC sC2, int n) {
        sC.insert(sC2, n);
    }

    @Override
    public int getItemType(SC sC) {
        if (sC == null) {
            return 0;
        }
        JComponent jComponent = ((AwtSwingComponent)sC).jc;
        return jComponent instanceof JMenu ? 4 : (jComponent instanceof JRadioButtonMenuItem ? 3 : (jComponent instanceof JCheckBoxMenuItem ? 2 : (sC.getText() != null ? 1 : 0)));
    }

    @Override
    public SC getSwingComponent(Object object) {
        return object == null ? null : this.htSources.get(object);
    }

    @Override
    public void menuClearListeners(SC sC) {
        if (sC == null) {
            return;
        }
        this.clearListeners(sC.getComponents());
        this.clearListener(((AwtSwingComponent)sC).ab);
    }

    private void clearListener(AbstractButton abstractButton) {
        if (abstractButton != null) {
            try {
                abstractButton.removeMouseListener(this);
                abstractButton.removeActionListener(this);
                abstractButton.removeItemListener(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearListeners(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            JComponent jComponent = (JComponent)objectArray[i];
            if (!(jComponent instanceof JMenu)) continue;
            this.clearListeners(jComponent.getComponents());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.popup.menuCheckBoxCallback(this.getSource(itemEvent));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.popup.menuClickCallback(this.getSource(actionEvent), actionEvent.getActionCommand());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
            this.popup.menuFocusCallback(jMenuItem.getName(), jMenuItem.getActionCommand(), true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
            this.popup.menuFocusCallback(jMenuItem.getName(), jMenuItem.getActionCommand(), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private SC getSource(EventObject eventObject) {
        return this.getSwingComponent(eventObject.getSource());
    }
}

