/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.BeginEndInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class IRScriptBody
extends IRScope {
    private List<IRClosure> beginBlocks;
    private DynamicScope toplevelScope = null;
    private String fileName;

    public IRScriptBody(IRManager manager, String sourceName, StaticScope staticScope) {
        super(manager, null, sourceName, 0, staticScope);
        this.fileName = sourceName;
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    public DynamicScope getToplevelScope() {
        return this.toplevelScope;
    }

    public void setTopLevelBindingScope(DynamicScope tlbScope) {
        this.toplevelScope = tlbScope;
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new BeginEndInterpreterContext(this, instructions);
        return this.interpreterContext;
    }

    @Override
    public int getNearestModuleReferencingScopeDepth() {
        return 0;
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.SCRIPT_BODY;
    }

    @Override
    public String toString() {
        return "Script: file: " + this.getFileName() + super.toString();
    }

    @Override
    public void recordBeginBlock(IRClosure beginBlockClosure) {
        if (this.beginBlocks == null) {
            this.beginBlocks = new ArrayList<IRClosure>();
        }
        beginBlockClosure.setBeginEndBlock();
        this.beginBlocks.add(beginBlockClosure);
    }

    @Override
    public List<IRClosure> getBeginBlocks() {
        return this.beginBlocks;
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

