/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public abstract class EncodingOperations {
    public static Encoding getEncoding(DynamicObject rubyEncoding) {
        Encoding encoding = Layouts.ENCODING.getEncoding(rubyEncoding);
        if (encoding == null) {
            CompilerDirectives.transferToInterpreter();
            ByteList name = Layouts.ENCODING.getName(rubyEncoding);
            encoding = EncodingOperations.loadEncoding(name);
            Layouts.ENCODING.setEncoding(rubyEncoding, encoding);
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    private static EncodingDB.Entry findEncodingEntry(ByteList bytes) {
        return (EncodingDB.Entry)EncodingDB.getEncodings().get(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    @CompilerDirectives.TruffleBoundary
    private static EncodingDB.Entry findAliasEntry(ByteList bytes) {
        return (EncodingDB.Entry)EncodingDB.getAliases().get(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    private static EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes) {
        EncodingDB.Entry e = EncodingOperations.findEncodingEntry(bytes);
        return e != null ? e : EncodingOperations.findAliasEntry(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    private static Encoding loadEncoding(ByteList name) {
        EncodingDB.Entry entry = EncodingOperations.findEncodingOrAliasEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getEncoding();
    }
}

