/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.common.IRubyWarnings;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;

public class Warnings {
    private final RubyContext context;

    public Warnings(RubyContext context) {
        this.context = context;
    }

    public void warn(String format, Object ... args) {
        CompilerDirectives.transferToInterpreter();
        this.warn(String.format(format, args));
    }

    public void warn(String message) {
        CompilerDirectives.transferToInterpreter();
        SourceSection sourceSection = RubyCallStack.getTopMostUserCallNode().getEncapsulatingSourceSection();
        this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, sourceSection.getSource().getName(), sourceSection.getStartLine(), message);
    }
}

