// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Base, BufferInStream, Command, DecryptAndVerifyEngine, E, MyEngine, TrackSubSubCommand, User, add_option_dict, athrow, chain, codesign, fs, gpg, iced, keypull, log, make_esc, master_ring, path, write_tmp_file, __iced_k, __iced_k_noop, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  codesign = require('codesign');

  path = require('path');

  fs = require('fs');

  Base = require('./base').Base;

  log = require('../log');

  add_option_dict = require('./argparse').add_option_dict;

  E = require('../err').E;

  TrackSubSubCommand = require('../tracksubsub').TrackSubSubCommand;

  gpg = require('../gpg').gpg;

  _ref = require('iced-error'), make_esc = _ref.make_esc, chain = _ref.chain;

  athrow = require('iced-utils').util.athrow;

  User = require('../user').User;

  keypull = require('../keypull').keypull;

  BufferInStream = require('iced-spawn').BufferInStream;

  master_ring = require('../keyring').master_ring;

  write_tmp_file = require('iced-utils').fs.write_tmp_file;

  DecryptAndVerifyEngine = require('../dve').DecryptAndVerifyEngine;

  MyEngine = (function(_super) {
    __extends(MyEngine, _super);

    function MyEngine(_arg) {
      var argv;
      argv = _arg.argv;
      this._tmp_files = {};
      MyEngine.__super__.constructor.call(this, {
        argv: argv
      });
    }

    MyEngine.prototype.write_tmp = function(_arg, cb) {
      var data, err, file, nm, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      file = _arg.file, data = _arg.data;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "MyEngine.write_tmp"
          });
          write_tmp_file({
            data: data,
            base: file,
            mode: 0x180
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return nm = arguments[1];
              };
            })(),
            lineno: 29
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this._tmp_files[file] = nm;
            log.debug("| writing " + file + " tmpfile " + nm);
          }
          return cb(err);
        };
      })(this));
    };

    MyEngine.prototype.cleanup_run1 = function(cb) {
      var err, k, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if (_this.argv.preserve_tmp_files) {
            return __iced_k(log.debug("| preserving temporary files by command-line flag"));
          } else {
            (function(__iced_k) {
              var _i, _k, _keys, _ref1, _results, _while;
              _ref1 = _this._tmp_files;
              _keys = (function() {
                var _results1;
                _results1 = [];
                for (_k in _ref1) {
                  _results1.push(_k);
                }
                return _results1;
              })();
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _keys.length)) {
                  return _break();
                } else {
                  k = _keys[_i];
                  v = _ref1[k];
                  log.debug("| unlink " + v);
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                      funcname: "MyEngine.cleanup_run1"
                    });
                    fs.unlink(v, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 43
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return _next(typeof err !== "undefined" && err !== null ? log.warn("Could not remove tmp file " + v + ": " + err.message) : void 0);
                  });
                }
              };
              _while(__iced_k);
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb();
        };
      })(this));
    };

    MyEngine.prototype.patch_gpg_args = function(args) {
      return args.push("--verify");
    };

    MyEngine.prototype.get_files = function(args) {
      args.push(this._tmp_files.sig);
      return args.push(this._tmp_files.payload);
    };

    MyEngine.prototype.run1 = function(_arg, cb) {
      var err, esc, payload, signature, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, payload = _arg.payload, signature = _arg.signature;
      cb = chain(cb, this.cleanup_run1.bind(this));
      esc = make_esc(cb, "MyEngine::run_one");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "MyEngine.run1"
          });
          _this.write_tmp({
            file: "payload",
            data: payload
          }, esc(__iced_deferrals.defer({
            lineno: 64
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
              funcname: "MyEngine.run1"
            });
            _this.write_tmp({
              file: "sig",
              data: signature
            }, esc(__iced_deferrals.defer({
              lineno: 65
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                funcname: "MyEngine.run1"
              });
              _this.run(esc(__iced_deferrals.defer({
                lineno: 66
              })));
              __iced_deferrals._fulfill();
            })(function() {
              err = null;
              if (_this.username !== username) {
                err = E.UsernameMismatchError("bad username: wanted " + username + " but got " + _this.username);
              }
              return cb(err);
            });
          });
        };
      })(this));
    };

    return MyEngine;

  })(DecryptAndVerifyEngine);

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.DIR_OPT = {
      nargs: '?',
      action: 'store',
      type: 'string',
      help: 'the directory to sign/verify',
      defaultValue: '.'
    };

    Command.prototype.SIGN_OPTS = {
      o: {
        alias: 'output',
        type: 'string',
        help: 'the output file'
      },
      p: {
        alias: 'presets',
        action: 'store',
        type: 'string',
        help: 'specify ignore presets, comma-separated',
        defaultValue: 'git,dropbox,kb'
      },
      q: {
        alias: 'quiet',
        action: 'storeTrue',
        help: 'withhold output unless an error'
      }
    };

    Command.prototype.VERIFY_OPTS = {
      i: {
        alias: 'input',
        type: 'string',
        help: 'the input file'
      },
      q: {
        alias: 'quiet',
        action: 'storeTrue',
        help: 'withhold output unless an error'
      },
      s: {
        alias: 'strict',
        action: 'storeTrue',
        help: 'fail on warnings (typically cross-platform problems)'
      },
      P: {
        alias: 'preserve-tmp-files',
        action: 'storeTrue',
        help: 'preserve temp files for debugging and inspection'
      },
      "ignore-verify-errors": {
        action: 'storeTrue',
        help: 'ignore verify errors and continue to tracking'
      }
    };

    Command.prototype.TOJSON_OPTS = {
      i: {
        alias: 'input',
        type: 'string',
        help: 'the input file to convert to JSON',
        defaultValue: codesign.constants.defaults.FILENAME
      }
    };

    Command.prototype.is_batch = function() {
      return false;
    };

    Command.prototype.set_argv = function(a) {
      return Command.__super__.set_argv.call(this, a);
    };

    Command.prototype.copy = function(d) {
      var k, v, x;
      x = {};
      for (k in d) {
        v = d[k];
        x[k] = v;
      }
      return x;
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, ss1, ss2, sub, sub2;
      opts = {
        aliases: ["code-sign"],
        help: "sign or verify a directory's contents"
      };
      name = "dir";
      sub = scp.addParser(name, opts);
      sub2 = sub.addSubparsers({
        title: "dir subcommand",
        dest: "dir_subcommand"
      });
      ss1 = sub2.addParser("sign", {
        help: "sign a directory's contents"
      });
      add_option_dict(ss1, this.SIGN_OPTS);
      ss1.addArgument(['dir'], this.copy(this.DIR_OPT));
      ss2 = sub2.addParser("verify", {
        help: "verify a directory's contents"
      });
      add_option_dict(ss2, this.VERIFY_OPTS);
      add_option_dict(ss2, DecryptAndVerifyEngine.OPTS);
      ss2.addArgument(['dir'], this.copy(this.DIR_OPT));
      return opts.aliases.concat([name]);
    };

    Command.prototype.do_sign = function(payload, cb) {
      var esc, gargs, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::do_sign");
      gargs = {
        args: ["--sign", "--detach-sign", "-a", "-u", this.me.fingerprint(true)],
        stdin: new BufferInStream(new Buffer(payload, 'utf8'))
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "Command.do_sign"
          });
          master_ring().gpg(gargs, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return out = arguments[0];
              };
            })(),
            lineno: 190
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null, out.toString('utf8'));
        };
      })(this));
    };

    Command.prototype.load_me = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "Command.load_me"
          });
          User.load_me({
            secret: true
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.me = arguments[1];
              };
            })(_this),
            lineno: 196
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.get_preset_list = function(cb) {
      var err, k, presets, valid_presets, _i, _len;
      err = null;
      presets = this.argv.presets.split(',');
      valid_presets = (function() {
        var _results;
        _results = [];
        for (k in codesign.constants.presets) {
          _results.push(k);
        }
        return _results;
      })();
      for (_i = 0, _len = presets.length; _i < _len; _i++) {
        k = presets[_i];
        if (!codesign.CodeSign.is_valid_preset(k)) {
          err = new E.ArgsError("Unknown preset " + k + " (valid values = " + (valid_presets.join(',')) + ")");
          presets = null;
          break;
        }
      }
      return cb(err, presets);
    };

    Command.prototype.get_ignore_list = function() {
      var ignore, rel_ignore;
      rel_ignore = path.relative(this.argv.dir, this.signed_file()).split(path.sep).join('/');
      ignore = rel_ignore.slice(0, 2) !== '..' ? ["/" + rel_ignore] : [];
      return ignore;
    };

    Command.prototype.signed_file = function() {
      return this.argv.input || this.argv.output || path.join(this.argv.dir, codesign.constants.defaults.FILENAME);
    };

    Command.prototype.target_file_to_json = function(fname, cb) {
      var body, err, f_err, obj, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);

      /*
      returns     null, null  # if there is no target file,
      otherwise:  err, obj
       */
      log.debug("+ Command::target_file_to_json");
      obj = null;
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "Command.target_file_to_json"
          });
          fs.readFile(fname, 'utf8', __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                f_err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 235
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof body !== "undefined" && body !== null) {
            obj = codesign.markdown_to_obj(body);
            if (obj == null) {
              err = new E.CorruptionError("Could not parse file " + fname);
            }
          }
          log.debug("- Command::target_file_to_json");
          return cb(err, obj);
        };
      })(this));
    };

    Command.prototype.process_probs = function(probs, cb) {

      /*
      outputs warning and errors based on strict/quiet settings,
      and calls back with error if appropriate
       */
      var err, err_table, p, warn_table, _i, _j, _len, _len1, _ref1, _ref2;
      err_table = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = probs.length; _i < _len; _i++) {
          p = probs[_i];
          if ((p[0] >= 100) || this.argv.strict) {
            _results.push(p);
          }
        }
        return _results;
      }).call(this);
      warn_table = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = probs.length; _i < _len; _i++) {
          p = probs[_i];
          if ((p[0] < 100) && (!this.argv.strict) && (!this.argv.quiet)) {
            _results.push(p);
          }
        }
        return _results;
      }).call(this);
      err = null;
      if (warn_table.length) {
        for (_i = 0, _len = warn_table.length; _i < _len; _i++) {
          p = warn_table[_i];
          log.warn("" + p[0] + "\t" + (((_ref1 = p[1].expected) != null ? _ref1.path : void 0) || p[1].got.path) + ":  " + p[1].msg);
        }
      }
      if (err_table.length) {
        for (_j = 0, _len1 = err_table.length; _j < _len1; _j++) {
          p = err_table[_j];
          log.error("" + p[0] + "\t" + (((_ref2 = p[1].expected) != null ? _ref2.path : void 0) || p[1].got.path) + ":  " + p[1].msg);
        }
        if (!this.argv.ignore_verify_errors) {
          err = new Error("Exited after " + err_table.length + " error(s)");
        }
      }
      return cb(err, {
        warnings: warn_table.length,
        errors: err_table.length
      });
    };

    Command.prototype.keybase_username_from_signer = function(s, cb) {
      var m, rxx;
      rxx = /^https:\/\/keybase.io\/([^\s\n]+)$/g;
      if ((m = rxx.exec(s)) != null) {
        return cb(null, m[1]);
      } else {
        return cb(new Error('Could not extract a keybase username from signer'));
      }
    };

    Command.prototype.verify = function(cb) {
      var eng, err, err_dummy, esc, json_obj, payload, probs, signature, signer, summ, username, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ Command::verify");
      esc = make_esc(cb, "Command::verify");
      eng = new MyEngine({
        argv: this.argv
      });
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "Command.verify"
          });
          eng.global_init(esc(__iced_deferrals.defer({
            lineno: 278
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
              funcname: "Command.verify"
            });
            _this.target_file_to_json(_this.signed_file(), esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return json_obj = arguments[0];
                };
              })(),
              lineno: 281
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              if (typeof json_obj === "undefined" || json_obj === null) {
                err = new E.NotFoundError("Could not open " + (_this.signed_file()));
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                    funcname: "Command.verify"
                  });
                  athrow(err, esc(__iced_deferrals.defer({
                    lineno: 285
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              payload = codesign.CodeSign.json_obj_to_signable_payload(json_obj);
              (function(__iced_k) {
                var _i, _len, _ref1, _results, _while;
                _ref1 = json_obj.signatures;
                _len = _ref1.length;
                _i = 0;
                _results = [];
                _while = function(__iced_k) {
                  var _break, _continue, _next, _ref2;
                  _break = function() {
                    return __iced_k(_results);
                  };
                  _continue = function() {
                    return iced.trampoline(function() {
                      ++_i;
                      return _while(__iced_k);
                    });
                  };
                  _next = function(__iced_next_arg) {
                    _results.push(__iced_next_arg);
                    return _continue();
                  };
                  if (!(_i < _len)) {
                    return _break();
                  } else {
                    _ref2 = _ref1[_i], signature = _ref2.signature, signer = _ref2.signer;
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                        funcname: "Command.verify"
                      });
                      _this.keybase_username_from_signer(signer, esc(__iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return username = arguments[0];
                          };
                        })(),
                        lineno: 290
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                          funcname: "Command.verify"
                        });
                        eng.run1({
                          payload: payload,
                          username: username,
                          signature: signature
                        }, esc(__iced_deferrals.defer({
                          lineno: 292
                        })));
                        __iced_deferrals._fulfill();
                      })(_next);
                    });
                  }
                };
                _while(__iced_k);
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                    funcname: "Command.verify"
                  });
                  eng.global_cleanup(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return err_dummy = arguments[0];
                      };
                    })(),
                    lineno: 295
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  summ = new codesign.CodeSign(_this.argv.dir, {
                    ignore: json_obj.ignore,
                    presets: json_obj.presets
                  });
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                      funcname: "Command.verify"
                    });
                    summ.walk(esc(__iced_deferrals.defer({
                      lineno: 299
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                        funcname: "Command.verify"
                      });
                      summ.compare_to_json_obj(json_obj, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return probs = arguments[0];
                          };
                        })(),
                        lineno: 300
                      }));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                          funcname: "Command.verify"
                        });
                        _this.process_probs(probs, esc(__iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              return warnings = arguments[0].warnings;
                            };
                          })(),
                          lineno: 301
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        if (!_this.argv.quiet) {
                          log.info("Success! " + json_obj.signatures.length + " signature(s) verified;" + (" " + json_obj.found.length + " items checked") + (warnings ? " with " + warnings + " warning(s); pass --strict to prevent success on warnings; --quiet to hide warnings" : ''));
                        }
                        log.debug("- Command::verify");
                        return cb();
                      });
                    });
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    Command.prototype.sign = function(cb) {
      var cs, esc, json_obj, md, my_username, old_err, old_obj, preset_list, probs, sig, signature, signer, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ Command::sign");
      esc = make_esc(cb, "Command::sign");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
            funcname: "Command.sign"
          });
          keypull({
            stdin_blocked: _this.is_batch(),
            need_secret: true
          }, esc(__iced_deferrals.defer({
            lineno: 320
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
              funcname: "Command.sign"
            });
            _this.load_me(esc(__iced_deferrals.defer({
              lineno: 321
            })));
            __iced_deferrals._fulfill();
          })(function() {
            my_username = "https://keybase.io/" + (_this.me.username());
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                funcname: "Command.sign"
              });
              _this.get_preset_list(esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return preset_list = arguments[0];
                  };
                })(),
                lineno: 328
              })));
              __iced_deferrals._fulfill();
            })(function() {
              cs = new codesign.CodeSign(_this.argv.dir, {
                ignore: _this.get_ignore_list(),
                presets: preset_list
              });
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                  funcname: "Command.sign"
                });
                cs.walk(esc(__iced_deferrals.defer({
                  lineno: 330
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                    funcname: "Command.sign"
                  });
                  _this.target_file_to_json(_this.signed_file(), __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        old_err = arguments[0];
                        return old_obj = arguments[1];
                      };
                    })(),
                    lineno: 336
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    if (typeof old_obj !== "undefined" && old_obj !== null) {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                          funcname: "Command.sign"
                        });
                        cs.compare_to_json_obj(old_obj, __iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              return probs = arguments[0];
                            };
                          })(),
                          lineno: 338
                        }));
                        __iced_deferrals._fulfill();
                      })(function() {
                        var _i, _len, _ref1, _ref2;
                        if (!probs.length) {
                          if (!_this.argv.quiet) {
                            log.info("Found existing " + (_this.signed_file()));
                          }
                          _ref1 = old_obj.signatures;
                          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                            _ref2 = _ref1[_i], signer = _ref2.signer, signature = _ref2.signature;
                            if (!(signer !== my_username)) {
                              continue;
                            }
                            cs.attach_sig(signer, signature);
                            log.info("Re-attaching still-valid signature from " + signer);
                          }
                        } else {
                          if (!_this.argv.quiet) {
                            log.info("Will replace existing/obsolete " + (_this.signed_file()));
                          }
                        }
                        return __iced_k();
                      });
                    } else {
                      return __iced_k();
                    }
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                        funcname: "Command.sign"
                      });
                      _this.do_sign(cs.signable_payload(), esc(__iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return sig = arguments[0];
                          };
                        })(),
                        lineno: 351
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      cs.attach_sig(my_username, sig);
                      json_obj = cs.to_json_obj();
                      md = codesign.obj_to_markdown(json_obj);
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                          funcname: "Command.sign"
                        });
                        fs.writeFile(_this.signed_file(), md, {
                          encoding: 'utf8'
                        }, esc(__iced_deferrals.defer({
                          lineno: 359
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        if (!_this.argv.quiet) {
                          log.info("Success! Wrote " + (_this.signed_file()) + " from " + json_obj.found.length + " found items");
                        }
                        log.debug("- Command::sign");
                        return cb();
                      });
                    });
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      log.debug("+ Command::run");
      (function(_this) {
        return (function(__iced_k) {
          switch (_this.argv.dir_subcommand) {
            case 'sign':
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                  funcname: "Command.run"
                });
                _this.sign(esc(__iced_deferrals.defer({
                  lineno: 372
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
              break;
            case 'verify':
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                  funcname: "Command.run"
                });
                _this.verify(esc(__iced_deferrals.defer({
                  lineno: 373
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
              break;
            case 'tojson':
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/dir.iced",
                  funcname: "Command.run"
                });
                _this.tojson(esc(__iced_deferrals.defer({
                  lineno: 374
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
              break;
            default:
              return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- Command::run");
          return cb(null);
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
