/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.attachment;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.attachment.IAttachmentSupport;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AttachmentTools {
    private static final Attribute ATTR_ATTACHMENTS = new Attribute("attachments");
    private static final Attachment[] EMPTY = new Attachment[0];
    private static final Map<Object, List<Attachment>> objectAttachments = new WeakHashMap<Object, List<Attachment>>();
    private static final ThreadLocal<List<Attachment>> threadAttachments = new ThreadLocal();

    public static void addAttachment(Attachment attachment) {
        if (attachment == null) {
            return;
        }
        List<Attachment> list = AttachmentTools.basicGetAttachments();
        list.add(attachment);
    }

    public static void addAttachment(Object object, Attachment attachment) {
        if (attachment == null) {
            return;
        }
        List<Attachment> list = AttachmentTools.basicGetAttachments(object);
        list.add(attachment);
    }

    public static void addAttachment(Object object, String string, Object object2) {
        AttachmentTools.addAttachment(object, new Attachment(string, object2));
    }

    public static void addAttachment(String string, Object object) {
        AttachmentTools.addAttachment(new Attachment(string, object));
    }

    public static void addAttachments(Attachment[] attachmentArray) {
        if (attachmentArray == null) {
            return;
        }
        List<Attachment> list = AttachmentTools.basicGetAttachments();
        list.addAll(Arrays.asList(attachmentArray));
    }

    public static void addAttachments(List<Attachment> list) {
        if (list == null) {
            return;
        }
        for (Attachment object2 : list) {
        }
        List<Attachment> list2 = AttachmentTools.basicGetAttachments();
        list2.addAll(list);
    }

    public static void addAttachments(Object object, Attachment[] attachmentArray) {
        if (attachmentArray == null) {
            return;
        }
        List<Attachment> list = AttachmentTools.basicGetAttachments(object);
        list.addAll(Arrays.asList(attachmentArray));
    }

    public static void addAttachments(Object object, List<Attachment> list) {
        if (list == null) {
            return;
        }
        for (Attachment object22 : list) {
        }
        List<Attachment> list2 = AttachmentTools.basicGetAttachments(object);
        list2.addAll(list);
    }

    protected static List<Attachment> basicGetAttachments() {
        List<Attachment> list = threadAttachments.get();
        if (list == null) {
            list = new ArrayList<Attachment>();
            threadAttachments.set(list);
        }
        return list;
    }

    protected static List<Attachment> basicGetAttachments(Object object) {
        if (object instanceof IAttachmentSupport) {
            return ((IAttachmentSupport)object).getAttachments();
        }
        if (object instanceof IAttributeSupport) {
            ArrayList arrayList = (ArrayList)((IAttributeSupport)object).getAttribute(ATTR_ATTACHMENTS);
            if (arrayList == null) {
                arrayList = new ArrayList();
                ((IAttributeSupport)object).setAttribute(ATTR_ATTACHMENTS, arrayList);
            }
            return arrayList;
        }
        List<Attachment> list = objectAttachments.get(object);
        if (list == null) {
            list = new ArrayList<Attachment>();
            objectAttachments.put(object, list);
        }
        return list;
    }

    protected static List<Attachment> basicLookupAttachments() {
        List<Attachment> list = threadAttachments.get();
        return list;
    }

    protected static List<Attachment> basicLookupAttachments(Object object) {
        if (object instanceof IAttachmentSupport) {
            return ((IAttachmentSupport)object).getAttachments();
        }
        if (object instanceof IAttributeSupport) {
            List list = (List)((IAttributeSupport)object).getAttribute(ATTR_ATTACHMENTS);
            return list;
        }
        List<Attachment> list = objectAttachments.get(object);
        return list;
    }

    public static void clearAttachments() {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return;
        }
        list.clear();
    }

    public static void clearAttachments(Object object) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return;
        }
        list.clear();
    }

    public static Attachment getAttachment(Object object, String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return null;
        }
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            return attachment;
        }
        return null;
    }

    public static Attachment getAttachment(String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return null;
        }
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            return attachment;
        }
        return null;
    }

    public static Attachment[] getAttachments() {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return EMPTY;
        }
        return list.toArray(new Attachment[list.size()]);
    }

    public static Attachment[] getAttachments(Object object) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return EMPTY;
        }
        return list.toArray(new Attachment[list.size()]);
    }

    public static Attachment[] getAttachments(Object object, String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return EMPTY;
        }
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            arrayList.add(attachment);
        }
        return arrayList.toArray(new Attachment[arrayList.size()]);
    }

    public static Attachment[] getAttachments(String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return EMPTY;
        }
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            arrayList.add(attachment);
        }
        return arrayList.toArray(new Attachment[arrayList.size()]);
    }

    public static boolean hasAttachment(Object object, String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return false;
        }
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttachment(String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return false;
        }
        for (Attachment attachment : list) {
            if (!string.equals(attachment.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean removeAttached(Object object) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return false;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment = iterator.next();
            if (attachment.getAttached() != object) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static boolean removeAttached(Object object, Object object2) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return false;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment = iterator.next();
            if (attachment.getAttached() != object2) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static boolean removeAttachment(Attachment attachment) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return false;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment2 = iterator.next();
            if (attachment2 != attachment) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static boolean removeAttachment(Object object, Attachment attachment) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return false;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment2 = iterator.next();
            if (attachment2 != attachment) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static void removeAttachments(Object object, String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments(object);
        if (list == null) {
            return;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment = iterator.next();
            if (!string.equals(attachment.getKey())) continue;
            iterator.remove();
        }
    }

    public static void removeAttachments(String string) {
        List<Attachment> list = AttachmentTools.basicLookupAttachments();
        if (list == null) {
            return;
        }
        Iterator<Attachment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attachment attachment = iterator.next();
            if (!string.equals(attachment.getKey())) continue;
            iterator.remove();
        }
    }
}

