/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.dom.ElementArgsAdapter;
import de.intarsys.tools.dom.IElementConfigurable;
import de.intarsys.tools.dom.IElementConfigurator;
import de.intarsys.tools.dom.PACKAGE;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorFieldHandler;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgsConfigurable;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ElementTools {
    private static final Logger Log = PACKAGE.Log;
    private static Pattern splitPattern = Pattern.compile("\\.");

    protected static InvocationHandler basicCreateInvocationHandler(Element element, Class[] classArray, ClassLoader classLoader) throws ObjectCreationException {
        return new ElementProxyInvocationHandler(element, classArray, classLoader);
    }

    protected static Object basicCreateProxy(Element element, Class[] classArray, ClassLoader classLoader) throws ObjectCreationException {
        Class[] classArray2 = new Class[classArray.length + 1];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[classArray2.length - 1] = IAttributeSupport.class;
        InvocationHandler invocationHandler = ElementTools.basicCreateInvocationHandler(element, classArray2, classLoader);
        return Proxy.newProxyInstance(classLoader, classArray2, invocationHandler);
    }

    protected static Class basicCreateProxyClass(Element element, Class[] classArray, ClassLoader classLoader) throws ObjectCreationException {
        Class[] classArray2 = new Class[classArray.length + 1];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[classArray2.length - 1] = IAttributeSupport.class;
        return Proxy.getProxyClass(classLoader, classArray2);
    }

    public static <T> Class<T> createClass(Element element, String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        String string2 = ElementTools.getString(element, string, null);
        if (string2 == null) {
            throw new ObjectCreationException("class name missing");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        String[] stringArray = string2.split("\\;");
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n].trim();
            try {
                classArray[n] = Class.forName(string3, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjectCreationException("class '" + string2 + "' not found", classNotFoundException);
            }
            ++n;
        }
        Class clazz2 = classArray.length > 1 ? ElementTools.basicCreateProxyClass(element, classArray, classLoader) : classArray[0];
        return clazz2;
    }

    protected static IFieldHandler createFieldHandler(Element element, Object object, ClassLoader classLoader) throws ObjectCreationException {
        Element element2;
        if (element == null) {
            return null;
        }
        if (ElementTools.getString(element, "class", null) != null || ElementTools.getString(element, "factory", null) != null) {
            return ElementTools.createObject(element, IFieldHandler.class, classLoader);
        }
        FunctorFieldHandler functorFieldHandler = new FunctorFieldHandler();
        Element element3 = ElementTools.getFirstElement(element, "get");
        if (element3 != null) {
            functorFieldHandler.setGetter(ElementTools.createFunctor(element3, object, classLoader));
        }
        if ((element2 = ElementTools.getFirstElement(element, "set")) != null) {
            functorFieldHandler.setSetter(ElementTools.createFunctor(element2, object, classLoader));
        }
        functorFieldHandler.setName(ElementTools.getString(element, "name", "unknown"));
        return functorFieldHandler;
    }

    public static IFunctor createFunctor(Element element, Object object, ClassLoader classLoader) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        IFunctor iFunctor = null;
        if (ElementTools.getString(element, "class", null) != null || ElementTools.getString(element, "factory", null) != null) {
            iFunctor = ElementTools.createObject(element, IFunctor.class, classLoader);
        }
        return iFunctor;
    }

    public static <T> T createObject(Element element, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        return ElementTools.createObject(element, null, clazz, classLoader);
    }

    public static <T> T createObject(Element element, String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        if (StringTools.isEmpty(string)) {
            String string2 = "ref";
            String string3 = ElementTools.getString(element, string2, null);
            if (string3 != null) {
                return ElementTools.createObjectFromContainer(element, string3, clazz, classLoader);
            }
            string2 = "class";
            string3 = ElementTools.getString(element, string2, null);
            if (string3 != null) {
                return ElementTools.createObjectFromClass(element, string3, clazz, classLoader);
            }
            string2 = "factory";
            string3 = ElementTools.getString(element, string2, null);
            if (string3 != null) {
                return ElementTools.createObjectFromFactory(element, string3, clazz, classLoader);
            }
            Iterator<Element> iterator = ElementTools.getElementsIterator(element);
            if (iterator.hasNext()) {
                return ElementTools.createObject(null, iterator.next(), clazz, classLoader);
            }
            throw new ObjectCreationException("can't create object (no 'ref', 'class' or 'factory'");
        }
        String string4 = string;
        String string5 = ElementTools.getString(element, string4, null);
        if (string5 != null) {
            return ElementTools.createObjectFromClass(element, string5, clazz, classLoader);
        }
        string4 = String.valueOf(string) + "ref";
        string5 = ElementTools.getString(element, string4, null);
        if (string5 != null) {
            return ElementTools.createObjectFromContainer(element, string5, clazz, classLoader);
        }
        string4 = String.valueOf(string) + "class";
        string5 = ElementTools.getString(element, string4, null);
        if (string5 != null) {
            return ElementTools.createObjectFromClass(element, string5, clazz, classLoader);
        }
        string4 = String.valueOf(string) + "factory";
        string5 = ElementTools.getString(element, string4, null);
        if (string5 != null) {
            return ElementTools.createObjectFromFactory(element, string5, clazz, classLoader);
        }
        throw new ObjectCreationException("can't create object");
    }

    public static <T> T createObject(Object object, Element element, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        String string = element.getTagName();
        if ("object".equals(string)) {
            return ElementTools.createObject(element, clazz, classLoader);
        }
        if ("value".equals(string)) {
            String string2 = element.getTextContent();
            String string3 = ElementTools.getString(element, "type", null);
            return (T)ObjectTools.convert(string2, string3, classLoader);
        }
        if ("args".equals(string)) {
            return null;
        }
        if ("null".equals(string)) {
            return null;
        }
        if ("perform".equals(string)) {
            return null;
        }
        if ("accessor".equals(string)) {
            return (T)ElementTools.createFieldHandler(element, object, classLoader);
        }
        throw new ObjectCreationException("unknown value element '" + string + "'");
    }

    protected static <T> T createObjectFromClass(Element element, String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        if (string == null) {
            throw new ObjectCreationException("class name missing");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        String[] stringArray = string.split("\\;");
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            try {
                classArray[n] = Class.forName(string2, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjectCreationException("class '" + string + "' not found", classNotFoundException);
            }
            ++n;
        }
        Object object = classArray.length > 1 || classArray[0].isInterface() ? ElementTools.basicCreateProxy(element, classArray, classLoader) : ObjectTools.createObject(classArray[0], clazz);
        try {
            if (object instanceof IClassLoaderAccess) {
                ((IClassLoaderAccess)object).setClassLoader(classLoader);
            }
            if (object instanceof IElementConfigurable) {
                ((IElementConfigurable)object).configure(element);
            }
            if (object instanceof IArgsConfigurable) {
                ((IArgsConfigurable)object).configure(new ElementArgsAdapter(element));
            }
            ElementTools.setProperties(object, element, classLoader);
            if (object instanceof IInitializeable) {
                ((IInitializeable)object).initializeAfterConstruction();
            }
        }
        catch (ObjectCreationException objectCreationException) {
            throw objectCreationException;
        }
        catch (Exception exception) {
            throw new ObjectCreationException(exception);
        }
        return (T)object;
    }

    protected static <T> T createObjectFromContainer(Element element, String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        T t = BeanContainer.get().lookupBean(string, clazz);
        try {
            if (t instanceof IElementConfigurable) {
                ((IElementConfigurable)t).configure(element);
            }
            ElementTools.setProperties(t, element, classLoader);
        }
        catch (ObjectCreationException objectCreationException) {
            throw objectCreationException;
        }
        catch (Exception exception) {
            throw new ObjectCreationException(exception);
        }
        return t;
    }

    protected static <T> T createObjectFromFactory(Element element, String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        IFactory iFactory;
        if (string == null) {
            throw new ObjectCreationException("factory name missing");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        if ((iFactory = Outlet.get().lookupFactory(string)) == null) {
            try {
                iFactory = ObjectTools.createObject(string, IFactory.class, classLoader);
                Outlet.get().registerFactory(iFactory);
                Log.log(Level.INFO, "created default factory '" + string + "'");
            }
            catch (Exception exception) {
                throw new ObjectCreationException("factory '" + string + "' missing");
            }
        }
        ElementArgsAdapter elementArgsAdapter = new ElementArgsAdapter(element);
        Object t = iFactory.createInstance(elementArgsAdapter);
        try {
            if (t instanceof IElementConfigurable) {
                ((IElementConfigurable)t).configure(element);
            } else if (iFactory instanceof IElementConfigurator) {
                ((IElementConfigurator)((Object)iFactory)).configure(t, element);
            }
            if (t instanceof IClassLoaderAccess) {
                ((IClassLoaderAccess)t).setClassLoader(classLoader);
            }
            ElementTools.setProperties(t, element, classLoader);
        }
        catch (Exception exception) {
            throw new ObjectCreationException(exception);
        }
        return t;
    }

    public static <T> T createPropertyValue(Object object, Element element, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        Element element2 = null;
        Iterator<Element> iterator = ElementTools.getElementsIterator(element);
        if (iterator.hasNext()) {
            element2 = iterator.next();
            if (iterator.hasNext()) {
                throw new ObjectCreationException("too many children");
            }
            return ElementTools.createObject(object, element2, clazz, classLoader);
        }
        String string = ElementTools.getString(element, "ref", null);
        if (string != null) {
            return BeanContainer.get().lookupBean(string, clazz);
        }
        String string2 = ElementTools.getString(element, "value", null);
        String string3 = ElementTools.getString(element, "type", null);
        return (T)ObjectTools.convert(string2, string3, classLoader);
    }

    public static boolean getBoolean(Element element, String string, boolean bl) {
        String string2 = null;
        if (element != null) {
            string2 = ElementTools.getString(element, string, null);
        }
        if (string2 != null) {
            try {
                return Boolean.parseBoolean(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static double getDouble(Element element, String string, double d) {
        String string2 = null;
        if (element != null) {
            string2 = ElementTools.getString(element, string, null);
        }
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public static Iterator<Element> getElementsIterator(Element element) {
        return new Iterator<Element>(element){
            private int i = 0;
            private NodeList nodes;
            {
                this.nodes = element.getChildNodes();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.nodes.getLength();
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Element)this.nodes.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Element> getElementsIterator(Element element, String string) {
        return new Iterator<Element>(element, string){
            private int i = 0;
            private NodeList nodes;
            {
                this.nodes = element.getElementsByTagName(string);
            }

            @Override
            public boolean hasNext() {
                return this.i < this.nodes.getLength();
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Element)this.nodes.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T extends EnumItem> T getEnumItem(Element element, String string, EnumMeta<T> enumMeta) {
        String string2 = ElementTools.getString(element, string, null);
        return enumMeta.getItemOrDefault(string2);
    }

    public static <T extends EnumItem> T getEnumItem(Element element, String string, EnumMeta<T> enumMeta, T t) {
        String string2 = ElementTools.getString(element, string, null);
        T t2 = null;
        if (string2 != null) {
            t2 = enumMeta.getItem(string2);
        }
        if (t2 == null) {
            t2 = t;
        }
        return t2;
    }

    public static Element getFirstElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static float getFloat(Element element, String string, float f) {
        String string2 = null;
        if (element != null) {
            string2 = ElementTools.getString(element, string, null);
        }
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public static int getInt(Element element, String string, int n) {
        Attr attr;
        String string2 = null;
        if (element != null && (attr = element.getAttributeNode(string)) != null) {
            string2 = attr.getValue();
        }
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean getPathBoolean(Element element, String string, boolean bl) {
        Element element2 = element;
        String[] stringArray = splitPattern.split(string, 0);
        int n = stringArray.length - 1;
        int n2 = 0;
        while (element2 != null && n2 < n) {
            element2 = ElementTools.getFirstElement(element2, stringArray[n2]);
            ++n2;
        }
        return ElementTools.getBoolean(element2, stringArray[n2], bl);
    }

    public static double getPathDouble(Element element, String string, double d) {
        Element element2 = element;
        String[] stringArray = splitPattern.split(string, 0);
        int n = stringArray.length - 1;
        int n2 = 0;
        while (element2 != null && n2 < n) {
            element2 = ElementTools.getFirstElement(element2, stringArray[n2]);
            ++n2;
        }
        return ElementTools.getDouble(element2, stringArray[n2], d);
    }

    public static float getPathFloat(Element element, String string, float f) {
        Element element2 = element;
        String[] stringArray = splitPattern.split(string, 0);
        int n = stringArray.length - 1;
        int n2 = 0;
        while (element2 != null && n2 < n) {
            element2 = ElementTools.getFirstElement(element2, stringArray[n2]);
            ++n2;
        }
        return ElementTools.getFloat(element2, stringArray[n2], f);
    }

    public static int getPathInt(Element element, String string, int n) {
        Element element2 = element;
        String[] stringArray = splitPattern.split(string, 0);
        int n2 = stringArray.length - 1;
        int n3 = 0;
        while (element2 != null && n3 < n2) {
            element2 = ElementTools.getFirstElement(element2, stringArray[n3]);
            ++n3;
        }
        return ElementTools.getInt(element2, stringArray[n3], n);
    }

    public static String getPathString(Element element, String string, String string2) {
        Element element2 = element;
        String[] stringArray = splitPattern.split(string, 0);
        int n = stringArray.length - 1;
        int n2 = 0;
        while (element2 != null && n2 < n) {
            element2 = ElementTools.getFirstElement(element2, stringArray[n2]);
            ++n2;
        }
        return ElementTools.getString(element2, stringArray[n2], string2);
    }

    public static String getString(Element element, String string, String string2) {
        if (element != null) {
            Attr attr = element.getAttributeNode(string);
            if (attr == null) {
                return string2;
            }
            return attr.getValue();
        }
        return string2;
    }

    public static void setProperties(Object object, Element element, ClassLoader classLoader) throws FieldException, ObjectCreationException, FunctorInvocationException {
        Iterator<Element> iterator = ElementTools.getElementsIterator(element, "property");
        while (iterator.hasNext()) {
            Element element2 = iterator.next();
            ElementTools.setProperty(object, element2, classLoader);
        }
    }

    public static void setProperty(Object object, Element element, ClassLoader classLoader) throws FieldException, ObjectCreationException, FunctorInvocationException {
        String string = ElementTools.getString(element, "name", null);
        String string2 = ElementTools.getString(element, "operation", "set");
        Object object2 = ElementTools.createPropertyValue(object, element, Object.class, classLoader);
        if ("set".equals(string2)) {
            ObjectTools.set(object, string, object2);
        } else if ("insert".equals(string2)) {
            ObjectTools.insert(object, string, object2);
        } else if ("remove".equals(string2)) {
            ObjectTools.remove(object, string, object2);
        } else {
            throw new ObjectCreationException("unknown property operation '" + string2 + "'");
        }
    }

    static class ElementProxyInvocationHandler
    implements InvocationHandler,
    IAttributeSupport {
        private AttributeMap attributes;
        private Map functors = new HashMap();

        public ElementProxyInvocationHandler(Element element, Class[] classArray, ClassLoader classLoader) throws ObjectCreationException {
            this.createFunctors(element, classArray, classLoader);
        }

        protected void createFunctors(Element element, Class[] classArray, ClassLoader classLoader) throws ObjectCreationException {
            Element element2 = ElementTools.getFirstElement(element, "implementation");
            NodeList nodeList = element2.getElementsByTagName("method");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element3 = (Element)nodeList.item(n);
                String string = element3.getAttribute("name");
                IFunctor iFunctor = ElementTools.createFunctor(element3, this, classLoader);
                this.functors.put(string, iFunctor);
                ++n;
            }
            IFunctor iFunctor = new IFunctor(){

                public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.getAttribute(iFunctorCall.getArgs().get(0));
                }
            };
            this.functors.put("getAttribute", iFunctor);
            iFunctor = new IFunctor(){

                public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.setAttribute(iFunctorCall.getArgs().get(0), iFunctorCall.getArgs().get(1));
                }
            };
            this.functors.put("setAttribute", iFunctor);
            iFunctor = new IFunctor(){

                public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.removeAttribute(iFunctorCall.getArgs().get(0));
                }
            };
            this.functors.put("removeAttribute", iFunctor);
        }

        @Override
        public Object getAttribute(Object object) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(object);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            IFunctor iFunctor = (IFunctor)this.functors.get(string);
            if (iFunctor == null) {
                return null;
            }
            Args args = new Args(objectArray);
            FunctorCall functorCall = new FunctorCall(object, args);
            return iFunctor.perform(functorCall);
        }

        @Override
        public Object removeAttribute(Object object) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.remove(object);
        }

        @Override
        public Object setAttribute(Object object, Object object2) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap();
            }
            return this.attributes.put(object, object2);
        }
    }
}

