/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.string.StringTools;
import java.util.regex.Pattern;

public abstract class DeclarationElement
extends Declaration
implements IDeclarationElement {
    private String modifierString;
    private String name;
    private String description;

    public static boolean validateName(String string) {
        if (StringTools.isEmpty(string)) {
            return false;
        }
        return Pattern.matches("[a-zA-Z0-9_]+", string);
    }

    public static boolean validatePath(String string) {
        if (StringTools.isEmpty(string)) {
            return false;
        }
        return Pattern.matches("([a-zA-Z0-9_]+\\.)+", string);
    }

    public DeclarationElement(Object object, String string, String string2) {
        this(object, string, string2, null);
    }

    public DeclarationElement(Object object, String string, String string2, String string3) {
        super(object);
        this.modifierString = string2;
        this.name = string;
        this.description = string3;
    }

    public void addModifier(String string) {
        if (StringTools.isEmpty(this.modifierString)) {
            this.modifierString = string;
            return;
        }
        if (this.modifierString.indexOf(string) >= 0) {
            return;
        }
        this.modifierString = String.valueOf(this.modifierString) + ";" + string;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getModifiers() {
        if (StringTools.isEmpty(this.modifierString)) {
            return new String[0];
        }
        return this.modifierString.replaceAll("\\s", "").split("\\;");
    }

    @Override
    public String getModifierString() {
        return this.modifierString;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasModifier(String string) {
        if (this.modifierString == null) {
            return false;
        }
        return this.modifierString.indexOf(string) >= 0;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setModifierString(String string) {
        this.modifierString = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "declaration <'" + this.getName() + "'> [" + this.modifierString + "]";
    }
}

