/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FileDumpHandler
extends Handler {
    private static final Logger Log = LogTools.getLogger(FileDumpHandler.class);
    private File directory;

    public static void dump(File file, Object object) throws IOException, FileNotFoundException {
        FileTools.checkDirectory(file, true, true, true);
        if (object instanceof Attachment) {
            object = ((Attachment)object).getAttached();
        }
        if (object instanceof ILocator) {
            LocatorTools.save((ILocator)object, file);
        } else if (object instanceof ILocatorSupport) {
            LocatorTools.save(((ILocatorSupport)object).getLocator(), file);
        } else if (object instanceof File) {
            FileTools.copyFile((File)object, file);
        } else {
            if (object instanceof InputStream) {
                try {
                    File file2 = File.createTempFile("dump", ".bytes", file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    StreamTools.copyStream((InputStream)object, false, fileOutputStream, true);
                }
                finally {
                    StreamTools.close((InputStream)object);
                }
            }
            if (object instanceof byte[]) {
                File file3 = File.createTempFile("dump", ".bytes", file);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file3);
                    ((OutputStream)fileOutputStream).write((byte[])object);
                }
                catch (Throwable throwable) {
                    StreamTools.close(fileOutputStream);
                    throw throwable;
                }
                StreamTools.close(fileOutputStream);
            }
        }
    }

    public FileDumpHandler() {
        this.init();
    }

    @Override
    public void close() throws SecurityException {
    }

    protected void dumpFile(Object object) throws IOException {
        File file = this.getDirectory();
        FileDumpHandler.dump(file, object);
    }

    @Override
    public void flush() {
    }

    public File getDirectory() {
        return this.directory;
    }

    private void init() {
        String string;
        LogManager logManager = LogManager.getLogManager();
        String string2 = logManager.getProperty(String.valueOf(string = this.getClass().getName()) + ".directory");
        if (StringTools.isEmpty(string2)) {
            string2 = "${environment.profiledir}/dumplog.${system.uniquetime:d}";
            try {
                string2 = (String)TemplateEvaluator.get().evaluate(string2, Args.create());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            string2 = FileTools.trimPath(string2);
            this.directory = new File(string2);
        }
        if ((string2 = logManager.getProperty(String.valueOf(string) + ".level")) == null) {
            this.setLevel(Level.ALL);
        } else {
            try {
                this.setLevel(Level.parse(string2.trim()));
            }
            catch (Exception exception) {
                this.setLevel(Level.ALL);
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length > 0) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            try {
                FileTools.checkDirectory(this.directory, true, true, true);
                Object[] objectArray2 = objectArray;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray2[n2];
                    this.dumpFile(object);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDirectory(File file) {
        this.directory = file;
    }
}

