/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.logging.CommonHandlerFactory;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;

public class FileHandlerFactory
extends CommonHandlerFactory {
    private File file;
    private String fileName = "log.%u.%g.log";
    private int count = 5;
    private int limit = 1000000;
    private IStringEvaluator stringEvaluator;
    private boolean append = false;

    @Override
    protected Handler basicCreateHandler() throws IOException {
        File file = this.getFile();
        FileHandler fileHandler = new FileHandler(file.getAbsolutePath(), this.getLimit(), this.getCount(), this.isAppend());
        return fileHandler;
    }

    public int getCount() {
        return this.count;
    }

    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        String string = this.getFileName();
        if (StringTools.isEmpty(string)) {
            string = "log.%u.%g.log";
        }
        try {
            string = (String)this.getStringEvaluator().evaluate(string, Args.create());
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = FileTools.trimPath(string);
        File file = FileEnvironment.get().getProfileDir();
        File file2 = FileTools.resolvePath(file, string);
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        return file2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLimit() {
        return this.limit;
    }

    public IStringEvaluator getStringEvaluator() {
        if (this.stringEvaluator == null) {
            return TemplateEvaluator.get();
        }
        return this.stringEvaluator;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setCount(int n) {
        this.count = n;
        this.setSingletonHandler(null);
    }

    public void setFile(File file) {
        this.file = file;
        this.setSingletonHandler(null);
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.setSingletonHandler(null);
    }

    public void setLimit(int n) {
        this.limit = n;
        this.setSingletonHandler(null);
    }

    public void setStringEvaluator(IStringEvaluator iStringEvaluator) {
        this.stringEvaluator = iStringEvaluator;
        this.setSingletonHandler(null);
    }
}

