/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSDeviceAdapter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class CSBasicDevice
extends CSDeviceAdapter {
    public static final float THOUSAND = 1000.0f;
    private boolean clip;
    private boolean clipEvenOdd;
    private GeneralPath currentShape;
    private boolean currentShapeDegenerated;
    private boolean currentShapeEmpty;
    private float currentX;
    private float currentY;
    private float initialX;
    private float initialY;

    protected void basicClip(Shape shape) throws CSException {
    }

    protected void basicDraw(Shape shape) throws CSException {
    }

    protected void basicFill(Shape shape) throws CSException {
    }

    protected void basicFillDegenerated(Shape shape) {
    }

    protected void basicTextShowBegin() {
    }

    protected void basicTextShowEnd() {
    }

    protected void basicTextShowGlyphs(PDGlyphs pDGlyphs, float f) throws CSException {
        this.textMove(f, 0.0f);
    }

    protected GeneralPath getCurrentShape() {
        return this.currentShape;
    }

    @Override
    public void open(ICSInterpreter iCSInterpreter) {
        super.open(iCSInterpreter);
        this.currentShape = new GeneralPath();
        this.currentShapeDegenerated = true;
        this.currentShapeEmpty = true;
    }

    @Override
    public void pathClipEvenOdd() {
        this.clip = true;
        this.clipEvenOdd = true;
    }

    @Override
    public void pathClipNonZero() {
        this.clip = true;
        this.clipEvenOdd = false;
    }

    @Override
    public void pathClose() {
        this.privateClosePath();
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
        this.privateClosePath();
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
        this.privateClosePath();
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathCloseStroke() {
        this.privateClosePath();
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathEnd() {
        this.privateClip();
    }

    @Override
    public void pathFillEvenOdd() {
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        if (this.currentShapeDegenerated) {
            this.basicFillDegenerated(this.currentShape);
        }
        this.privateClip();
    }

    @Override
    public void pathFillNonZero() {
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        if (this.currentShapeDegenerated) {
            this.basicFillDegenerated(this.currentShape);
        }
        this.privateClip();
    }

    @Override
    public void pathFillStrokeEvenOdd() {
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathFillStrokeNonZero() {
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathStroke() {
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void penCurveToC(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(f, f2, f3, f4, f5, f6);
        this.currentX = f5;
        this.currentY = f6;
    }

    @Override
    public void penCurveToV(float f, float f2, float f3, float f4) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(this.currentX, this.currentY, f, f2, f3, f4);
        this.currentX = f3;
        this.currentY = f4;
    }

    @Override
    public void penCurveToY(float f, float f2, float f3, float f4) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(f, f2, f3, f4, f3, f4);
        this.currentX = f3;
        this.currentY = f4;
    }

    @Override
    public void penLineTo(float f, float f2) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.lineTo(f, f2);
        this.currentX = f;
        this.currentY = f2;
    }

    @Override
    public void penMoveTo(float f, float f2) {
        this.clip = false;
        this.clipEvenOdd = false;
        this.currentShape.moveTo(f, f2);
        this.initialX = f;
        this.initialY = f2;
        this.currentX = f;
        this.currentY = f2;
    }

    @Override
    public void penRectangle(float f, float f2, float f3, float f4) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
            this.currentShapeDegenerated = f3 <= 1.0f && f3 >= -1.0f || f4 <= 1.0f && f4 >= -1.0f;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.clip = false;
        this.clipEvenOdd = false;
        this.currentShape.moveTo(f, f2);
        this.currentShape.lineTo(f + f3, f2);
        this.currentShape.lineTo(f + f3, f2 + f4);
        this.currentShape.lineTo(f, f2 + f4);
        this.currentShape.closePath();
        this.initialX = f;
        this.initialY = f2;
        this.currentX = f;
        this.currentY = f2;
    }

    protected void privateClip() {
        if (this.clip) {
            Shape shape;
            if (this.clipEvenOdd) {
                this.currentShape.setWindingRule(0);
            } else {
                this.currentShape.setWindingRule(1);
            }
            if (this.graphicsState.clip != null) {
                Area area = new Area(this.currentShape);
                Area area2 = new Area(this.graphicsState.clip);
                area2.intersect(area);
                shape = area2;
            } else {
                shape = this.currentShape;
            }
            this.graphicsState.clip = ApplySpaceChangeShape.create((Shape)shape, (AffineTransform)this.graphicsState.transform);
            this.basicClip(this.currentShape);
        }
        this.clip = false;
        this.currentShape = new GeneralPath();
        this.currentShapeDegenerated = true;
        this.currentShapeEmpty = true;
    }

    protected void privateClosePath() {
        this.currentShape.closePath();
        this.currentX = this.initialX;
        this.currentY = this.initialY;
    }

    @Override
    public void textShow(byte[] byArray, int n, int n2) {
        PDFont pDFont;
        TextState textState = this.textState;
        if (textState.rise != 0.0f) {
            this.textMove(0.0f, textState.rise);
        }
        if ((pDFont = textState.font) == null) {
            return;
        }
        float f = textState.derivedGlyphAdvanceFactor;
        float f2 = textState.derivedCharSpacingScaled;
        float f3 = textState.derivedWordSpacingScaled;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.basicTextShowBegin();
        while (true) {
            try {
                PDGlyphs pDGlyphs;
                while ((pDGlyphs = pDFont.getNextGlyphsEncoded(byteArrayInputStream)) != null) {
                    float f4 = f * pDGlyphs.getWidth() + (f3 != 0.0f && pDGlyphs.isWhitespace() ? f3 : 0.0f) + f2;
                    this.basicTextShowGlyphs(pDGlyphs, f4);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        this.basicTextShowEnd();
    }
}

