/*
 * This declarations of the PIC16F716 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-09-15 14:38:39 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F716_H__
#define __PIC16F716_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define DATACCP_ADDR            0x0006
#define PORTB_ADDR              0x0006
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define PWM1CON_ADDR            0x0018
#define ECCPAS_ADDR             0x0019
#define ADRES_ADDR              0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISCP_ADDR             0x0086
#define PIE1_ADDR               0x008C
#define PCON_ADDR               0x008E
#define PR2_ADDR                0x0092
#define ADCON1_ADDR             0x009F

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 5;
    unsigned                    : 3;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10

//==============================================================================


//==============================================================================
//        DATACCP Bits

extern __at(0x0006) __sfr DATACCP;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DT1CK              : 1;
    unsigned                    : 1;
    unsigned DCCP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __DATACCPbits_t;

extern __at(0x0006) volatile __DATACCPbits_t DATACCPbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _DT1CK                  0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _DCCP                   0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DT1CK              : 1;
    unsigned                    : 1;
    unsigned DCCP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_RB1              0x02
#define _PORTB_DT1CK            0x02
#define _PORTB_RB2              0x04
#define _PORTB_RB3              0x08
#define _PORTB_DCCP             0x08
#define _PORTB_RB4              0x10
#define _PORTB_RB5              0x20
#define _PORTB_RB6              0x40
#define _PORTB_RB7              0x80

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _ADIF                   0x40

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0018) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0018) volatile __PWM1CONbits_t PWM1CONbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        ECCPAS Bits

extern __at(0x0019) __sfr ECCPAS;

typedef union
  {
  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCPASbits_t;

extern __at(0x0019) volatile __ECCPASbits_t ECCPASbits;

#define _PSSBD0                 0x01
#define _PSSBD1                 0x02
#define _PSSAC0                 0x04
#define _PSSAC1                 0x08
#define _ECCPAS0                0x10
#define _ECCPAS1                0x20
#define _ECCPAS2                0x40
#define _ECCPASE                0x80

//==============================================================================

extern __at(0x001E) __sfr ADRES;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CHS                : 3;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x04
#define _GO                     0x04
#define _NOT_DONE               0x04
#define _GO_DONE                0x04
#define _CHS0                   0x08
#define _CHS1                   0x10
#define _CHS2                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 5;
    unsigned                    : 3;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned TT1CK              : 1;
    unsigned                    : 1;
    unsigned TCCP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TT1CK                  0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TCCP                   0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISCP Bits

extern __at(0x0086) __sfr TRISCP;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned TT1CK              : 1;
    unsigned                    : 1;
    unsigned TCCP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __TRISCPbits_t;

extern __at(0x0086) volatile __TRISCPbits_t TRISCPbits;

#define _TRISCP_TRISB0          0x01
#define _TRISCP_TRISB1          0x02
#define _TRISCP_TT1CK           0x02
#define _TRISCP_TRISB2          0x04
#define _TRISCP_TRISB3          0x08
#define _TRISCP_TCCP            0x08
#define _TRISCP_TRISB4          0x10
#define _TRISCP_TRISB5          0x20
#define _TRISCP_TRISB6          0x40
#define _TRISCP_TRISB7          0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BO             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BOD            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BO                 0x01
#define _NOT_BOD                0x01
#define _NOT_POR                0x02

//==============================================================================

extern __at(0x0092) __sfr PR2;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCFG               : 3;
    unsigned                    : 5;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_LP                0x3FFC  // LP oscillator.
#define _LP_OSC                 0x3FFC  // LP oscillator.
#define _FOSC_XT                0x3FFD  // XT oscillator.
#define _XT_OSC                 0x3FFD  // XT oscillator.
#define _FOSC_HS                0x3FFE  // HS oscillator.
#define _HS_OSC                 0x3FFE  // HS oscillator.
#define _FOSC_RC                0x3FFF  // RC oscillator.
#define _RC_OSC                 0x3FFF  // RC oscillator.
#define _WDTE_OFF               0x3FFB  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FFB  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FF7  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _BOREN_OFF              0x3FBF  // BOR disabled.
#define _BOREN_OFF              0x3FBF  // BOR disabled.
#define _BODEN_OFF              0x3FBF  // BOR disabled.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BODEN_ON               0x3FFF  // BOR enabled.
#define _BODENV_25              0x3F7F  // VBOR set to 2.5V.
#define _VBOR_25                0x3F7F  // VBOR set to 2.5V.
#define _BODENV_40              0x3FFF  // VBOR set to 4.0V.
#define _VBOR_40                0x3FFF  // VBOR set to 4.0V.
#define _CP_ON                  0x1FFF  // Program memory code protection is enabled.
#define _CP_ALL                 0x1FFF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 2, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 2, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 2, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 2, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 3
#define CHS1                    ADCON0bits.CHS1                 // bit 4
#define CHS2                    ADCON0bits.CHS2                 // bit 5
#define ADCS0                   ADCON0bits.ADCS0                // bit 6
#define ADCS1                   ADCON0bits.ADCS1                // bit 7

#define PCFG0                   ADCON1bits.PCFG0                // bit 0
#define PCFG1                   ADCON1bits.PCFG1                // bit 1
#define PCFG2                   ADCON1bits.PCFG2                // bit 2

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5
#define P1M0                    CCP1CONbits.P1M0                // bit 6
#define P1M1                    CCP1CONbits.P1M1                // bit 7

#define RB0                     DATACCPbits.RB0                 // bit 0
#define RB1                     DATACCPbits.RB1                 // bit 1, shadows bit in DATACCPbits
#define DT1CK                   DATACCPbits.DT1CK               // bit 1, shadows bit in DATACCPbits
#define RB2                     DATACCPbits.RB2                 // bit 2
#define RB3                     DATACCPbits.RB3                 // bit 3, shadows bit in DATACCPbits
#define DCCP                    DATACCPbits.DCCP                // bit 3, shadows bit in DATACCPbits
#define RB4                     DATACCPbits.RB4                 // bit 4
#define RB5                     DATACCPbits.RB5                 // bit 5
#define RB6                     DATACCPbits.RB6                 // bit 6
#define RB7                     DATACCPbits.RB7                 // bit 7

#define PSSBD0                  ECCPASbits.PSSBD0               // bit 0
#define PSSBD1                  ECCPASbits.PSSBD1               // bit 1
#define PSSAC0                  ECCPASbits.PSSAC0               // bit 2
#define PSSAC1                  ECCPASbits.PSSAC1               // bit 3
#define ECCPAS0                 ECCPASbits.ECCPAS0              // bit 4
#define ECCPAS1                 ECCPASbits.ECCPAS1              // bit 5
#define ECCPAS2                 ECCPASbits.ECCPAS2              // bit 6
#define ECCPASE                 ECCPASbits.ECCPASE              // bit 7

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BO                  PCONbits.NOT_BO                 // bit 0, shadows bit in PCONbits
#define NOT_BOD                 PCONbits.NOT_BOD                // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define ADIE                    PIE1bits.ADIE                   // bit 6

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define ADIF                    PIR1bits.ADIF                   // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4

#define PDC0                    PWM1CONbits.PDC0                // bit 0
#define PDC1                    PWM1CONbits.PDC1                // bit 1
#define PDC2                    PWM1CONbits.PDC2                // bit 2
#define PDC3                    PWM1CONbits.PDC3                // bit 3
#define PDC4                    PWM1CONbits.PDC4                // bit 4
#define PDC5                    PWM1CONbits.PDC5                // bit 5
#define PDC6                    PWM1CONbits.PDC6                // bit 6
#define PRSEN                   PWM1CONbits.PRSEN               // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1SYNC                  T1CONbits.T1SYNC                // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1, shadows bit in TRISBbits
#define TT1CK                   TRISBbits.TT1CK                 // bit 1, shadows bit in TRISBbits
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3, shadows bit in TRISBbits
#define TCCP                    TRISBbits.TCCP                  // bit 3, shadows bit in TRISBbits
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F716_H__
