/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.db;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.db.CouchDBHandler;
import org.owasp.jbrofuzz.db.SQLiteHandler;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class SyncDatabaseDialog
extends JDialog
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = -5815321460026044259L;
    private static final int SIZE_X = 600;
    private static final int SIZE_Y = 300;
    private final JButton ok;
    private final JButton cancel;
    private final JButton getSessions;
    final JPanel propertiesPanel = new JPanel(new FlowLayout(2, 15, 15));
    private final JPopupMenu popmenu;
    private final JComboBox databaseBox;
    private final JComboBox methodBox;
    private final JTextField dbUrl;
    private JComboBox sessionsSQLiteBox;
    private JComboBox sessionsCouchBox;
    private final String[] methods = new String[]{"SQLite", "CouchDB"};
    private String[] sessionsSQLite = new String[]{"not loaded yet"};
    private String[] sessionsCouch = new String[]{"not loaded yet"};
    private JBroFuzzWindow parent = null;

    public SyncDatabaseDialog(final JBroFuzzWindow parent) {
        super(parent, " Sync Databases ", true);
        this.parent = parent;
        this.setFont(new Font("Verdana", 1, 12));
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.databaseBox = new JComboBox();
        this.databaseBox.setPreferredSize(new Dimension(250, 20));
        this.databaseBox.setEditable(true);
        this.databaseBox.getEditor().getEditorComponent().addMouseListener(this);
        this.databaseBox.setToolTipText("Copy/Paste a Databasename / URL from your browser");
        this.databaseBox.setFont(new Font("Verdana", 1, 12));
        this.databaseBox.getEditor().getEditorComponent().addKeyListener(this);
        this.dbUrl = new JTextField();
        this.dbUrl.setPreferredSize(new Dimension(250, 20));
        this.dbUrl.setToolTipText("URL to remote DB ");
        this.dbUrl.setFont(new Font("Verdana", 1, 12));
        this.methodBox = new JComboBox<String>(this.methods);
        this.sessionsCouchBox = new JComboBox<String>(this.sessionsCouch);
        this.sessionsSQLiteBox = new JComboBox<String>(this.sessionsSQLite);
        this.methodBox.setFont(new Font("Verdana", 1, 10));
        this.sessionsCouchBox.setFont(new Font("Verdana", 1, 10));
        this.sessionsSQLiteBox.setFont(new Font("Verdana", 1, 10));
        this.methodBox.addKeyListener(this);
        this.sessionsCouchBox.addKeyListener(this);
        this.sessionsSQLiteBox.addKeyListener(this);
        this.methodBox.setMaximumRowCount(3);
        this.sessionsCouchBox.setMaximumRowCount(3);
        this.sessionsSQLiteBox.setMaximumRowCount(3);
        this.methodBox.setBackground(Color.BLACK);
        this.sessionsCouchBox.setBackground(Color.BLACK);
        this.sessionsSQLiteBox.setBackground(Color.BLACK);
        this.methodBox.setForeground(Color.WHITE);
        this.sessionsCouchBox.setForeground(Color.WHITE);
        this.sessionsSQLiteBox.setForeground(Color.WHITE);
        this.sessionsCouchBox.setSelectedIndex(0);
        this.sessionsSQLiteBox.setSelectedIndex(0);
        this.ok = new JButton("  OK  ");
        this.ok.setBounds(515, 305, 140, 40);
        this.ok.setToolTipText("Open the Database location in JBroFuzz");
        this.cancel = new JButton("Cancel");
        this.cancel.setBounds(515, 305, 140, 40);
        this.cancel.setToolTipText("Cancel opening a Database location");
        this.getSessions = new JButton("Get SessionIds");
        this.getSessions.setBounds(515, 305, 140, 40);
        this.getSessions.setToolTipText("Load all SessionIds from Database");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyncDatabaseDialog.this.clickOK(parent);
                        SyncDatabaseDialog.this.dispose();
                    }
                });
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyncDatabaseDialog.this.dispose();
                    }
                });
            }
        });
        this.getSessions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyncDatabaseDialog.this.clickGetSessions();
                    }
                });
            }
        });
        this.popmenu = new JPopupMenu();
        JMenuItem i1 = new JMenuItem("Cut");
        JMenuItem i2 = new JMenuItem("Copy");
        JMenuItem i3 = new JMenuItem("Paste");
        JMenuItem i4 = new JMenuItem("Select All");
        this.popmenu.add(i1);
        this.popmenu.add(i2);
        this.popmenu.add(i3);
        this.popmenu.addSeparator();
        this.popmenu.add(i4);
        i1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)SyncDatabaseDialog.this.databaseBox.getEditor().getEditorComponent()).cut();
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while cutting", 2);
                    }
                }
            }
        });
        i2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)SyncDatabaseDialog.this.databaseBox.getEditor().getEditorComponent()).copy();
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while copying", 2);
                    }
                }
            }
        });
        i3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)SyncDatabaseDialog.this.databaseBox.getEditor().getEditorComponent()).replaceSelection((String)clipData.getTransferData(DataFlavor.stringFlavor));
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while pasting", 2);
                    }
                }
            }
        });
        i4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncDatabaseDialog.this.databaseBox.getEditor().selectAll();
            }
        });
        JPanel targetPanel = new JPanel(new FlowLayout(2, 15, 15));
        targetPanel.add(new JLabel("Database: "));
        targetPanel.add(this.databaseBox);
        JPanel dbPanel = new JPanel(new FlowLayout(2, 15, 15));
        dbPanel.add(new JLabel("DatabaseType: "));
        dbPanel.add(this.methodBox);
        dbPanel.add(new JLabel("SessionIds: "));
        if (JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals("sqlite")) {
            dbPanel.add(this.sessionsSQLiteBox);
        } else if (JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals("couchdb")) {
            dbPanel.add(this.sessionsCouchBox);
        }
        this.propertiesPanel.add(dbPanel);
        JPanel remotePanel = new JPanel(new FlowLayout(2, 15, 15));
        remotePanel.add(new JLabel("Remote DB URL: "));
        remotePanel.add(this.dbUrl);
        this.propertiesPanel.add(remotePanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(this.getSessions);
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        this.add((Component)targetPanel, "North");
        this.add((Component)this.propertiesPanel, "Center");
        this.add((Component)buttonPanel, "South");
        ((JTextComponent)this.databaseBox.getEditor().getEditorComponent()).setText(JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[12].getId(), ""));
        ((JTextComponent)this.databaseBox.getEditor().getEditorComponent()).selectAll();
        this.setLocation(parent.getLocation().x + 20, parent.getLocation().y + 40);
        this.setSize(600, 300);
        this.setResizable(true);
        this.setVisible(true);
    }

    private void checkForTriggerEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popmenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void clickGetSessions() {
        if (JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals("sqlite")) {
            SQLiteHandler sqlH = new SQLiteHandler();
            long[] lSessionId = null;
            this.sessionsSQLiteBox.removeAllItems();
            try {
                String dbName = "";
                dbName = this.databaseBox.getSelectedItem().toString().length() > 0 && !this.databaseBox.getSelectedItem().toString().equals("") ? this.databaseBox.getSelectedItem().toString() : JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "");
                lSessionId = sqlH.getSessionIds(sqlH.getConnection(dbName));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            String[] sessionIds = new String[lSessionId.length];
            int i = 0;
            while (i < lSessionId.length) {
                sessionIds[i] = String.valueOf(lSessionId);
                this.sessionsSQLiteBox.addItem(String.valueOf(lSessionId[i]));
                ++i;
            }
            this.sessionsSQLiteBox.setSelectedIndex(0);
            this.sessionsSQLite = sessionIds;
            this.repaint();
        } else if (JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "").toLowerCase().trim().equals("couchdb")) {
            CouchDBHandler cdbH = new CouchDBHandler();
            String[] sessionsCouch = cdbH.getDocumentIds(JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), ""));
            this.sessionsCouchBox.removeAllItems();
            int i = 0;
            while (i < sessionsCouch.length) {
                this.sessionsCouchBox.addItem(sessionsCouch[i]);
                ++i;
            }
            this.sessionsCouchBox.setSelectedIndex(0);
            this.repaint();
        }
    }

    private void clickOK(JBroFuzzWindow mWindow) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 27) {
            this.dispose();
        }
        if (ke.getKeyCode() == 10) {
            this.clickOK(this.parent);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }
}

