/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui;

import com.Ostermiller.util.Browser;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.actions.CopyAction;
import org.owasp.jbrofuzz.ui.actions.CutAction;
import org.owasp.jbrofuzz.ui.actions.PasteAction;
import org.owasp.jbrofuzz.ui.actions.SelectAllAction;
import org.owasp.jbrofuzz.ui.viewers.PropertiesViewer;
import org.owasp.jbrofuzz.ui.viewers.WindowViewerFrame;
import org.owasp.jbrofuzz.version.ImageCreator;

public abstract class AbstractPanel
extends JPanel {
    private static final long serialVersionUID = -4932876100272401793L;
    private final JBroFuzzWindow frame;
    private final String name;
    private final boolean[] optionsAvailable;

    public AbstractPanel(String name, JBroFuzzWindow frame) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.setOpaque(false);
        this.name = name;
        this.frame = frame;
        this.optionsAvailable = new boolean[5];
    }

    public abstract void add();

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public final JBroFuzzWindow getFrame() {
        return this.frame;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getOptionsLength() {
        return this.optionsAvailable.length;
    }

    public abstract void pause();

    public boolean isAddedEnabled() {
        return this.optionsAvailable[3];
    }

    public boolean isPauseEnabled() {
        return this.optionsAvailable[2];
    }

    public boolean isRemovedEnabled() {
        return this.optionsAvailable[4];
    }

    public boolean isStartedEnabled() {
        return this.optionsAvailable[0];
    }

    public boolean isStoppedEnabled() {
        return this.optionsAvailable[1];
    }

    public final void popupTable(final JTable area, boolean open, boolean cut, boolean copy, boolean paste, boolean selectAll, boolean properties) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenuItem i0_open = new JMenuItem("Open in Browser");
        JMenuItem i1_cut = new JMenuItem(new CutAction());
        JMenuItem i2_copy = new JMenuItem(new CopyAction());
        JMenuItem i3_paste = new JMenuItem(new PasteAction());
        JMenuItem i4_select = new JMenuItem(new SelectAllAction());
        JMenuItem i5_props = new JMenuItem("Properties");
        i0_open.setIcon(ImageCreator.IMG_OPENINBROWSER);
        i1_cut.setIcon(ImageCreator.IMG_CUT);
        i2_copy.setIcon(ImageCreator.IMG_COPY);
        i3_paste.setIcon(ImageCreator.IMG_PASTE);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        i0_open.setEnabled(open);
        i1_cut.setEnabled(cut);
        i2_copy.setEnabled(copy);
        i3_paste.setEnabled(paste);
        i4_select.setEnabled(selectAll);
        i5_props.setEnabled(properties);
        popmenu.add(i0_open);
        popmenu.addSeparator();
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.add(i4_select);
        popmenu.addSeparator();
        popmenu.add(i5_props);
        i0_open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s;
                JTabbedPane pane = AbstractPanel.this.getFrame().getTp();
                int d = pane.getSelectedIndex();
                if (d >= 0 && (s = ((AbstractPanel)pane.getComponent(d)).getName()).equalsIgnoreCase(AbstractPanel.this.getFrame().getPanelFuzzing().getName())) {
                    int c = area.getSelectedRow();
                    if (c < 0) {
                        return;
                    }
                    String fileName = String.valueOf((String)area.getModel().getValueAt(area.convertRowIndexToModel(c), 0)) + ".html";
                    String sURI = AbstractPanel.this.getFrame().getJBroFuzz().getStorageHandler().getFuzzURIString(fileName);
                    Browser.init();
                    try {
                        Browser.displayURL((String)sURI);
                    }
                    catch (IOException ex) {
                        Logger.log("Could not launch link in external browser", 3);
                    }
                }
            }
        });
        i1_cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection;
                StringBuffer selectionBuffer = new StringBuffer();
                int[] nArray = selection = area.getSelectedRows();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    int element = nArray[n2];
                    int i = 0;
                    while (i < area.getColumnCount()) {
                        selectionBuffer.append(area.getModel().getValueAt(area.convertRowIndexToModel(element), i));
                        if (i < area.getColumnCount() - 1) {
                            selectionBuffer.append(",");
                        }
                        ++i;
                    }
                    selectionBuffer.append("\n");
                    ++n2;
                }
                JTextArea myTempArea = new JTextArea();
                myTempArea.setText(selectionBuffer.toString());
                myTempArea.selectAll();
                myTempArea.copy();
            }
        });
        i3_paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        i5_props.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane pane = AbstractPanel.this.getFrame().getTp();
                int d = pane.getSelectedIndex();
                if (d >= 0) {
                    String s = ((AbstractPanel)pane.getComponent(d)).getName();
                    if (s.equalsIgnoreCase(AbstractPanel.this.getFrame().getPanelFuzzing().getName())) {
                        int c = area.getSelectedRow();
                        if (c < 0) {
                            return;
                        }
                        String name = (String)area.getModel().getValueAt(area.convertRowIndexToModel(c), 0);
                        String directory = AbstractPanel.this.getFrame().getJBroFuzz().getStorageHandler().getLocationURIString();
                        File selFile = new File(directory, name);
                        new WindowViewerFrame(AbstractPanel.this, selFile);
                    }
                    if (s.equalsIgnoreCase(AbstractPanel.this.getFrame().getPanelPayloads().getName())) {
                        String payload = (String)area.getModel().getValueAt(area.getSelectedRow(), 0);
                        new PropertiesViewer(AbstractPanel.this, "Payload Information", payload);
                    }
                    if (s.equalsIgnoreCase(AbstractPanel.this.getFrame().getPanelWebDirectories().getName())) {
                        StringBuffer output = new StringBuffer();
                        int i = 0;
                        while (i < area.getColumnCount()) {
                            output.append(String.valueOf(area.getColumnName(i)) + ": ");
                            output.append(area.getModel().getValueAt(area.convertRowIndexToModel(area.getSelectedRow()), i));
                            output.append("\n");
                            ++i;
                        }
                        new PropertiesViewer(AbstractPanel.this, "Properties", output.toString());
                    }
                }
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point point = e.getPoint();
                    int row = area.rowAtPoint(point);
                    if (row < 0) {
                        return;
                    }
                    area.getSelectionModel().setSelectionInterval(row, row);
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }

    public static final void popupText(final JTextComponent area, boolean cut, boolean copy, boolean paste, boolean selectAll) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenuItem i1_cut = new JMenuItem("Cut");
        JMenuItem i2_copy = new JMenuItem("Copy");
        JMenuItem i3_paste = new JMenuItem("Paste");
        JMenuItem i4_select = new JMenuItem("Select All");
        i1_cut.setIcon(ImageCreator.IMG_CUT);
        i2_copy.setIcon(ImageCreator.IMG_COPY);
        i3_paste.setIcon(ImageCreator.IMG_PASTE);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.addSeparator();
        popmenu.add(i4_select);
        i1_cut.setEnabled(cut);
        i2_copy.setEnabled(copy);
        i3_paste.setEnabled(paste);
        i4_select.setEnabled(selectAll);
        if (!area.isEditable()) {
            i3_paste.setEnabled(false);
        }
        i1_cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.cut();
            }
        });
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.copy();
            }
        });
        i3_paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (area.isEditable()) {
                    area.paste();
                }
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }

    public abstract void remove();

    public final void setOptionRemove(boolean remove) {
        this.optionsAvailable[4] = remove;
        this.getFrame().getJBroToolBar().setEnabledPanelOptions(this.optionsAvailable);
        this.getFrame().getJBroMenuBar().setEnabledPanelOptions(this.optionsAvailable);
    }

    public final void setOptionsAvailable(boolean start, boolean stop, boolean pause, boolean add, boolean remove) {
        this.optionsAvailable[0] = start;
        this.optionsAvailable[1] = stop;
        this.optionsAvailable[3] = add;
        this.optionsAvailable[4] = remove;
        this.getFrame().getJBroToolBar().setEnabledPanelOptions(this.optionsAvailable);
        this.getFrame().getJBroMenuBar().setEnabledPanelOptions(this.optionsAvailable);
    }

    public abstract void start();

    public abstract void stop();
}

