/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.encoder;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.encoder.Base64;

public class Encoder {
    private static final Logger logger = Logger.getLogger(Encoder.class);
    private int base64EncodeOptions;
    private String base64Charset;

    public Encoder() {
        this.setBase64DoBreakLines(true);
        this.base64Charset = "UTF-8";
    }

    public String getURLEncode(String string) {
        String string2 = "";
        try {
            string2 = URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public String getURLDecode(String string) {
        String string2 = "";
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public byte[] getHashSHA1(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] getHashMD5(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public String getHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(20);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n).toUpperCase();
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getHTMLString(String string) {
        return StringEscapeUtils.escapeHtml(string);
    }

    public String getJavaScriptString(String string) {
        return StringEscapeUtils.escapeJavaScript(string);
    }

    public byte[] getBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.base64Charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        return byArray;
    }

    public String getBase64Encode(String string) throws NullPointerException, IOException {
        return Base64.encodeBytes(this.getBytes(string), this.base64EncodeOptions);
    }

    public String getBase64Decode(String string) throws IllegalArgumentException, IOException {
        return new String(Base64.decode(string, 0), this.base64Charset);
    }

    public String getIllegalUTF8Encode(String string, int n) {
        char[] cArray = string.toCharArray();
        if (n != 4 && n != 3) {
            n = 2;
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length * n * 3);
        for (char c : cArray) {
            if (n == 4) {
                stringBuilder.append('%').append(Integer.toHexString(240));
                stringBuilder.append('%').append(Integer.toHexString(128));
                stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | (c & 0x7F) >> 6)));
                stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (n == 3) {
                stringBuilder.append('%').append(Integer.toHexString(224));
                stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | (c & 0x7F) >> 6)));
                stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
                continue;
            }
            stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0xC0 | (c & 0x7F) >> 6)));
            stringBuilder.append('%').append(Integer.toHexString(0xFF & (byte)(0x80 | c & 0x3F)));
        }
        return stringBuilder.toString();
    }

    public void setBase64DoBreakLines(boolean bl) {
        this.base64EncodeOptions = bl ? 8 : 0;
    }

    public void setBase64Charset(String string) {
        this.base64Charset = string;
    }
}

