/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterZapRequestId
extends FilterAdaptor {
    private static final AtomicLong requestCounter = new AtomicLong(1L);
    private static final Logger log = Logger.getLogger(FilterZapRequestId.class);
    private Model model = null;

    @Override
    public void init(Model model) {
        super.init(model);
        this.model = model;
    }

    @Override
    public int getId() {
        return this.getName().hashCode();
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.request.header.send.id");
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        if (httpRequestHeader.getHeader("X-ZAP-RequestID") == null) {
            String string = "zap-session";
            try {
                string = URLEncoder.encode(this.model.getSession().getSessionName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)"UTF8 is not supported?! Using fallback session name.", (Throwable)unsupportedEncodingException);
            }
            httpRequestHeader.addHeader("X-ZAP-RequestID", string + "-" + Long.toString(requestCounter.getAndIncrement()));
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }
}

