/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.DeselectableButtonGroup;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTable;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class LogPanel
extends AbstractPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LogPanel.class);
    private JScrollPane scrollLog = null;
    private HistoryReferencesTable historyReferencesTable = null;
    private JPanel historyPanel = null;
    private JToolBar panelToolbar = null;
    private JButton filterButton = null;
    private JLabel filterStatus = null;
    private ZapToggleButton scopeButton = null;
    private HttpPanel requestPanel = null;
    private HttpPanel responsePanel = null;
    private ExtensionHistory extension = null;
    private ZapToggleButton linkWithSitesTreeButton;
    private LinkWithSitesTreeSelectionListener linkWithSitesTreeSelectionListener;
    private DeselectableButtonGroup historyListFiltersButtonGroup;
    private Vector<HistoryReference> displayQueue = new Vector();
    private Thread thread = null;

    public LogPanel() {
        this.initialize();
    }

    private void initialize() {
        this.historyListFiltersButtonGroup = new DeselectableButtonGroup();
        this.setLayout(new BorderLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(600, 200);
        }
        this.add((Component)this.getHistoryPanel(), "Center");
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("history.panel.mnemonic"));
    }

    @Override
    public void tabSelected() {
        this.getHistoryReferenceTable().requestFocusInWindow();
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private JScrollPane getScrollLog() {
        if (this.scrollLog == null) {
            this.scrollLog = new JScrollPane();
            this.scrollLog.setViewportView((Component)((Object)this.getHistoryReferenceTable()));
            this.scrollLog.setName("scrollLog");
        }
        return this.scrollLog;
    }

    private JPanel getHistoryPanel() {
        if (this.historyPanel == null) {
            this.historyPanel = new JPanel();
            this.historyPanel.setLayout(new GridBagLayout());
            this.historyPanel.setName("History Panel");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.historyPanel.add((Component)this.getPanelToolbar(), gridBagConstraints);
            this.historyPanel.add((Component)this.getScrollLog(), gridBagConstraints2);
        }
        return this.historyPanel;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("History Toolbar");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            this.panelToolbar.add((Component)this.getScopeButton(), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.panelToolbar.add((Component)this.getLinkWithSitesTreeButton(), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.panelToolbar.add((Component)this.getFilterButton(), gridBagConstraints);
            this.filterStatus = new JLabel(Constant.messages.getString("history.filter.label.filter") + Constant.messages.getString("history.filter.label.off"));
            ++gridBagConstraints.gridx;
            this.panelToolbar.add((Component)this.filterStatus, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 2;
            this.panelToolbar.add((Component)new JLabel(), gridBagConstraints);
        }
        return this.panelToolbar;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/054.png")));
            this.filterButton.setToolTipText(Constant.messages.getString("history.filter.button.filter"));
            DisplayUtils.scaleIcon(this.filterButton);
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanel.this.extension.showFilterPlusDialog();
                }
            });
        }
        return this.filterButton;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanel.this.extension.setShowJustInScope(LogPanel.this.scopeButton.isSelected());
                }
            });
            this.historyListFiltersButtonGroup.add(this.scopeButton);
        }
        return this.scopeButton;
    }

    private JToggleButton getLinkWithSitesTreeButton() {
        if (this.linkWithSitesTreeButton == null) {
            this.linkWithSitesTreeButton = new ZapToggleButton();
            this.linkWithSitesTreeButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/earth-grey.png")));
            this.linkWithSitesTreeButton.setToolTipText(Constant.messages.getString("history.linkWithSitesSelection.unselected.button.tooltip"));
            this.linkWithSitesTreeButton.setSelectedIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/094.png")));
            this.linkWithSitesTreeButton.setSelectedToolTipText(Constant.messages.getString("history.linkWithSitesSelection.selected.button.tooltip"));
            DisplayUtils.scaleIcon(this.linkWithSitesTreeButton);
            this.linkWithSitesTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanel.this.setLinkWithSitesTreeSelection(LogPanel.this.linkWithSitesTreeButton.isSelected());
                }
            });
            this.historyListFiltersButtonGroup.add(this.linkWithSitesTreeButton);
        }
        return this.linkWithSitesTreeButton;
    }

    public void setLinkWithSitesTreeSelection(boolean bl) {
        this.linkWithSitesTreeButton.setSelected(bl);
        JTree jTree = View.getSingleton().getSiteTreePanel().getTreeSite();
        String string = null;
        if (bl) {
            TreePath treePath = jTree.getSelectionPath();
            if (treePath != null) {
                string = LogPanel.getLinkWithSitesTreeBaseUri((SiteNode)treePath.getLastPathComponent());
            }
            jTree.addTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        } else {
            jTree.removeTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        }
        this.extension.setLinkWithSitesTree(bl, string);
    }

    private static String getLinkWithSitesTreeBaseUri(SiteNode siteNode) {
        HistoryReference historyReference;
        if (!siteNode.isRoot() && (historyReference = siteNode.getHistoryReference()) != null) {
            return historyReference.getURI().toString();
        }
        return null;
    }

    private HistoryReferencesTable getHistoryReferenceTable() {
        if (this.historyReferencesTable == null) {
            this.historyReferencesTable = new HistoryReferencesTable();
            this.historyReferencesTable.setSelectionMode(2);
            this.historyReferencesTable.setName("History Table");
            this.historyReferencesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                        LogPanel.this.requestPanel.setTabFocus();
                        return;
                    }
                }
            });
            this.historyReferencesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        HistoryReference historyReference = LogPanel.this.getHistoryReferenceTable().getSelectedHistoryReference();
                        if (historyReference == null) {
                            return;
                        }
                        LogPanel.this.readAndDisplay(historyReference);
                    }
                }
            });
        }
        return this.historyReferencesTable;
    }

    protected void display(HistoryReference historyReference) {
        this.readAndDisplay(historyReference);
        this.getHistoryReferenceTable().selectHistoryReference(historyReference.getHistoryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisplayQueue() {
        Vector<HistoryReference> vector = this.displayQueue;
        synchronized (vector) {
            this.displayQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndDisplay(HistoryReference historyReference) {
        Vector<HistoryReference> vector = this.displayQueue;
        synchronized (vector) {
            if (this.displayQueue.size() > 0) {
                this.displayQueue.clear();
            }
            this.displayQueue.add(historyReference);
        }
        if (this.thread != null && this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.setPriority(5);
        this.thread.start();
    }

    public void setDisplayPanel(HttpPanel httpPanel, HttpPanel httpPanel2) {
        this.requestPanel = httpPanel;
        this.responsePanel = httpPanel2;
    }

    private void displayMessage(HttpMessage httpMessage) {
        if (httpMessage.getRequestHeader().isEmpty()) {
            this.requestPanel.clearView(true);
        } else {
            this.requestPanel.setMessage(httpMessage);
        }
        if (httpMessage.getResponseHeader().isEmpty()) {
            this.responsePanel.clearView(false);
        } else {
            this.responsePanel.setMessage(httpMessage, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HistoryReference historyReference = null;
        int n = 0;
        while (true) {
            Object object = this.displayQueue;
            synchronized (object) {
                n = this.displayQueue.size();
                if (n == 0) {
                    break;
                }
                historyReference = this.displayQueue.get(0);
                this.displayQueue.remove(0);
            }
            try {
                object = historyReference.getHttpMessage();
                EventQueue.invokeAndWait(new Runnable((HttpMessage)object){
                    final /* synthetic */ HttpMessage val$msg;
                    {
                        this.val$msg = httpMessage;
                    }

                    @Override
                    public void run() {
                        LogPanel.this.displayMessage(this.val$msg);
                        LogPanel.this.getHistoryReferenceTable().requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    public void setFilterStatus(HistoryFilter historyFilter) {
        this.filterStatus.setText(historyFilter.toShortString());
        this.filterStatus.setToolTipText(historyFilter.toLongString());
    }

    private LinkWithSitesTreeSelectionListener getLinkWithSitesTreeSelectionListener() {
        if (this.linkWithSitesTreeSelectionListener == null) {
            this.linkWithSitesTreeSelectionListener = new LinkWithSitesTreeSelectionListener();
        }
        return this.linkWithSitesTreeSelectionListener;
    }

    public HistoryReference getSelectedHistoryReference() {
        return this.getHistoryReferenceTable().getSelectedHistoryReference();
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.getHistoryReferenceTable().getSelectedHistoryReferences();
    }

    public void setModel(HistoryReferencesTableModel<DefaultHistoryReferencesTableEntry> historyReferencesTableModel) {
        this.getHistoryReferenceTable().setModel(historyReferencesTableModel);
    }

    private class LinkWithSitesTreeSelectionListener
    implements TreeSelectionListener {
        private LinkWithSitesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            LogPanel.this.extension.updateLinkWithSitesTreeBaseUri(LogPanel.getLinkWithSitesTreeBaseUri((SiteNode)treeSelectionEvent.getPath().getLastPathComponent()));
        }
    }
}

