/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;

@Deprecated
public class PopupMenuEmbeddedBrowser
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionHistory extension = null;
    private Component lastInvoker = null;
    private BrowserLauncher launcher = null;
    private boolean supported = true;

    public PopupMenuEmbeddedBrowser() {
        this.initialize();
    }

    public PopupMenuEmbeddedBrowser(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.setText(Constant.messages.getString("history.browser.popup"));
        this.setActionCommand("");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryReference historyReference = null;
                if (PopupMenuEmbeddedBrowser.this.lastInvoker == null) {
                    return;
                }
                if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equalsIgnoreCase("ListLog")) {
                    historyReference = PopupMenuEmbeddedBrowser.this.extension.getSelectedHistoryReference();
                    PopupMenuEmbeddedBrowser.this.showBrowser(historyReference);
                } else if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equals("treeSite")) {
                    JTree jTree = (JTree)PopupMenuEmbeddedBrowser.this.lastInvoker;
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    historyReference = siteNode.getHistoryReference();
                    PopupMenuEmbeddedBrowser.this.showBrowser(historyReference);
                }
            }
        });
    }

    private BrowserLauncher getBrowserLauncher() {
        if (!this.supported) {
            return null;
        }
        if (this.launcher == null) {
            try {
                this.launcher = new BrowserLauncher();
            }
            catch (BrowserLaunchingInitializingException browserLaunchingInitializingException) {
                this.supported = false;
            }
            catch (UnsupportedOperatingSystemException unsupportedOperatingSystemException) {
                this.supported = false;
            }
        }
        return this.launcher;
    }

    private void showBrowser(HistoryReference historyReference) {
        if (!this.supported) {
            return;
        }
        try {
            this.getBrowserLauncher().openURLinBrowser(historyReference.getURI().toString());
        }
        catch (Exception exception) {
            this.extension.getView().showWarningDialog(Constant.messages.getString("history.browser.warning"));
        }
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        this.lastInvoker = null;
        if (!this.supported) {
            return false;
        }
        if (component.getName() == null) {
            return false;
        }
        if (component.getName().equalsIgnoreCase("ListLog")) {
            JList jList = (JList)component;
            if (jList.getSelectedIndex() >= 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.lastInvoker = component;
            return true;
        }
        if (component.getName().equals("treeSite")) {
            JTree jTree = (JTree)component;
            this.lastInvoker = jTree;
            SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
            this.setEnabled(siteNode != null && siteNode.getHistoryReference() != null);
            return true;
        }
        return false;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }
}

