/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.utils.XMLStringUtil;
import org.zaproxy.zap.utils.XmlUtils;

public class ReportGenerator {
    private static final Logger logger = Logger.getLogger(ReportGenerator.class);
    private static final SimpleDateFormat staticDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    public static File XMLToHtml(Document document, String string, File file) {
        File file2 = null;
        file = new File(file.getAbsolutePath());
        try {
            file2 = new File(string);
            DOMSource dOMSource = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(file2);
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            logger.error((Object)transformerException.getMessage(), (Throwable)transformerException);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File stringToHtml(String string, String string2, String string3) {
        if (string2 != null) {
            Object object;
            Object object2;
            Object object3;
            Document document = null;
            File file = null;
            File file2 = null;
            StringReader stringReader = new StringReader(string);
            String string4 = string3 + ".temp";
            try {
                file = new File(string2);
                file2 = new File(string4);
                object3 = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
                document = ((DocumentBuilder)object3).parse(new InputSource(stringReader));
                object2 = TransformerFactory.newInstance();
                object = new StreamSource(file);
                Transformer transformer = ((TransformerFactory)object2).newTransformer((Source)object);
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(file2);
                transformer.transform(dOMSource, streamResult);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                object2 = null;
                try {
                    object2 = new BufferedWriter(new FileWriter(string3 + "-orig.xml"));
                    ((Writer)object2).write(string);
                }
                catch (IOException iOException) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    try {
                        if (object2 != null) {
                            ((BufferedWriter)object2).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            object3 = null;
            object2 = null;
            try {
                object3 = new BufferedReader(new FileReader(string4));
                object2 = new BufferedWriter(new FileWriter(string3));
                while ((object = ((BufferedReader)object3).readLine()) != null) {
                    ((Writer)object2).write(((String)object).replace("&lt;p&gt;", "<p>").replace("&lt;/p&gt;", "</p>"));
                    ((BufferedWriter)object2).newLine();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            finally {
                try {
                    if (object3 != null) {
                        ((BufferedReader)object3).close();
                    }
                    if (object2 != null) {
                        ((BufferedWriter)object2).close();
                    }
                }
                catch (IOException iOException) {}
            }
            file2.delete();
        } else {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string3));
                bufferedWriter.write(string);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new File(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringToHtml(String string, String string2) {
        Document document = null;
        File file = null;
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        try {
            file = new File(string2);
            DocumentBuilder documentBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(stringReader));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(file);
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return stringWriter.toString().replace("&lt;p&gt;", "<p>").replace("&lt;/p&gt;", "</p>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fileToHtml(String string, String string2, String string3) {
        Document document = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file = new File(string2);
            file2 = new File(string);
            file3 = new File(string3);
            DocumentBuilder documentBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            document = documentBuilder.parse(file2);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(file);
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file3);
            transformer.transform(dOMSource, streamResult);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return file3;
    }

    public static String entityEncode(String string) {
        String string2 = string;
        if (string2 == null) {
            return string2;
        }
        return StringEscapeUtils.escapeXml(XMLStringUtil.escapeControlChrs(string2));
    }

    public static String getCurrentDateTimeString() {
        Date date = new Date(System.currentTimeMillis());
        return ReportGenerator.getDateTimeString(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateTimeString(Date date) {
        SimpleDateFormat simpleDateFormat = staticDateFormat;
        synchronized (simpleDateFormat) {
            return staticDateFormat.format(date);
        }
    }

    public static void addChildTextNode(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
    }

    public static String getDebugXMLString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString().replaceAll("\n|\r", "");
    }
}

