/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.File;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class OptionsParamCheckForUpdates
extends AbstractParam {
    public static final String CHECK_ON_START = "start.checkForUpdates";
    public static final String DAY_LAST_CHECKED = "start.dayLastChecked";
    public static final String DAY_LAST_INSTALL_WARNED = "start.dayLastInstallWarned";
    public static final String DAY_LAST_UPDATE_WARNED = "start.dayLastUpdateWarned";
    public static final String DOWNLOAD_NEW_RELEASE = "start.downloadNewRelease";
    public static final String CHECK_ADDON_UPDATES = "start.checkAddonUpdates";
    public static final String INSTALL_ADDON_UPDATES = "start.installAddonUpdates";
    public static final String INSTALL_SCANNER_RULES = "start.installScannerRules";
    public static final String REPORT_RELEASE_ADDON = "start.reportReleaseAddons";
    public static final String REPORT_BETA_ADDON = "start.reportBetaAddons";
    public static final String REPORT_ALPHA_ADDON = "start.reportAlphaAddons";
    public static final String ADDON_DIRS = "start.addonDirs";
    public static final String DOWNLOAD_DIR = "start.downloadDir";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private boolean checkOnStart;
    private boolean downloadNewRelease = false;
    private boolean checkAddonUpdates = false;
    private boolean installAddonUpdates = false;
    private boolean installScannerRules = false;
    private boolean reportReleaseAddons = false;
    private boolean reportBetaAddons = false;
    private boolean reportAlphaAddons = false;
    private List<File> addonDirectories = new ArrayList<File>();
    private File downloadDirectory = new File(Constant.FOLDER_LOCAL_PLUGIN);
    private String dayLastChecked = null;
    private String dayLastInstallWarned = null;
    private String dayLastUpdateWarned = null;
    private boolean unset = true;
    private static Logger log = Logger.getLogger(OptionsParamCheckForUpdates.class);

    @Override
    protected void parse() {
        this.updateOldOptions();
        this.checkOnStart = this.getConfig().getBoolean(CHECK_ON_START, false);
        this.dayLastChecked = this.getConfig().getString(DAY_LAST_CHECKED, "");
        this.unset = this.dayLastChecked.length() == 0;
        this.dayLastInstallWarned = this.getConfig().getString(DAY_LAST_INSTALL_WARNED, "");
        this.dayLastUpdateWarned = this.getConfig().getString(DAY_LAST_UPDATE_WARNED, "");
        this.downloadNewRelease = this.getConfig().getBoolean(DOWNLOAD_NEW_RELEASE, false);
        this.checkAddonUpdates = this.getConfig().getBoolean(CHECK_ADDON_UPDATES, false);
        this.installAddonUpdates = this.getConfig().getBoolean(INSTALL_ADDON_UPDATES, false);
        this.installScannerRules = this.getConfig().getBoolean(INSTALL_SCANNER_RULES, false);
        this.reportReleaseAddons = this.getConfig().getBoolean(REPORT_RELEASE_ADDON, false);
        this.reportBetaAddons = this.getConfig().getBoolean(REPORT_BETA_ADDON, false);
        this.reportAlphaAddons = this.getConfig().getBoolean(REPORT_ALPHA_ADDON, false);
        for (Object e : this.getConfig().getList(ADDON_DIRS)) {
            File file = new File(e.toString());
            if (!file.exists()) {
                log.error((Object)("Add-on directory does not exist: " + file.getAbsolutePath()));
                continue;
            }
            if (!file.isDirectory()) {
                log.error((Object)("Add-on directory is not a directory: " + file.getAbsolutePath()));
                continue;
            }
            if (!file.canRead()) {
                log.error((Object)("Add-on directory not readable: " + file.getAbsolutePath()));
                continue;
            }
            this.addonDirectories.add(file);
        }
        this.setDownloadDirectory(new File(this.getConfig().getString(DOWNLOAD_DIR, Constant.FOLDER_LOCAL_PLUGIN)), false);
    }

    private void updateOldOptions() {
        try {
            int n = this.getConfig().getInt(CHECK_ON_START, 0);
            this.getConfig().setProperty(CHECK_ON_START, (Object)(n != 0 ? 1 : 0));
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @ZapApiIgnore
    public boolean isCheckOnStartUnset() {
        return this.unset;
    }

    @Deprecated
    @ZapApiIgnore
    public void setCheckOnStart(int n) {
        this.setCheckOnStart(n != 0);
    }

    public void setCheckOnStart(boolean bl) {
        this.checkOnStart = bl;
        this.getConfig().setProperty(CHECK_ON_START, (Object)bl);
        if (this.dayLastChecked.length() == 0) {
            this.dayLastChecked = "Never";
            this.getConfig().setProperty(DAY_LAST_CHECKED, (Object)this.dayLastChecked);
        }
    }

    public boolean isCheckOnStart() {
        return this.checkOnStart;
    }

    @ZapApiIgnore
    public boolean checkOnStart() {
        if (!this.checkOnStart) {
            log.debug((Object)"isCheckForStart - false");
            return false;
        }
        String string = sdf.format(new Date());
        if (string.equals(this.dayLastChecked)) {
            log.debug((Object)"isCheckForStart - already checked today");
            return false;
        }
        this.getConfig().setProperty(DAY_LAST_CHECKED, (Object)string);
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
        return true;
    }

    public Date getDayLastChecked() {
        try {
            return sdf.parse(this.dayLastChecked);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getDayLastInstallWarned() {
        try {
            return sdf.parse(this.dayLastInstallWarned);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getDayLastUpdateWarned() {
        try {
            return sdf.parse(this.dayLastUpdateWarned);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setDayLastInstallWarned() {
        this.getConfig().setProperty(DAY_LAST_INSTALL_WARNED, (Object)sdf.format(new Date()));
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
    }

    public void setDayLastUpdateWarned() {
        this.getConfig().setProperty(DAY_LAST_UPDATE_WARNED, (Object)sdf.format(new Date()));
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
    }

    public boolean isDownloadNewRelease() {
        return this.downloadNewRelease;
    }

    public void setDownloadNewRelease(boolean bl) {
        this.downloadNewRelease = bl;
        this.getConfig().setProperty(DOWNLOAD_NEW_RELEASE, (Object)this.downloadNewRelease);
    }

    public boolean isCheckAddonUpdates() {
        return this.checkAddonUpdates;
    }

    public void setCheckAddonUpdates(boolean bl) {
        this.checkAddonUpdates = bl;
        this.getConfig().setProperty(CHECK_ADDON_UPDATES, (Object)bl);
    }

    public boolean isInstallAddonUpdates() {
        return this.installAddonUpdates;
    }

    public void setInstallAddonUpdates(boolean bl) {
        this.installAddonUpdates = bl;
        this.getConfig().setProperty(INSTALL_ADDON_UPDATES, (Object)bl);
    }

    public boolean isInstallScannerRules() {
        return this.installScannerRules;
    }

    public void setInstallScannerRules(boolean bl) {
        this.installScannerRules = bl;
        this.getConfig().setProperty(INSTALL_SCANNER_RULES, (Object)bl);
    }

    public boolean isReportReleaseAddons() {
        return this.reportReleaseAddons;
    }

    public void setReportReleaseAddons(boolean bl) {
        this.reportReleaseAddons = bl;
        this.getConfig().setProperty(REPORT_RELEASE_ADDON, (Object)bl);
    }

    public boolean isReportBetaAddons() {
        return this.reportBetaAddons;
    }

    public void setReportBetaAddons(boolean bl) {
        this.reportBetaAddons = bl;
        this.getConfig().setProperty(REPORT_BETA_ADDON, (Object)bl);
    }

    public boolean isReportAlphaAddons() {
        return this.reportAlphaAddons;
    }

    public void setReportAlphaAddons(boolean bl) {
        this.reportAlphaAddons = bl;
        this.getConfig().setProperty(REPORT_ALPHA_ADDON, (Object)bl);
    }

    public List<File> getAddonDirectories() {
        return this.addonDirectories;
    }

    public void setAddonDirectories(List<File> list) {
        this.addonDirectories = list;
        this.getConfig().setProperty(ADDON_DIRS, list);
    }

    public File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public void setDownloadDirectory(File file) throws InvalidParameterException {
        this.setDownloadDirectory(file, true);
    }

    private void setDownloadDirectory(File file, boolean bl) throws InvalidParameterException {
        if (!Constant.FOLDER_LOCAL_PLUGIN.equals(file.getAbsolutePath())) {
            boolean bl2 = false;
            for (File file2 : this.addonDirectories) {
                if (!file2.equals(file)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new InvalidParameterException("Directory must be the default one or one of the addonDirectories " + file.getAbsolutePath());
            }
        }
        if (!file.canWrite()) {
            throw new InvalidParameterException("No write access to directory " + file.getAbsolutePath());
        }
        this.downloadDirectory = file;
        if (bl) {
            this.getConfig().setProperty(DOWNLOAD_DIR, (Object)file.getAbsolutePath());
        }
    }
}

