/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanelToolbarFactory;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.tab.Tab;

public class BreakPanel
extends AbstractPanel
implements Tab {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_PANEL = "request";
    private static final String RESPONSE_PANEL = "response";
    private HttpPanelRequest requestPanel;
    private HttpPanelResponse responsePanel;
    private ExtensionBreak extension;
    private JPanel panelContent;
    private BreakPanelToolbarFactory breakToolbarFactory;
    private BreakpointsParam breakpointsParams;
    private JToggleButton mainReqButton = null;
    private JToggleButton mainResButton = null;
    private JToggleButton mainAllButton = null;
    private JToggleButton panelReqButton = null;
    private JToggleButton panelResButton = null;
    private JToggleButton panelAllButton = null;
    private boolean isAlwaysOnTop = false;

    public BreakPanel(ExtensionBreak extensionBreak, BreakpointsParam breakpointsParam) {
        this.extension = extensionBreak;
        this.breakpointsParams = breakpointsParam;
        this.setIcon(new ImageIcon(BreakPanel.class.getResource("/resource/icon/16/101grey.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("brk.panel.mnemonic"));
        this.setLayout(new BorderLayout());
        this.breakToolbarFactory = new BreakPanelToolbarFactory(breakpointsParam, this);
        this.panelContent = new JPanel(new CardLayout());
        this.add((Component)this.panelContent, "Center");
        this.requestPanel = new HttpPanelRequest(false, "view.break.");
        this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel = new HttpPanelResponse(false, "view.break.");
        this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.panelContent.add((Component)this.requestPanel, REQUEST_PANEL);
        this.panelContent.add((Component)this.responsePanel, RESPONSE_PANEL);
        switch (Model.getSingleton().getOptionsParam().getViewParam().getBrkPanelViewOption()) {
            case 0: {
                if (Model.getSingleton().getOptionsParam().getViewParam().getShowMainToolbar() == 0) {
                    this.add((Component)this.getPanelCommand(), "North");
                    break;
                }
                this.getPanelMainToolbarCommand();
                break;
            }
            case 1: {
                this.requestPanel.addOptions(this.getPanelCommand(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
                this.responsePanel.addOptions(this.getPanelCommand(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
                break;
            }
            case 2: {
                this.requestPanel.addOptions(this.getPanelCommand(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
                this.responsePanel.addOptions(this.getPanelCommand(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
                this.getPanelMainToolbarCommand();
                break;
            }
            default: {
                this.getPanelMainToolbarCommand();
            }
        }
        this.setButtonMode(breakpointsParam.getButtonMode());
    }

    public boolean isBreakRequest() {
        return this.breakToolbarFactory.isBreakRequest();
    }

    public boolean isBreakResponse() {
        return this.breakToolbarFactory.isBreakResponse();
    }

    public boolean isBreakAll() {
        return this.breakToolbarFactory.isBreakAll();
    }

    public void breakpointHit() {
        this.breakToolbarFactory.breakpointHit();
    }

    public boolean isHoldMessage() {
        return this.breakToolbarFactory.isHoldMessage();
    }

    public boolean isStepping() {
        return this.breakToolbarFactory.isStepping();
    }

    public boolean isToBeDropped() {
        return this.breakToolbarFactory.isToBeDropped();
    }

    protected void breakpointDisplayed() {
        final Boolean bl = this.breakpointsParams.getAlwaysOnTop();
        if (bl == null || bl.booleanValue()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().setAlwaysOnTop(true);
                    View.getSingleton().getMainFrame().toFront();
                    BreakPanel.this.setTabFocus();
                    BreakPanel.this.isAlwaysOnTop = true;
                    if (bl == null) {
                        boolean bl2 = View.getSingleton().showConfirmDialog(Constant.messages.getString("brk.alwaysOnTop.message")) == 0;
                        BreakPanel.this.breakpointsParams.setAlwaysOnTop(bl2);
                        if (!bl2) {
                            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
                            BreakPanel.this.isAlwaysOnTop = false;
                        }
                    }
                }
            });
        }
    }

    private JToolBar getPanelCommand() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setRollover(true);
        jToolBar.setName("Command");
        jToolBar.add(this.getPanelReqButton());
        jToolBar.add(this.getPanelResButton());
        jToolBar.add(this.getPanelAllButton());
        jToolBar.add(this.breakToolbarFactory.getBtnStep());
        jToolBar.add(this.breakToolbarFactory.getBtnContinue());
        jToolBar.add(this.breakToolbarFactory.getBtnDrop());
        jToolBar.add(this.breakToolbarFactory.getBtnBreakPoint());
        return jToolBar;
    }

    private void getPanelMainToolbarCommand() {
        View.getSingleton().addMainToolbarButton(this.getMainReqButton());
        View.getSingleton().addMainToolbarButton(this.getMainResButton());
        View.getSingleton().addMainToolbarButton(this.getMainAllButton());
        View.getSingleton().addMainToolbarButton(this.breakToolbarFactory.getBtnStep());
        View.getSingleton().addMainToolbarButton(this.breakToolbarFactory.getBtnContinue());
        View.getSingleton().addMainToolbarButton(this.breakToolbarFactory.getBtnDrop());
        View.getSingleton().addMainToolbarButton(this.breakToolbarFactory.getBtnBreakPoint());
    }

    private JToggleButton getMainReqButton() {
        if (this.mainReqButton == null) {
            this.mainReqButton = this.breakToolbarFactory.getBtnBreakRequest();
        }
        return this.mainReqButton;
    }

    private JToggleButton getMainResButton() {
        if (this.mainResButton == null) {
            this.mainResButton = this.breakToolbarFactory.getBtnBreakResponse();
        }
        return this.mainResButton;
    }

    private JToggleButton getMainAllButton() {
        if (this.mainAllButton == null) {
            this.mainAllButton = this.breakToolbarFactory.getBtnBreakAll();
        }
        return this.mainAllButton;
    }

    private JToggleButton getPanelReqButton() {
        if (this.panelReqButton == null) {
            this.panelReqButton = this.breakToolbarFactory.getBtnBreakRequest();
        }
        return this.panelReqButton;
    }

    private JToggleButton getPanelResButton() {
        if (this.panelResButton == null) {
            this.panelResButton = this.breakToolbarFactory.getBtnBreakResponse();
        }
        return this.panelResButton;
    }

    private JToggleButton getPanelAllButton() {
        if (this.panelAllButton == null) {
            this.panelAllButton = this.breakToolbarFactory.getBtnBreakAll();
        }
        return this.panelAllButton;
    }

    public void setMessage(Message message, boolean bl) {
        CardLayout cardLayout = (CardLayout)this.panelContent.getLayout();
        if (bl) {
            this.requestPanel.setMessage(message, true);
            this.requestPanel.setEditable(true);
            cardLayout.show(this.panelContent, REQUEST_PANEL);
        } else {
            this.responsePanel.setMessage(message, true);
            this.responsePanel.setEditable(true);
            cardLayout.show(this.panelContent, RESPONSE_PANEL);
        }
    }

    public void saveMessage(boolean bl) {
        CardLayout cardLayout = (CardLayout)this.panelContent.getLayout();
        if (bl) {
            this.requestPanel.saveData();
            cardLayout.show(this.panelContent, REQUEST_PANEL);
        } else {
            this.responsePanel.saveData();
            cardLayout.show(this.panelContent, RESPONSE_PANEL);
        }
    }

    public void savePanels() {
        this.requestPanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
    }

    public void clearAndDisableRequest() {
        this.requestPanel.clearView(false);
        this.requestPanel.setEditable(false);
        this.breakpointLeft();
    }

    public void clearAndDisableResponse() {
        this.responsePanel.clearView(false);
        this.responsePanel.setEditable(false);
        this.breakpointLeft();
    }

    private void breakpointLeft() {
        if (this.isAlwaysOnTop) {
            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
            this.isAlwaysOnTop = false;
        }
    }

    public void init() {
        this.breakToolbarFactory.init();
    }

    public void reset() {
        this.breakToolbarFactory.reset();
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (mode.equals((Object)Control.Mode.safe)) {
            this.breakToolbarFactory.setBreakEnabled(false);
        } else {
            this.breakToolbarFactory.setBreakEnabled(true);
        }
    }

    public void setBreakAllRequests(boolean bl) {
        this.breakToolbarFactory.setBreakRequest(bl);
    }

    public void setBreakAllResponses(boolean bl) {
        this.breakToolbarFactory.setBreakResponse(bl);
    }

    public void setBreakAll(boolean bl) {
        this.breakToolbarFactory.setBreakAll(bl);
    }

    public void step() {
        this.breakToolbarFactory.setStep(true);
    }

    public void cont() {
        this.breakToolbarFactory.setContinue(true);
    }

    public void drop() {
        this.breakToolbarFactory.drop();
    }

    public void showNewBreakPointDialog() {
        this.extension.addUiBreakpoint(new HttpMessage());
    }

    public void setButtonMode(int n) {
        this.breakToolbarFactory.setButtonMode(n);
        switch (n) {
            case 1: {
                this.getMainReqButton().setVisible(false);
                this.getMainResButton().setVisible(false);
                this.getMainAllButton().setVisible(true);
                break;
            }
            case 2: {
                this.getMainReqButton().setVisible(true);
                this.getMainResButton().setVisible(true);
                this.getMainAllButton().setVisible(false);
            }
        }
    }
}

