/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import org.zaproxy.zap.extension.script.ScriptNode;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private Map<String, ScriptNode> scriptsNodeMap = new HashMap<String, ScriptNode>();
    private Map<String, ScriptNode> templatesNodeMap = new HashMap<String, ScriptNode>();
    private ScriptNode scriptsNode = new ScriptNode(false);
    private ScriptNode templatesNode = new ScriptNode(true);

    ScriptTreeModel() {
        super(new ScriptNode());
        this.getRoot().add(this.scriptsNode);
        this.getRoot().add(this.templatesNode);
    }

    protected void addType(ScriptType scriptType) {
        ScriptNode scriptNode = new ScriptNode(scriptType, false);
        this.scriptsNodeMap.put(scriptType.getName(), scriptNode);
        this.addToParentSorted(this.scriptsNode, scriptNode);
        ScriptNode scriptNode2 = new ScriptNode(scriptType, true);
        this.templatesNodeMap.put(scriptType.getName(), scriptNode2);
        this.addToParentSorted(this.templatesNode, scriptNode2);
    }

    protected void removeType(ScriptType scriptType) {
        ScriptNode scriptNode;
        String string = scriptType.getName();
        ScriptNode scriptNode2 = this.scriptsNodeMap.remove(string);
        if (scriptNode2 != null) {
            this.removeNodeFromParent(scriptNode2);
        }
        if ((scriptNode = this.templatesNodeMap.remove(string)) != null) {
            this.removeNodeFromParent(scriptNode);
        }
    }

    private void addToParentSorted(ScriptNode scriptNode, ScriptNode scriptNode2) {
        int n;
        int n2 = n = scriptNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ScriptNode scriptNode3 = (ScriptNode)scriptNode.getChildAt(i);
            if (scriptNode2.getNodeName().compareToIgnoreCase(scriptNode3.getNodeName()) >= 0) continue;
            n2 = i;
            break;
        }
        this.insertNodeInto(scriptNode2, scriptNode, n2);
    }

    public ScriptNode getTypeNode(String string) {
        return this.scriptsNodeMap.get(string);
    }

    @Override
    public ScriptNode getRoot() {
        return (ScriptNode)this.root;
    }

    public ScriptNode getScriptsNode() {
        return this.scriptsNode;
    }

    public ScriptNode getTemplatesNode() {
        return this.templatesNode;
    }

    public List<ScriptNode> getNodes(String string) {
        ArrayList<ScriptNode> arrayList = new ArrayList<ScriptNode>();
        ScriptNode scriptNode = this.scriptsNodeMap.get(string);
        if (scriptNode != null) {
            for (int i = 0; i < scriptNode.getChildCount(); ++i) {
                arrayList.add((ScriptNode)scriptNode.getChildAt(i));
            }
        }
        return arrayList;
    }

    public ScriptNode addScript(ScriptWrapper scriptWrapper) {
        if (scriptWrapper == null) {
            return null;
        }
        if (this.getScript(scriptWrapper.getName()) != null) {
            throw new InvalidParameterException("A script with the same name already exists: " + scriptWrapper.getName());
        }
        if (scriptWrapper.getType() == null) {
            throw new InvalidParameterException("Script does not define a type: " + scriptWrapper.getName());
        }
        ScriptNode scriptNode = new ScriptNode(scriptWrapper);
        if (scriptWrapper.getType() == null) {
            throw new InvalidParameterException("Unrecognised type: " + scriptWrapper.getTypeName());
        }
        ScriptNode scriptNode2 = this.scriptsNodeMap.get(scriptWrapper.getType().getName());
        if (scriptNode2 != null) {
            this.addToParentSorted(scriptNode2, scriptNode);
            return scriptNode;
        }
        throw new InvalidParameterException("Unrecognised type: " + scriptWrapper.getType() + " for script " + scriptWrapper.getName());
    }

    public void removeScript(ScriptWrapper scriptWrapper) {
        if (scriptWrapper == null) {
            return;
        }
        ScriptNode scriptNode = this.getNodeForScript(scriptWrapper);
        ScriptNode scriptNode2 = scriptNode.getParent();
        if (scriptNode2 != null) {
            this.removeNodeFromParent(scriptNode);
        }
    }

    public ScriptNode getNodeForScript(ScriptWrapper scriptWrapper) {
        ScriptNode scriptNode = this.scriptsNodeMap.get(scriptWrapper.getType().getName());
        if (scriptNode != null && scriptNode.getChildCount() > 0) {
            ScriptNode scriptNode2 = (ScriptNode)scriptNode.getFirstChild();
            while (scriptNode2 != null) {
                if (scriptWrapper.equals(scriptNode2.getUserObject())) {
                    return scriptNode2;
                }
                scriptNode2 = (ScriptNode)scriptNode.getChildAfter(scriptNode2);
            }
        }
        return null;
    }

    public void nodeStructureChanged(ScriptWrapper scriptWrapper) {
        ScriptNode scriptNode = this.getNodeForScript(scriptWrapper);
        if (scriptNode != null) {
            this.nodeStructureChanged(scriptNode);
        }
    }

    public ScriptWrapper getScript(String string) {
        ScriptNode scriptNode = (ScriptNode)this.scriptsNode.getFirstChild();
        while (scriptNode != null) {
            if (scriptNode.getChildCount() > 0) {
                ScriptNode scriptNode2 = (ScriptNode)scriptNode.getFirstChild();
                while (scriptNode2 != null) {
                    if (((ScriptWrapper)scriptNode2.getUserObject()).getName().equals(string)) {
                        return (ScriptWrapper)scriptNode2.getUserObject();
                    }
                    scriptNode2 = (ScriptNode)scriptNode.getChildAfter(scriptNode2);
                }
            }
            scriptNode = (ScriptNode)this.scriptsNode.getChildAfter(scriptNode);
        }
        return null;
    }

    public ScriptNode addTemplate(ScriptWrapper scriptWrapper) {
        if (scriptWrapper == null) {
            return null;
        }
        if (this.getTemplate(scriptWrapper.getName()) != null) {
            throw new InvalidParameterException("A template with the same name already exists: " + scriptWrapper.getName());
        }
        ScriptNode scriptNode = new ScriptNode(scriptWrapper, true);
        ScriptNode scriptNode2 = this.templatesNodeMap.get(scriptWrapper.getType().getName());
        if (scriptNode2 != null) {
            this.addToParentSorted(scriptNode2, scriptNode);
            return scriptNode;
        }
        throw new InvalidParameterException("Unrecognised type: " + scriptWrapper.getType());
    }

    public void removeTemplate(ScriptWrapper scriptWrapper) {
        if (scriptWrapper == null) {
            return;
        }
        ScriptNode scriptNode = this.getNodeForTemplate(scriptWrapper);
        ScriptNode scriptNode2 = scriptNode.getParent();
        if (scriptNode2 != null) {
            this.removeNodeFromParent(scriptNode);
        }
    }

    public ScriptWrapper getTemplate(String string) {
        ScriptNode scriptNode = (ScriptNode)this.templatesNode.getFirstChild();
        while (scriptNode != null) {
            if (scriptNode.getChildCount() > 0) {
                ScriptNode scriptNode2 = (ScriptNode)scriptNode.getFirstChild();
                while (scriptNode2 != null) {
                    if (((ScriptWrapper)scriptNode2.getUserObject()).getName().equals(string)) {
                        return (ScriptWrapper)scriptNode2.getUserObject();
                    }
                    scriptNode2 = (ScriptNode)scriptNode.getChildAfter(scriptNode2);
                }
            }
            scriptNode = (ScriptNode)this.templatesNode.getChildAfter(scriptNode);
        }
        return null;
    }

    public ScriptNode getNodeForTemplate(ScriptWrapper scriptWrapper) {
        ScriptNode scriptNode = this.templatesNodeMap.get(scriptWrapper.getType().getName());
        if (scriptNode != null) {
            ScriptNode scriptNode2 = (ScriptNode)scriptNode.getFirstChild();
            while (scriptNode2 != null) {
                if (scriptWrapper.equals(scriptNode2.getUserObject())) {
                    return scriptNode2;
                }
                scriptNode2 = (ScriptNode)scriptNode.getChildAfter(scriptNode2);
            }
        }
        return null;
    }

    public List<ScriptWrapper> getTemplates(ScriptType scriptType) {
        ArrayList<ScriptWrapper> arrayList = new ArrayList<ScriptWrapper>();
        ScriptNode scriptNode = (ScriptNode)this.templatesNode.getFirstChild();
        while (scriptNode != null) {
            if ((scriptType == null || scriptType.equals(scriptNode.getType())) && scriptNode.getChildCount() > 0) {
                ScriptNode scriptNode2 = (ScriptNode)scriptNode.getFirstChild();
                while (scriptNode2 != null) {
                    arrayList.add((ScriptWrapper)scriptNode2.getUserObject());
                    scriptNode2 = (ScriptNode)scriptNode.getChildAfter(scriptNode2);
                }
            }
            scriptNode = (ScriptNode)this.templatesNode.getChildAfter(scriptNode);
        }
        return arrayList;
    }
}

