/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.net.CookieManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.SpiderController;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.filters.DefaultFetchFilter;
import org.zaproxy.zap.spider.filters.DefaultParseFilter;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class Spider {
    private SpiderParam spiderParam;
    private ConnectionParam connectionParam;
    private Model model;
    private List<SpiderListener> listeners;
    private volatile boolean paused;
    private volatile boolean stopped;
    private ReentrantLock pauseLock = new ReentrantLock();
    private SpiderController controller;
    private Condition pausedCondition = this.pauseLock.newCondition();
    private ExecutorService threadPool;
    private DefaultFetchFilter defaultFetchFilter;
    private List<URI> seedList;
    private ExtensionSpider extension;
    private static final Logger log = Logger.getLogger(Spider.class);
    private HttpSender httpSender;
    private int tasksDoneCount;
    private int tasksTotalCount;
    private CookieManager cookieManager;
    private Context scanContext;
    private User scanUser;
    private boolean initialized;
    private static final Pattern svnUrlPattern = Pattern.compile("\\.svn/");
    private static final Pattern gitUrlPattern = Pattern.compile("\\.git/");

    public Spider(ExtensionSpider extensionSpider, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context context) {
        log.info((Object)"Spider initializing...");
        this.spiderParam = spiderParam;
        this.connectionParam = connectionParam;
        this.model = model;
        this.controller = new SpiderController(this, extensionSpider.getCustomParsers());
        this.listeners = new LinkedList<SpiderListener>();
        this.seedList = new ArrayList<URI>();
        this.cookieManager = new CookieManager();
        this.scanContext = context;
        this.extension = extensionSpider;
        this.init();
    }

    private void init() {
        this.paused = false;
        this.stopped = true;
        this.tasksDoneCount = 0;
        this.tasksTotalCount = 0;
        this.initialized = false;
        this.defaultFetchFilter = new DefaultFetchFilter();
        this.addFetchFilter(this.defaultFetchFilter);
        for (FetchFilter object : this.extension.getCustomFetchFilters()) {
            this.addFetchFilter(object);
        }
        this.addParseFilter(new DefaultParseFilter());
        for (ParseFilter parseFilter : this.extension.getCustomParseFilters()) {
            this.addParseFilter(parseFilter);
        }
        this.defaultFetchFilter.setScanContext(this.scanContext);
        this.defaultFetchFilter.setDomainsAlwaysInScope(this.spiderParam.getDomainsAlwaysInScopeEnabled());
    }

    public void addSeed(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        this.addSeed(uRI);
    }

    public void addSeed(URI uRI) {
        String string;
        Object object;
        String string2;
        String string3;
        URI uRI2;
        String string4 = null;
        try {
            string4 = uRI.getHost();
            this.defaultFetchFilter.addScopeRegex(string4);
        }
        catch (URIException uRIException) {
            log.error((Object)("There was an error while adding seed value: " + uRI), (Throwable)uRIException);
            return;
        }
        this.seedList.add(uRI);
        if (this.getSpiderParam().isParseRobotsTxt()) {
            try {
                uRI2 = uRI.getPort() == 80 || uRI.getPort() == 443 ? new URI(uRI.getScheme() + "://" + string4 + "/robots.txt", true) : new URI(uRI.getScheme() + "://" + string4 + ":" + uRI.getPort() + "/robots.txt", true);
                this.seedList.add(uRI2);
            }
            catch (Exception exception) {
                log.warn((Object)("Error while creating URI for robots.txt file for site " + uRI), (Throwable)exception);
            }
        }
        if (this.getSpiderParam().isParseSitemapXml()) {
            try {
                uRI2 = uRI.getPort() == 80 || uRI.getPort() == 443 ? new URI(uRI.getScheme() + "://" + string4 + "/sitemap.xml", true) : new URI(uRI.getScheme() + "://" + string4 + ":" + uRI.getPort() + "/sitemap.xml", true);
                this.seedList.add(uRI2);
            }
            catch (Exception exception) {
                log.warn((Object)("Error while creating URI for sitemap.xml file for site " + uRI), (Throwable)exception);
            }
        }
        if (this.getSpiderParam().isParseSVNEntries()) {
            try {
                Matcher matcher;
                string3 = uRI.getPath();
                string2 = uRI.getName();
                if (string3 == null) {
                    string3 = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                if (((String)(object = string3.substring(0, string3.lastIndexOf(string2)))).equals("")) {
                    object = "/";
                }
                if (!(matcher = svnUrlPattern.matcher((CharSequence)object)).find()) {
                    if (uRI.getPort() == 80 || uRI.getPort() == 443) {
                        uRI2 = new URI(uRI.getScheme() + "://" + string4 + (String)object + ".svn/entries", true);
                        string = new URI(uRI.getScheme() + "://" + string4 + (String)object + ".svn/wc.db", true);
                    } else {
                        uRI2 = new URI(uRI.getScheme() + "://" + string4 + ":" + uRI.getPort() + (String)object + ".svn/entries", true);
                        string = new URI(uRI.getScheme() + "://" + string4 + ":" + uRI.getPort() + (String)object + ".svn/wc.db", true);
                    }
                    this.seedList.add(uRI2);
                    this.seedList.add((URI)string);
                }
            }
            catch (Exception exception) {
                log.warn((Object)("Error while creating a seed URI for the SVN files for site " + uRI), (Throwable)exception);
            }
        }
        if (this.getSpiderParam().isParseGit()) {
            try {
                string = uRI.getPath();
                string3 = uRI.getName();
                if (string == null) {
                    string = "";
                }
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = string.substring(0, string.lastIndexOf(string3))).equals("")) {
                    string2 = "/";
                }
                if (!((Matcher)(object = gitUrlPattern.matcher(string2))).find()) {
                    uRI2 = uRI.getPort() == 80 || uRI.getPort() == 443 ? new URI(uRI.getScheme() + "://" + string4 + string2 + ".git/index", true) : new URI(uRI.getScheme() + "://" + string4 + ":" + uRI.getPort() + string2 + ".git/index", true);
                    this.seedList.add(uRI2);
                }
            }
            catch (Exception exception) {
                log.warn((Object)("Error while creating a seed URI for the Git files for site " + uRI), (Throwable)exception);
            }
        }
    }

    public void setExcludeList(List<String> list) {
        log.debug((Object)("New Exclude list: " + list));
        this.defaultFetchFilter.setExcludeRegexes(list);
    }

    public void addFetchFilter(FetchFilter fetchFilter) {
        this.controller.addFetchFilter(fetchFilter);
    }

    public void addParseFilter(ParseFilter parseFilter) {
        this.controller.addParseFilter(parseFilter);
    }

    protected HttpSender getHttpSender() {
        return this.httpSender;
    }

    protected SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    protected ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    protected SpiderController getController() {
        return this.controller;
    }

    protected CookieManager getCookieManager() {
        return this.cookieManager;
    }

    protected Model getModel() {
        return this.model;
    }

    protected synchronized void submitTask(SpiderTask spiderTask) {
        block4: {
            if (this.isStopped()) {
                log.debug((Object)("Submitting task skipped (" + spiderTask + ") as the Spider process is stopped."));
                return;
            }
            if (this.isTerminated()) {
                log.debug((Object)("Submitting task skipped (" + spiderTask + ") as the Spider process is terminated."));
                return;
            }
            ++this.tasksTotalCount;
            try {
                this.threadPool.execute(spiderTask);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Submitted task was rejected (" + spiderTask + "), spider state: [stopped=" + this.isStopped() + ", terminated=" + this.isTerminated() + "]."));
            }
        }
    }

    public void start() {
        log.info((Object)"Starting spider...");
        if (this.seedList == null || this.seedList.isEmpty()) {
            log.warn((Object)"No seeds available for the Spider. Cancelling scan...");
            this.notifyListenersSpiderComplete(false);
            this.notifyListenersSpiderProgress(100, 0, 0);
            return;
        }
        if (this.scanUser != null) {
            log.info((Object)("Scan will be performed from the point of view of User: " + this.scanUser.getName()));
        }
        this.controller.init();
        this.stopped = false;
        this.paused = false;
        this.initialized = false;
        this.threadPool = Executors.newFixedThreadPool(this.spiderParam.getThreadCount());
        this.httpSender = new HttpSender(this.connectionParam, true, 3);
        this.httpSender.setFollowRedirect(false);
        for (URI uRI : this.seedList) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding seed for spider: " + uRI));
            }
            this.controller.addSeed(uRI, "GET");
        }
        this.initialized = true;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        log.info((Object)"Stopping spidering process by request.");
        if (this.paused) {
            this.resume();
        }
        this.threadPool.shutdownNow();
        try {
            if (!this.threadPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                log.warn((Object)"Failed to await for all spider threads to stop in the given time (2s)...");
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn((Object)"Interrupted while awaiting for all spider threads to stop...");
        }
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        this.threadPool = null;
        this.notifyListenersSpiderComplete(false);
    }

    private void complete() {
        log.info((Object)"Spidering process is complete. Shutting down...");
        this.stopped = true;
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Spider.this.threadPool != null) {
                    Spider.this.threadPool.shutdownNow();
                }
                Spider.this.notifyListenersSpiderComplete(true);
                Spider.this.controller.reset();
                Spider.this.threadPool = null;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pauseLock.lock();
        try {
            this.paused = false;
            this.pausedCondition.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    protected User getScanUser() {
        return this.scanUser;
    }

    protected void preTaskExecution() {
        this.checkPauseAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPauseAndWait() {
        this.pauseLock.lock();
        try {
            while (this.paused && !this.stopped) {
                this.pausedCondition.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    protected synchronized void postTaskExecution() {
        ++this.tasksDoneCount;
        int n = this.tasksDoneCount * 100 / this.tasksTotalCount;
        this.notifyListenersSpiderProgress(n, this.tasksDoneCount, this.tasksTotalCount - this.tasksDoneCount);
        if (this.tasksDoneCount == this.tasksTotalCount && this.initialized) {
            this.complete();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        this.listeners.add(spiderListener);
    }

    public void removeSpiderListener(SpiderListener spiderListener) {
        this.listeners.remove(spiderListener);
    }

    protected synchronized void notifyListenersSpiderProgress(int n, int n2, int n3) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.spiderProgress(n, n2, n3);
        }
    }

    protected synchronized void notifyListenersFoundURI(String string, String string2, FetchFilter.FetchStatus fetchStatus) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.foundURI(string, string2, fetchStatus);
        }
    }

    protected synchronized void notifyListenersReadURI(HttpMessage httpMessage) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.readURI(httpMessage);
        }
    }

    protected synchronized void notifyListenersSpiderComplete(boolean bl) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.spiderComplete(bl);
        }
    }

    public void addCustomParser(SpiderParser spiderParser) {
        this.controller.addSpiderParser(spiderParser);
    }
}

