/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Date;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.netbeans.beaninfo.editors.RectangleCustomEditor;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class RectangleEditor
extends ArrayOfIntSupport {
    private PropertyEnv env;

    public RectangleEditor() {
        super("java.awt.Rectangle", 4);
    }

    @Override
    int[] getValues() {
        Rectangle rectangle = (Rectangle)this.getValue();
        return new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
    }

    @Override
    void setValues(int[] nArray) {
        if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0 || nArray[3] < 0) {
            String string = NbBundle.getMessage(DimensionEditor.class, (String)"CTL_NegativeSize");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative value");
            UIExceptions.annotateUser(illegalArgumentException, illegalArgumentException.getMessage(), string, null, new Date());
            throw illegalArgumentException;
        }
        this.setValue(new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]));
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new RectangleCustomEditor(this, this.env);
    }

    @Override
    String getHintFormat() {
        return NbBundle.getMessage(RectangleEditor.class, (String)"CTL_HintFormatRE");
    }

    @Override
    protected String getXMLValueTag() {
        return "Rectangle";
    }

    @Override
    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }
}

