/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;

public class BaseJsonGenerator
extends JsonGeneratorDelegate {
    protected final GeneratorBase base;

    public BaseJsonGenerator(JsonGenerator generator, JsonGenerator base) {
        super(generator, true);
        this.base = base instanceof GeneratorBase ? (GeneratorBase)base : null;
    }

    public BaseJsonGenerator(JsonGenerator generator) {
        this(generator, generator);
    }

    protected void writeStartRaw(String fieldName) throws IOException {
        this.writeFieldName(fieldName);
        this.writeRaw(':');
    }

    public void writeEndRaw() {
        assert (this.base != null) : "JsonGenerator should be of instance GeneratorBase but was: " + this.delegate.getClass();
        if (this.base != null) {
            this.base.getOutputContext().writeValue();
        }
    }

    protected void writeRawValue(byte[] content, OutputStream bos) throws IOException {
        this.flush();
        bos.write(content);
    }

    protected void writeRawValue(byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.flush();
        bos.write(content, offset, length);
    }

    protected void writeRawValue(InputStream content, OutputStream bos) throws IOException {
        this.flush();
        Streams.copy(content, bos);
    }

    protected void writeRawValue(BytesReference content, OutputStream bos) throws IOException {
        this.flush();
        content.writeTo(bos);
    }
}

