/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import java.util.HashSet;
import java.util.Set;
import reactor.fn.Function;
import reactor.rx.action.Action;

public class DistinctAction<T, V>
extends Action<T, T> {
    private final Set<V> keySet = new HashSet<V>();
    private final Function<? super T, ? extends V> keySelector;

    public DistinctAction(Function<? super T, ? extends V> keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    protected void doNext(T currentData) {
        Object currentKey = this.keySelector != null ? this.keySelector.apply(currentData) : currentData;
        if (this.keySet.add(currentKey)) {
            this.broadcastNext(currentData);
        }
    }

    @Override
    protected void doComplete() {
        super.doComplete();
        this.keySet.clear();
    }
}

