/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableCharSetFactory;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableCharEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;

public class ImmutableCharSetFactoryImpl
implements ImmutableCharSetFactory {
    public ImmutableCharSet of() {
        return this.with();
    }

    public ImmutableCharSet with() {
        return ImmutableCharEmptySet.INSTANCE;
    }

    public ImmutableCharSet of(char one) {
        return this.with(one);
    }

    public ImmutableCharSet with(char one) {
        return new ImmutableCharSingletonSet(one);
    }

    public ImmutableCharSet of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharSet with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return CharHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableCharSet ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharSet withAll(CharIterable items) {
        if (items instanceof ImmutableCharSet) {
            return (ImmutableCharSet)items;
        }
        return this.with(items.toArray());
    }
}

