/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharSingletonSet
implements ImmutableCharSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char element;

    ImmutableCharSingletonSet(char element) {
        this.element = element;
    }

    public ImmutableCharSet newWith(char element) {
        return CharSets.immutable.with(new char[]{this.element, element});
    }

    public ImmutableCharSet newWithout(char element) {
        return this.element == element ? CharSets.immutable.with() : this;
    }

    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return elements.contains(this.element) ? CharSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(char value) {
        return this.element == value;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(CharProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableCharSet select(CharPredicate predicate) {
        return predicate.accept(this.element) ? CharHashSet.newSetWith(this.element).toImmutable() : new CharHashSet().toImmutable();
    }

    public ImmutableCharSet reject(CharPredicate predicate) {
        return predicate.accept(this.element) ? new CharHashSet().toImmutable() : CharHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(char item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(CharIntProcedure charIntProcedure) {
        charIntProcedure.value(this.element, 1);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public char min() {
        return this.element;
    }

    public char max() {
        return this.element;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.element;
    }

    public char minIfEmpty(char defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public char[] toSortedArray() {
        return new char[]{this.element};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet set = (CharSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element ^ '\u0001';
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.element);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.element);
    }

    public CharSet freeze() {
        return this;
    }

    public ImmutableCharSet toImmutable() {
        return this;
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public char[] toArray() {
        return new char[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return CharHashSet.newSetWith(this.element).charIterator();
    }
}

