/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.FactoryBean;
import reactor.fn.Supplier;
import reactor.fn.timer.HashWheelTimer;
import reactor.fn.timer.Timer;

public class HashWheelTimerFactoryBean
implements FactoryBean<Timer> {
    private final Supplier<Timer> timers;

    public HashWheelTimerFactoryBean() {
        this(1, 50);
    }

    public HashWheelTimerFactoryBean(int numOfTimers, int resolution) {
        final Timer[] timers = new Timer[numOfTimers];
        for (int i = 0; i < numOfTimers; ++i) {
            timers[i] = new HashWheelTimer(resolution);
        }
        final AtomicInteger count = new AtomicInteger();
        final int len = timers.length;
        this.timers = new Supplier<Timer>(){

            public Timer get() {
                return timers[count.getAndIncrement() % len];
            }
        };
    }

    public Timer getObject() throws Exception {
        return (Timer)this.timers.get();
    }

    public Class<?> getObjectType() {
        return HashWheelTimer.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

