/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class FileBasedConfig
extends StoredConfig {
    private final File configFile;
    private final FS fs;
    private boolean utf8Bom;
    private volatile FileSnapshot snapshot;
    private volatile ObjectId hash;

    public FileBasedConfig(File cfgLocation, FS fs) {
        this(null, cfgLocation, fs);
    }

    public FileBasedConfig(Config base, File cfgLocation, FS fs) {
        super(base);
        this.configFile = cfgLocation;
        this.fs = fs;
        this.snapshot = FileSnapshot.DIRTY;
        this.hash = ObjectId.zeroId();
    }

    protected boolean notifyUponTransientChanges() {
        return false;
    }

    public final File getFile() {
        return this.configFile;
    }

    public void load() throws IOException, ConfigInvalidException {
        FileSnapshot oldSnapshot = this.snapshot;
        FileSnapshot newSnapshot = FileSnapshot.save(this.getFile());
        try {
            byte[] in = IO.readFully(this.getFile());
            ObjectId newHash = FileBasedConfig.hash(in);
            if (this.hash.equals(newHash)) {
                if (oldSnapshot.equals(newSnapshot)) {
                    oldSnapshot.setClean(newSnapshot);
                } else {
                    this.snapshot = newSnapshot;
                }
            } else {
                String decoded;
                if (in.length >= 3 && in[0] == -17 && in[1] == -69 && in[2] == -65) {
                    decoded = RawParseUtils.decode(RawParseUtils.UTF8_CHARSET, in, 3, in.length);
                    this.utf8Bom = true;
                } else {
                    decoded = RawParseUtils.decode(in);
                }
                this.fromText(decoded);
                this.snapshot = newSnapshot;
                this.hash = newHash;
            }
        }
        catch (FileNotFoundException noFile) {
            this.clear();
            this.snapshot = newSnapshot;
        }
        catch (IOException e) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()));
            e2.initCause(e);
            throw e2;
        }
        catch (ConfigInvalidException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        byte[] out;
        String text = this.toText();
        if (this.utf8Bom) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(239);
            bos.write(187);
            bos.write(191);
            bos.write(text.getBytes(RawParseUtils.UTF8_CHARSET.name()));
            out = bos.toByteArray();
        } else {
            out = Constants.encode(text);
        }
        LockFile lf = new LockFile(this.getFile(), this.fs);
        if (!lf.lock()) {
            throw new LockFailedException(this.getFile());
        }
        try {
            lf.setNeedSnapshot(true);
            lf.write(out);
            if (!lf.commit()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, this.getFile()));
            }
        }
        finally {
            lf.unlock();
        }
        this.snapshot = lf.getCommitSnapshot();
        this.hash = FileBasedConfig.hash(out);
        this.fireConfigChangedEvent();
    }

    public void clear() {
        this.hash = FileBasedConfig.hash(new byte[0]);
        super.clear();
    }

    private static ObjectId hash(byte[] rawText) {
        return ObjectId.fromRaw(Constants.newMessageDigest().digest(rawText));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFile().getPath() + "]";
    }

    public boolean isOutdated() {
        return this.snapshot.isModified(this.getFile());
    }
}

