/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import reactor.bus.registry.CachableRegistration;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registry;
import reactor.bus.selector.Selector;
import reactor.fn.Consumer;
import reactor.jarjar.jsr166e.ConcurrentHashMapV8;

public class SimpleCachingRegistry<K, V>
implements Registry<K, V> {
    private final ConcurrentHashMapV8<Object, List<Registration<K, ? extends V>>> cache = new ConcurrentHashMapV8();
    private final ConcurrentHashMapV8<Selector<K>, List<Registration<K, ? extends V>>> registrations = new ConcurrentHashMapV8();
    private final boolean useCache;
    private final boolean cacheNotFound;
    private final Consumer<K> onNotFound;

    SimpleCachingRegistry(boolean useCache, boolean cacheNotFound, Consumer<K> onNotFound) {
        this.useCache = useCache;
        this.cacheNotFound = cacheNotFound;
        this.onNotFound = onNotFound;
    }

    @Override
    public synchronized Registration<K, V> register(final Selector<K> sel, V obj) {
        List<Registration<K, V>> regs = this.registrations.get(sel);
        if (null == regs) {
            regs = this.registrations.computeIfAbsent(sel, new ConcurrentHashMapV8.Fun<Selector<K>, List<Registration<K, ? extends V>>>(){

                @Override
                public List<Registration<K, ? extends V>> apply(Selector<K> selector) {
                    return new ArrayList();
                }
            });
        }
        CachableRegistration<K, V> reg = new CachableRegistration<K, V>(sel, obj, new Runnable(){

            @Override
            public void run() {
                SimpleCachingRegistry.this.registrations.remove(sel);
                SimpleCachingRegistry.this.cache.clear();
            }
        });
        regs.add(reg);
        return reg;
    }

    @Override
    public synchronized boolean unregister(Object key) {
        boolean found = false;
        for (Selector sel : this.registrations.keySet()) {
            if (!sel.matches(key) || null == this.registrations.remove(sel) || found) continue;
            found = true;
        }
        if (this.useCache) {
            this.cache.remove(key);
        }
        return found;
    }

    @Override
    public synchronized List<Registration<K, ? extends V>> select(final K key) {
        List<Registration<K, ? extends V>> selectedRegs = this.cache.get(key);
        if (null != selectedRegs) {
            return selectedRegs;
        }
        final ArrayList<Registration<K, V>> regs = new ArrayList<Registration<K, V>>();
        this.registrations.forEach(new ConcurrentHashMapV8.BiAction<Selector<K>, List<Registration<K, ? extends V>>>(){

            @Override
            public void apply(Selector<K> selector, List<Registration<K, ? extends V>> registrations) {
                if (selector.matches(key)) {
                    regs.addAll(registrations);
                }
            }
        });
        if (regs.isEmpty() && null != this.onNotFound) {
            this.onNotFound.accept(key);
        }
        if (this.useCache && (!regs.isEmpty() || this.cacheNotFound)) {
            this.cache.put(key, regs);
        }
        return regs;
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
        this.registrations.clear();
    }

    @Override
    public synchronized Iterator<Registration<K, ? extends V>> iterator() {
        final ArrayList regs = new ArrayList();
        this.registrations.forEach(new ConcurrentHashMapV8.BiAction<Selector<K>, List<Registration<K, ? extends V>>>(){

            @Override
            public void apply(Selector<K> selector, List<Registration<K, ? extends V>> registrations) {
                regs.addAll(registrations);
            }
        });
        return regs.iterator();
    }
}

