#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.8
id: QuickCheck-2.8-1464ac7aca6b6cf721d39a9b832739fa
key: Quick_K5h1L6oCnZB4IGwEj7AnA7
license: BSD3
copyright: 2000-2015 Koen Claessen, 2006-2008 Björn Bringert, 2009-2015 Nick Smallbone
maintainer: QuickCheck developers <quickcheck@projects.haskell.org>
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    .
    The programmer provides a specification of the program, in
    the form of properties which functions should satisfy, and
    QuickCheck then tests that the properties hold in a large number
    of randomly generated cases.
    .
    Specifications are expressed in
    Haskell, using combinators defined in the QuickCheck library.
    QuickCheck provides combinators to define properties, observe
    the distribution of test data, and define test
    data generators.
    .
    You can find a (slightly out-of-date but useful) manual at
    <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html>.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
exposed-modules:
    Test.QuickCheck Test.QuickCheck.Arbitrary Test.QuickCheck.Gen
    Test.QuickCheck.Gen.Unsafe Test.QuickCheck.Monadic
    Test.QuickCheck.Modifiers Test.QuickCheck.Property
    Test.QuickCheck.Test Test.QuickCheck.Text Test.QuickCheck.Poly
    Test.QuickCheck.State Test.QuickCheck.Random
    Test.QuickCheck.Exception Test.QuickCheck.Function
    Test.QuickCheck.All
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/QuickCheck-2.8
library-dirs: /usr/lib/ghc-7.10.3/site-local/QuickCheck-2.8
data-dir: /usr/share/arm-linux-ghc-7.10.3/QuickCheck-2.8
hs-libraries: HSQuickCheck-2.8-K5h1L6oCnZB4IGwEj7AnA7
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    random-1.1-41a0a7ecd483c665a5c3a093a5be2968
    template-haskell-2.10.0.0-4b92ab565139fd81021b60a162b59eb8
    tf-random-0.5-698e2f5f2baeeae513cc3e18238252c2
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
