#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.4.4
id: scientific-0.3.4.4-2c552cd0c6d8817341c76144fa370151
key: scien_7y55vL1gXthCbvqSa4DGw2
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
exposed-modules:
    Data.Scientific Data.Text.Lazy.Builder.Scientific
    Data.ByteString.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
                GHC.Integer.Logarithms.Compat GHC.Integer.Compat Utils
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/scientific-0.3.4.4
library-dirs: /usr/lib/ghc-7.10.3/site-local/scientific-0.3.4.4
data-dir: /usr/share/arm-linux-ghc-7.10.3/scientific-0.3.4.4
hs-libraries: HSscientific-0.3.4.4-7y55vL1gXthCbvqSa4DGw2
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    hashable-1.2.4.0-44b2533f61c94bc76cb2b27e15566721
    integer-gmp-1.0.0.0-4ff98693d6e5d6065e60052264067c09
    text-1.2.1.3-6c3c87c392cdf2c29fca1c10bbf7250b
    vector-0.11.0.0-c9b9eff80d809aeb097685ce86af03c4
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
