#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: uniplate
version: 1.6.12
id: uniplate-1.6.12-3fe4180eb6951540af7dfee4a95fb6f6
key: unipl_J4qLkI6Co41DsemfAv4sT2
license: BSD3
copyright: Neil Mitchell 2006-2013
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://community.haskell.org/~ndm/uniplate/
synopsis: Help writing simple, concise and fast generic operations.
description:
    Uniplate is library for writing simple and concise generic operations.
    Uniplate has similar goals to the original Scrap Your Boilerplate work,
    but is substantially simpler and faster. The Uniplate manual is available at
    <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
    .
    To get started with Uniplate you should import one of the three following
    modules:
    .
    * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
    Most users should start by importing this module.
    .
    * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
    with substantially higher performance (around 5 times), but requires writing
    instance declarations.
    .
    * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
    by Uniplate. Both the above two modules re-export this module.
    .
    In addition, some users may want to make use of the following modules:
    .
    * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
    .
    * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
    .
    * "Data.Generics.Compos" - users transitioning from the Compos library.
    .
    * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
    to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
exposed-modules:
    Data.Generics.Str Data.Generics.Compos Data.Generics.SYB
    Data.Generics.Uniplate.Data Data.Generics.Uniplate.Data.Instances
    Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
    Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
    Data.Generics.Uniplate.Zipper Data.Generics.Uniplate
    Data.Generics.UniplateOn Data.Generics.UniplateStr
    Data.Generics.UniplateStrOn Data.Generics.Biplate
    Data.Generics.PlateDirect Data.Generics.PlateTypeable
    Data.Generics.PlateData
hidden-modules: Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/uniplate-1.6.12
library-dirs: /usr/lib/ghc-7.10.3/site-local/uniplate-1.6.12
data-dir: /usr/share/arm-linux-ghc-7.10.3/uniplate-1.6.12
hs-libraries: HSuniplate-1.6.12-J4qLkI6Co41DsemfAv4sT2
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    hashable-1.2.4.0-44b2533f61c94bc76cb2b27e15566721
    syb-0.6-56a5944f55f7a9d47e7b770375c0e1ae
    unordered-containers-0.2.6.0-08e36bb27daebf8e082345cc5a0772e7
haddock-interfaces: /usr/share/doc/haskell-uniplate/html/uniplate.haddock
haddock-html: /usr/share/doc/haskell-uniplate/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
