#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-binary-instances
version: 0.2.1.0
id: vector-binary-instances-0.2.1.0-cf5fe0ee79ba6339d5301fad89360f13
key: vecto_5PgNuRmYF9D7JNqEUt46iU
license: BSD3
maintainer: dons00@gmail.com, bos@serpentine.com
stability: Experimental
homepage: https://github.com/bos/vector-binary-instances
synopsis: Instances of Data.Binary and Data.Serialize for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
category: Data
author: Don Stewart
exposed: True
exposed-modules:
    Data.Vector.Binary Data.Vector.Cereal
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/vector-binary-instances-0.2.1.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/vector-binary-instances-0.2.1.0
data-dir: /usr/share/arm-linux-ghc-7.10.3/vector-binary-instances-0.2.1.0
hs-libraries: HSvector-binary-instances-0.2.1.0-5PgNuRmYF9D7JNqEUt46iU
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    cereal-0.5.1.0-2c7be146776a4abf674d1ac9e0ccfc13
    vector-0.11.0.0-c9b9eff80d809aeb097685ce86af03c4
haddock-interfaces: /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock
haddock-html: /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
