/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.batik.anim.AnimationEngine;
import org.apache.batik.anim.AnimationException;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableAngleOrIdentValue;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableBooleanValue;
import org.apache.batik.anim.values.AnimatableColorValue;
import org.apache.batik.anim.values.AnimatableIntegerValue;
import org.apache.batik.anim.values.AnimatableLengthListValue;
import org.apache.batik.anim.values.AnimatableLengthOrIdentValue;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableNumberListValue;
import org.apache.batik.anim.values.AnimatableNumberOrIdentValue;
import org.apache.batik.anim.values.AnimatableNumberOrPercentageValue;
import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatablePaintValue;
import org.apache.batik.anim.values.AnimatablePathDataValue;
import org.apache.batik.anim.values.AnimatablePointListValue;
import org.apache.batik.anim.values.AnimatablePreserveAspectRatioValue;
import org.apache.batik.anim.values.AnimatableRectValue;
import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.AnimationSupport;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.FloatArrayProducer;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthListParser;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathArrayProducer;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.EventTarget;

public class SVGAnimationEngine
extends AnimationEngine {
    protected BridgeContext ctx;
    protected CSSEngine cssEngine;
    protected boolean started;
    protected AnimationTickRunnable animationTickRunnable;
    protected float initialStartTime;
    protected UncomputedAnimatableStringValueFactory uncomputedAnimatableStringValueFactory = new UncomputedAnimatableStringValueFactory();
    protected AnimatableLengthOrIdentFactory animatableLengthOrIdentFactory = new AnimatableLengthOrIdentFactory();
    protected AnimatableNumberOrIdentFactory animatableNumberOrIdentFactory = new AnimatableNumberOrIdentFactory(false);
    protected Factory[] factories = new Factory[]{null, new AnimatableIntegerValueFactory(), new AnimatableNumberValueFactory(), new AnimatableLengthValueFactory(), null, new AnimatableAngleValueFactory(), new AnimatableColorValueFactory(), new AnimatablePaintValueFactory(), null, null, this.uncomputedAnimatableStringValueFactory, null, null, new AnimatableNumberListValueFactory(), new AnimatableLengthListValueFactory(), this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.animatableLengthOrIdentFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, new AnimatablePathDataFactory(), this.uncomputedAnimatableStringValueFactory, null, this.animatableNumberOrIdentFactory, this.uncomputedAnimatableStringValueFactory, null, new AnimatableNumberOrIdentFactory(true), new AnimatableAngleOrIdentFactory(), null, new AnimatablePointListValueFactory(), new AnimatablePreserveAspectRatioValueFactory(), null, this.uncomputedAnimatableStringValueFactory, null, null, null, null, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableNumberOrIdentFactory, null, null, new AnimatableNumberOrPercentageValueFactory(), null, new AnimatableBooleanValueFactory(), new AnimatableRectValueFactory()};
    protected boolean isSVG12;
    protected LinkedList initialBridges = new LinkedList();
    protected StyleMap dummyStyleMap;
    protected AnimationThread animationThread;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected static final Set animationEventNames11;
    protected static final Set animationEventNames12;

    public SVGAnimationEngine(Document document, BridgeContext bridgeContext) {
        super(document);
        this.ctx = bridgeContext;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        this.cssEngine = sVGOMDocument.getCSSEngine();
        this.dummyStyleMap = new StyleMap(this.cssEngine.getNumberOfProperties());
        this.isSVG12 = sVGOMDocument.isSVG12();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SVGAnimationEngine sVGAnimationEngine = this;
        synchronized (sVGAnimationEngine) {
            this.pause();
            super.dispose();
        }
    }

    public void addInitialBridge(SVGAnimationElementBridge sVGAnimationElementBridge) {
        if (this.initialBridges != null) {
            this.initialBridges.add(sVGAnimationElementBridge);
        }
    }

    public boolean hasStarted() {
        return this.started;
    }

    public AnimatableValue parseAnimatableValue(Element element, AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
        SVGOMElement sVGOMElement = (SVGOMElement)animationTarget.getElement();
        int n = bl ? sVGOMElement.getPropertyType(string2) : sVGOMElement.getAttributeType(string, string2);
        Factory factory = this.factories[n];
        if (factory == null) {
            String string4 = string == null ? string2 : '{' + string + '}' + string2;
            throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string4});
        }
        return this.factories[n].createValue(animationTarget, string, string2, bl, string3);
    }

    public AnimatableValue getUnderlyingCSSValue(Element element, AnimationTarget animationTarget, String string) {
        ValueManager[] valueManagerArray = this.cssEngine.getValueManagers();
        int n = this.cssEngine.getPropertyIndex(string);
        if (n != -1) {
            int n2 = valueManagerArray[n].getPropertyType();
            Factory factory = this.factories[n2];
            if (factory == null) {
                throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string});
            }
            SVGStylableElement sVGStylableElement = (SVGStylableElement)animationTarget.getElement();
            CSSStyleDeclaration cSSStyleDeclaration = sVGStylableElement.getOverrideStyle();
            String string2 = cSSStyleDeclaration.getPropertyValue(string);
            if (string2 != null) {
                cSSStyleDeclaration.removeProperty(string);
            }
            Value value = this.cssEngine.getComputedStyle(sVGStylableElement, null, n);
            if (string2 != null && !string2.equals("")) {
                cSSStyleDeclaration.setProperty(string, string2, null);
            }
            return this.factories[n2].createValue(animationTarget, string, value);
        }
        return null;
    }

    @Override
    public void pause() {
        super.pause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable(null);
        }
    }

    @Override
    public void unpause() {
        super.unpause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable(this.animationTickRunnable);
        }
    }

    @Override
    public float getCurrentTime() {
        boolean bl = this.pauseTime != 0L;
        this.unpause();
        float f = this.timedDocumentRoot.getCurrentTime();
        if (bl) {
            this.pause();
        }
        return Float.isNaN(f) ? 0.0f : f;
    }

    @Override
    public float setCurrentTime(float f) {
        if (this.started) {
            float f2 = super.setCurrentTime(f);
            if (this.animationTickRunnable != null) {
                this.animationTickRunnable.resume();
            }
            return f2;
        }
        this.initialStartTime = f;
        return 0.0f;
    }

    @Override
    protected TimedDocumentRoot createDocumentRoot() {
        return new AnimationRoot();
    }

    public void start(long l) {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            try {
                Object object;
                int n;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(l));
                this.timedDocumentRoot.resetDocument(calendar);
                Object[] objectArray = this.initialBridges.toArray();
                this.initialBridges = null;
                for (n = 0; n < objectArray.length; ++n) {
                    object = (SVGAnimationElementBridge)objectArray[n];
                    ((SVGAnimationElementBridge)object).initializeAnimation();
                }
                for (n = 0; n < objectArray.length; ++n) {
                    object = (SVGAnimationElementBridge)objectArray[n];
                    ((SVGAnimationElementBridge)object).initializeTimedElement();
                }
                UpdateManager updateManager = this.ctx.getUpdateManager();
                if (updateManager != null) {
                    object = updateManager.getUpdateRunnableQueue();
                    this.animationTickRunnable = new AnimationTickRunnable((RunnableQueue)object, this);
                    ((RunnableQueue)object).setIdleRunnable(this.animationTickRunnable);
                    if (this.initialStartTime != 0.0f) {
                        this.setCurrentTime(this.initialStartTime);
                    }
                }
            }
            catch (AnimationException animationException) {
                throw new BridgeException(this.ctx, animationException.getElement().getElement(), animationException.getMessage());
            }
        }
        catch (Exception exception) {
            if (this.ctx.getUserAgent() == null) {
                exception.printStackTrace();
            }
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
    }

    public void setAnimationLimitingCPU(float f) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f;
    }

    public void setAnimationLimitingFPS(float f) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f;
    }

    static {
        int n;
        animationEventNames11 = new HashSet();
        animationEventNames12 = new HashSet();
        String[] stringArray = new String[]{"click", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "beginEvent", "endEvent"};
        String[] stringArray2 = new String[]{"DOMSubtreeModified", "DOMNodeInserted", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMNodeInsertedIntoDocument", "DOMAttrModified", "DOMCharacterDataModified", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "repeatEvent"};
        String[] stringArray3 = new String[]{"load", "resize", "scroll", "zoom"};
        for (n = 0; n < stringArray.length; ++n) {
            animationEventNames11.add(stringArray[n]);
            animationEventNames12.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            animationEventNames11.add(stringArray2[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            animationEventNames12.add(stringArray3[n]);
        }
    }

    protected class AnimatableStringValueFactory
    extends CSSValueFactory {
        protected AnimatableStringValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }

    protected class AnimatablePaintValueFactory
    extends CSSValueFactory {
        protected AnimatablePaintValueFactory() {
        }

        protected AnimatablePaintValue createColorPaintValue(AnimationTarget animationTarget, Color color) {
            return AnimatablePaintValue.createColorPaintValue(animationTarget, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value.getCssValueType() == 1) {
                switch (value.getPrimitiveType()) {
                    case 21: {
                        return AnimatablePaintValue.createNonePaintValue(animationTarget);
                    }
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        return AnimatablePaintValue.createURIPaintValue(animationTarget, value.getStringValue());
                    }
                }
            } else {
                Value value2 = value.item(0);
                switch (value2.getPrimitiveType()) {
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        Value value3 = value.item(1);
                        switch (value3.getPrimitiveType()) {
                            case 21: {
                                return AnimatablePaintValue.createURINonePaintValue(animationTarget, value2.getStringValue());
                            }
                            case 25: {
                                Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value.item(1), 1.0f, SVGAnimationEngine.this.ctx);
                                return this.createColorPaintValue(animationTarget, (Color)paint);
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    protected class AnimatableColorValueFactory
    extends CSSValueFactory {
        protected AnimatableColorValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
            if (paint instanceof Color) {
                Color color = (Color)paint;
                return new AnimatableColorValue(animationTarget, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
            return null;
        }
    }

    protected class AnimatableAngleOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableAngleOrIdentFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s;
            if (value instanceof StringValue) {
                return new AnimatableAngleOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s = 2;
                    break;
                }
                case 12: {
                    s = 3;
                    break;
                }
                case 13: {
                    s = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleOrIdentValue(animationTarget, floatValue.getFloatValue(), s);
        }
    }

    protected class AnimatableAngleValueFactory
    extends CSSValueFactory {
        protected AnimatableAngleValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s;
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s = 2;
                    break;
                }
                case 12: {
                    s = 3;
                    break;
                }
                case 13: {
                    s = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleValue(animationTarget, floatValue.getFloatValue(), s);
        }
    }

    protected class AnimatableNumberOrIdentFactory
    extends CSSValueFactory {
        protected boolean numericIdents;

        public AnimatableNumberOrIdentFactory(boolean bl) {
            this.numericIdents = bl;
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableNumberOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableNumberOrIdentValue(animationTarget, floatValue.getFloatValue(), this.numericIdents);
        }
    }

    protected class AnimatableLengthOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableLengthOrIdentFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableLengthOrIdentValue(animationTarget, value.getStringValue());
            }
            short s = animationTarget.getPercentageInterpretation(null, string, true);
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableLengthOrIdentValue(animationTarget, floatValue.getPrimitiveType(), floatValue.getFloatValue(), s);
        }
    }

    protected class UncomputedAnimatableStringValueFactory
    implements Factory {
        protected UncomputedAnimatableStringValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableStringValue(animationTarget, string3);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }

    protected class AnimatablePathDataFactory
    implements Factory {
        protected PathParser parser = new PathParser();
        protected PathArrayProducer producer = new PathArrayProducer();

        public AnimatablePathDataFactory() {
            this.parser.setPathHandler(this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePathDataValue(animationTarget, this.producer.getPathCommands(), this.producer.getPathParameters());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatablePointListValueFactory
    implements Factory {
        protected PointsParser parser = new PointsParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatablePointListValueFactory() {
            this.parser.setPointsHandler(this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePointListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableRectValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableRectValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                float[] fArray = this.producer.getFloatArray();
                if (fArray.length != 4) {
                    return null;
                }
                return new AnimatableRectValue(animationTarget, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableNumberListValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableNumberListValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatableNumberListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableLengthListValueFactory
    implements Factory {
        protected LengthListParser parser = new LengthListParser();
        protected LengthArrayProducer producer = new LengthArrayProducer();

        public AnimatableLengthListValueFactory() {
            this.parser.setLengthListHandler(this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                short s = animationTarget.getPercentageInterpretation(string, string2, bl);
                this.parser.parse(string3);
                return new AnimatableLengthListValue(animationTarget, this.producer.getLengthTypeArray(), this.producer.getLengthValueArray(), s);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableLengthValueFactory
    implements Factory {
        protected short type;
        protected float value;
        protected LengthParser parser = new LengthParser();
        protected LengthHandler handler = new DefaultLengthHandler(){

            @Override
            public void startLength() throws ParseException {
                AnimatableLengthValueFactory.this.type = 1;
            }

            @Override
            public void lengthValue(float f) throws ParseException {
                AnimatableLengthValueFactory.this.value = f;
            }

            @Override
            public void em() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)3;
            }

            @Override
            public void ex() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)4;
            }

            @Override
            public void in() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)8;
            }

            @Override
            public void cm() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)6;
            }

            @Override
            public void mm() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)7;
            }

            @Override
            public void pc() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)10;
            }

            @Override
            public void pt() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)9;
            }

            @Override
            public void px() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)5;
            }

            @Override
            public void percentage() throws ParseException {
                AnimatableLengthValueFactory.this.type = (short)2;
            }

            @Override
            public void endLength() throws ParseException {
            }
        };

        public AnimatableLengthValueFactory() {
            this.parser.setLengthHandler(this.handler);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            short s = animationTarget.getPercentageInterpretation(string, string2, bl);
            try {
                this.parser.parse(string3);
                return new AnimatableLengthValue(animationTarget, this.type, this.value, s);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected class AnimatablePreserveAspectRatioValueFactory
    implements Factory {
        protected short align;
        protected short meetOrSlice;
        protected PreserveAspectRatioParser parser = new PreserveAspectRatioParser();
        protected DefaultPreserveAspectRatioHandler handler = new DefaultPreserveAspectRatioHandler(){

            @Override
            public void startPreserveAspectRatio() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = 0;
                AnimatablePreserveAspectRatioValueFactory.this.meetOrSlice = 0;
            }

            @Override
            public void none() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = 1;
            }

            @Override
            public void xMaxYMax() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)10;
            }

            @Override
            public void xMaxYMid() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)7;
            }

            @Override
            public void xMaxYMin() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)4;
            }

            @Override
            public void xMidYMax() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)9;
            }

            @Override
            public void xMidYMid() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)6;
            }

            @Override
            public void xMidYMin() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)3;
            }

            @Override
            public void xMinYMax() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)8;
            }

            @Override
            public void xMinYMid() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)5;
            }

            @Override
            public void xMinYMin() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.align = (short)2;
            }

            @Override
            public void meet() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.meetOrSlice = 1;
            }

            @Override
            public void slice() throws ParseException {
                AnimatablePreserveAspectRatioValueFactory.this.meetOrSlice = (short)2;
            }
        };

        public AnimatablePreserveAspectRatioValueFactory() {
            this.parser.setPreserveAspectRatioHandler(this.handler);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePreserveAspectRatioValue(animationTarget, this.align, this.meetOrSlice);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableNumberOrPercentageValueFactory
    implements Factory {
        protected AnimatableNumberOrPercentageValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            boolean bl2;
            float f;
            if (string3.charAt(string3.length() - 1) == '%') {
                f = Float.parseFloat(string3.substring(0, string3.length() - 1));
                bl2 = true;
            } else {
                f = Float.parseFloat(string3);
                bl2 = false;
            }
            return new AnimatableNumberOrPercentageValue(animationTarget, f, bl2);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            switch (value.getPrimitiveType()) {
                case 2: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue(), true);
                }
                case 1: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue());
                }
            }
            return null;
        }
    }

    protected class AnimatableNumberValueFactory
    implements Factory {
        protected AnimatableNumberValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableNumberValue(animationTarget, Float.parseFloat(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableNumberValue(animationTarget, value.getFloatValue());
        }
    }

    protected class AnimatableIntegerValueFactory
    implements Factory {
        protected AnimatableIntegerValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableIntegerValue(animationTarget, Integer.parseInt(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected class AnimatableBooleanValueFactory
    implements Factory {
        protected AnimatableBooleanValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(value.getCssText()));
        }
    }

    protected abstract class CSSValueFactory
    implements Factory {
        protected CSSValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return this.createValue(animationTarget, string2, this.createCSSValue(animationTarget, string2, string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            value = this.computeValue(cSSStylableElement, string, value);
            return this.createAnimatableValue(animationTarget, string, value);
        }

        protected abstract AnimatableValue createAnimatableValue(AnimationTarget var1, String var2, Value var3);

        protected Value createCSSValue(AnimationTarget animationTarget, String string, String string2) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            Value value = SVGAnimationEngine.this.cssEngine.parsePropertyValue(cSSStylableElement, string, string2);
            return this.computeValue(cSSStylableElement, string, value);
        }

        protected Value computeValue(CSSStylableElement cSSStylableElement, String string, Value value) {
            ValueManager[] valueManagerArray = SVGAnimationEngine.this.cssEngine.getValueManagers();
            int n = SVGAnimationEngine.this.cssEngine.getPropertyIndex(string);
            if (n != -1) {
                if (value.getCssValueType() == 0) {
                    if ((cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement)) != null) {
                        return SVGAnimationEngine.this.cssEngine.getComputedStyle(cSSStylableElement, null, n);
                    }
                    return valueManagerArray[n].getDefaultValue();
                }
                value = valueManagerArray[n].computeValue(cSSStylableElement, null, SVGAnimationEngine.this.cssEngine, n, SVGAnimationEngine.this.dummyStyleMap, value);
            }
            return value;
        }
    }

    protected static interface Factory {
        public AnimatableValue createValue(AnimationTarget var1, String var2, String var3, boolean var4, String var5);

        public AnimatableValue createValue(AnimationTarget var1, String var2, Value var3);
    }

    protected class AnimationThread
    extends Thread {
        protected Calendar time = Calendar.getInstance();
        protected RunnableQueue runnableQueue;
        protected Ticker ticker;

        protected AnimationThread() {
            this.runnableQueue = SVGAnimationEngine.this.ctx.getUpdateManager().getUpdateRunnableQueue();
            this.ticker = new Ticker();
        }

        @Override
        public void run() {
            while (true) {
                this.time.setTime(new Date());
                this.ticker.t = SVGAnimationEngine.this.timedDocumentRoot.convertWallclockTime(this.time);
                try {
                    this.runnableQueue.invokeAndWait(this.ticker);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        protected class Ticker
        implements Runnable {
            protected float t;

            protected Ticker() {
            }

            @Override
            public void run() {
                SVGAnimationEngine.this.tick(this.t, false);
            }
        }
    }

    protected static class AnimationTickRunnable
    implements RunnableQueue.IdleRunnable {
        protected Calendar time = Calendar.getInstance();
        protected long waitTime;
        protected RunnableQueue q;
        private static final int NUM_TIMES = 8;
        protected long[] times = new long[8];
        protected long sumTime;
        protected int timeIndex;
        protected WeakReference engRef;
        protected static final int MAX_EXCEPTION_COUNT = 10;
        protected int exceptionCount;

        public AnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            this.q = runnableQueue;
            this.engRef = new WeakReference<SVGAnimationEngine>(sVGAnimationEngine);
            Arrays.fill(this.times, 100L);
            this.sumTime = 800L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        @Override
        public long getWaitTime() {
            return this.waitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SVGAnimationEngine sVGAnimationEngine;
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine = this.getAnimationEngine();
            synchronized (sVGAnimationEngine2) {
                int n;
                block17: {
                    n = sVGAnimationEngine.animationLimitingMode;
                    float f = sVGAnimationEngine.animationLimitingAmount;
                    try {
                        try {
                            long l = System.currentTimeMillis();
                            this.time.setTime(new Date(l));
                            float f2 = sVGAnimationEngine.timedDocumentRoot.convertWallclockTime(this.time);
                            float f3 = sVGAnimationEngine.tick(f2, false);
                            long l2 = System.currentTimeMillis();
                            long l3 = l2 - l;
                            if (l3 == 0L) {
                                l3 = 1L;
                            }
                            this.sumTime -= this.times[this.timeIndex];
                            this.sumTime += l3;
                            this.times[this.timeIndex] = l3;
                            this.timeIndex = (this.timeIndex + 1) % 8;
                            if (f3 == Float.POSITIVE_INFINITY) {
                                this.waitTime = Long.MAX_VALUE;
                            } else {
                                this.waitTime = l + (long)(f3 * 1000.0f) - 1000L;
                                if (this.waitTime < l2) {
                                    this.waitTime = l2;
                                }
                                if (n != 0) {
                                    float f4 = (float)this.sumTime / 8.0f;
                                    float f5 = n == 1 ? f4 / f - f4 : 1000.0f / f - f4;
                                    long l4 = l2 + (long)f5;
                                    if (l4 > this.waitTime) {
                                        this.waitTime = l4;
                                    }
                                }
                            }
                        }
                        catch (AnimationException animationException) {
                            throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                        }
                        this.exceptionCount = 0;
                    }
                    catch (Exception exception) {
                        if (++this.exceptionCount >= 10) break block17;
                        if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                            exception.printStackTrace();
                        }
                        sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                    }
                }
                if (n == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        protected SVGAnimationEngine getAnimationEngine() {
            return (SVGAnimationEngine)this.engRef.get();
        }
    }

    protected static class DebugAnimationTickRunnable
    extends AnimationTickRunnable {
        float t = 0.0f;

        public DebugAnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            super(runnableQueue, sVGAnimationEngine);
            this.waitTime = Long.MAX_VALUE;
            new Thread(){

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Enter times.");
                    while (true) {
                        String string;
                        try {
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            string = null;
                        }
                        if (string == null) {
                            System.exit(0);
                        }
                        DebugAnimationTickRunnable.this.t = Float.parseFloat(string);
                        DebugAnimationTickRunnable.this.resume();
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        @Override
        public long getWaitTime() {
            long l = this.waitTime;
            this.waitTime = Long.MAX_VALUE;
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SVGAnimationEngine sVGAnimationEngine;
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine = this.getAnimationEngine();
            synchronized (sVGAnimationEngine2) {
                try {
                    try {
                        sVGAnimationEngine.tick(this.t, false);
                    }
                    catch (AnimationException animationException) {
                        throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                    }
                }
                catch (Exception exception) {
                    if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                        exception.printStackTrace();
                    }
                    sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                }
            }
        }
    }

    protected class AnimationRoot
    extends TimedDocumentRoot {
        public AnimationRoot() {
            super(!SVGAnimationEngine.this.isSVG12, SVGAnimationEngine.this.isSVG12);
        }

        @Override
        protected String getEventNamespaceURI(String string) {
            if (!SVGAnimationEngine.this.isSVG12) {
                return null;
            }
            if (string.equals("focusin") || string.equals("focusout") || string.equals("activate") || animationEventNames12.contains(string)) {
                return "http://www.w3.org/2001/xml-events";
            }
            return null;
        }

        @Override
        protected String getEventType(String string) {
            if (string.equals("focusin")) {
                return "DOMFocusIn";
            }
            if (string.equals("focusout")) {
                return "DOMFocusOut";
            }
            if (string.equals("activate")) {
                return "DOMActivate";
            }
            if (SVGAnimationEngine.this.isSVG12 ? animationEventNames12.contains(string) : animationEventNames11.contains(string)) {
                return string;
            }
            return null;
        }

        @Override
        protected String getRepeatEventName() {
            return "repeatEvent";
        }

        @Override
        protected void fireTimeEvent(String string, Calendar calendar, int n) {
            AnimationSupport.fireTimeEvent((EventTarget)((Object)SVGAnimationEngine.this.document), string, calendar, n);
        }

        @Override
        protected void toActive(float f) {
        }

        @Override
        protected void toInactive(boolean bl, boolean bl2) {
        }

        @Override
        protected void removeFill() {
        }

        @Override
        protected void sampledAt(float f, float f2, int n) {
        }

        @Override
        protected void sampledLastValue(int n) {
        }

        @Override
        protected TimedElement getTimedElementById(String string) {
            return AnimationSupport.getTimedElementById(string, SVGAnimationEngine.this.document);
        }

        @Override
        protected EventTarget getEventTargetById(String string) {
            return AnimationSupport.getEventTargetById(string, SVGAnimationEngine.this.document);
        }

        @Override
        protected EventTarget getAnimationEventTarget() {
            return null;
        }

        @Override
        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationEngine.this.document);
        }

        @Override
        public Element getElement() {
            return null;
        }

        @Override
        public boolean isBefore(TimedElement timedElement) {
            return false;
        }

        @Override
        protected void currentIntervalWillUpdate() {
            if (SVGAnimationEngine.this.animationTickRunnable != null) {
                SVGAnimationEngine.this.animationTickRunnable.resume();
            }
        }
    }
}

