/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TextUtilities
implements CSSConstants,
ErrorConstants {
    public static String getElementContent(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    stringBuffer.append(TextUtilities.getElementContent((Element)node));
                    continue block4;
                }
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static ArrayList svgHorizontalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Float(UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
        }
        return arrayList;
    }

    public static ArrayList svgVerticalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Float(UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
        }
        return arrayList;
    }

    public static ArrayList svgRotateArrayToFloats(Element element, String string, String string2, BridgeContext bridgeContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                arrayList.add(new Float(Math.toRadians(SVGUtilities.convertSVGNumber(string3))));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
            }
        }
        return arrayList;
    }

    public static Float convertFontSize(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 22);
        return new Float(value.getFloatValue());
    }

    public static Float convertFontStyle(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 25);
        switch (value.getStringValue().charAt(0)) {
            case 'n': {
                return TextAttribute.POSTURE_REGULAR;
            }
        }
        return TextAttribute.POSTURE_OBLIQUE;
    }

    public static Float convertFontStretch(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 24);
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'u': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_CONDENSED;
                }
                return TextAttribute.WIDTH_EXTENDED;
            }
            case 'e': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_CONDENSED;
                }
                if (string.length() == 8) {
                    return TextAttribute.WIDTH_SEMI_EXTENDED;
                }
                return TextAttribute.WIDTH_EXTENDED;
            }
            case 's': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_SEMI_CONDENSED;
                }
                return TextAttribute.WIDTH_SEMI_EXTENDED;
            }
        }
        return TextAttribute.WIDTH_REGULAR;
    }

    public static Float convertFontWeight(Element element) {
        float f;
        Value value = CSSUtilities.getComputedStyle(element, 27);
        int n = (int)value.getFloatValue();
        switch (n) {
            case 100: {
                return TextAttribute.WEIGHT_EXTRA_LIGHT;
            }
            case 200: {
                return TextAttribute.WEIGHT_LIGHT;
            }
            case 300: {
                return TextAttribute.WEIGHT_DEMILIGHT;
            }
            case 400: {
                return TextAttribute.WEIGHT_REGULAR;
            }
            case 500: {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
        }
        String string = System.getProperty("java.specification.version");
        float f2 = f = string != null ? Float.parseFloat(string) : 1.5f;
        if ((double)f < 1.5) {
            return TextAttribute.WEIGHT_BOLD;
        }
        switch (n) {
            case 600: {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            case 700: {
                return TextAttribute.WEIGHT_BOLD;
            }
            case 800: {
                return TextAttribute.WEIGHT_HEAVY;
            }
            case 900: {
                return TextAttribute.WEIGHT_ULTRABOLD;
            }
        }
        return TextAttribute.WEIGHT_REGULAR;
    }

    public static TextNode.Anchor convertTextAnchor(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 53);
        switch (value.getStringValue().charAt(0)) {
            case 's': {
                return TextNode.Anchor.START;
            }
            case 'm': {
                return TextNode.Anchor.MIDDLE;
            }
        }
        return TextNode.Anchor.END;
    }

    public static Object convertBaselineShift(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 1);
        if (value.getPrimitiveType() == 21) {
            String string = value.getStringValue();
            switch (string.charAt(2)) {
                case 'p': {
                    return TextAttribute.SUPERSCRIPT_SUPER;
                }
                case 'b': {
                    return TextAttribute.SUPERSCRIPT_SUB;
                }
            }
            return null;
        }
        return new Float(value.getFloatValue());
    }

    public static Float convertKerning(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 31);
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        return new Float(value.getFloatValue());
    }

    public static Float convertLetterSpacing(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 32);
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        return new Float(value.getFloatValue());
    }

    public static Float convertWordSpacing(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 58);
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        return new Float(value.getFloatValue());
    }
}

