/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.RegistersListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.datatransfer.JEditDataFlavor;
import org.gjt.sp.jedit.datatransfer.JEditRichText;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static boolean loaded;
    private static boolean loading;
    private static RegisterSaver saver;
    private static RegistersListener listener;
    private static boolean modified;

    public static void copy(TextArea textArea, char c) {
        String string = textArea.getSelectedText();
        if (string == null) {
            return;
        }
        Transferable transferable = TransferHandler.getInstance().getTransferable(textArea, string);
        Registers.setRegister(c, transferable);
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public static void cut(TextArea textArea, char c) {
        if (textArea.isEditable()) {
            String string = textArea.getSelectedText();
            if (string == null) {
                return;
            }
            Transferable transferable = TransferHandler.getInstance().getTransferable(textArea, string);
            Registers.setRegister(c, transferable);
            HistoryModel.getModel("clipboard").addItem(string);
            textArea.setSelectedText("");
        } else {
            textArea.getToolkit().beep();
        }
    }

    public static void append(TextArea textArea, char c) {
        Registers.append(textArea, c, "\n", false);
    }

    public static void append(TextArea textArea, char c, String string) {
        Registers.append(textArea, c, string, false);
    }

    public static void append(TextArea textArea, char c, String string, boolean bl) {
        Transferable transferable;
        if (bl && !textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        String string2 = textArea.getSelectedText();
        if (string2 == null) {
            return;
        }
        Register register = Registers.getRegister(c);
        if (register != null && (transferable = register.getTransferable()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string3 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (string3 != null) {
                    string2 = string3.endsWith(string) ? string3 + string2 : string3 + string + string2;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                Log.log(9, Registers.class, iOException);
            }
        }
        transferable = TransferHandler.getInstance().getTransferable(textArea, string2);
        Registers.setRegister(c, transferable);
        HistoryModel.getModel("clipboard").addItem(string2);
        if (bl) {
            textArea.setSelectedText("");
        }
    }

    public static void paste(TextArea textArea, char c) {
        Registers.paste(textArea, c, false);
    }

    public static void paste(TextArea textArea, char c, DataFlavor dataFlavor) {
        Registers.paste(textArea, c, false, dataFlavor);
    }

    public static void paste(TextArea textArea, char c, boolean bl) {
        Object object;
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register register = Registers.getRegister(c);
        if (register == null) {
            textArea.getToolkit().beep();
            return;
        }
        Transferable transferable = register.getTransferable();
        Mode mode = null;
        String string = null;
        if (transferable.isDataFlavorSupported(JEditDataFlavor.jEditRichTextDataFlavor)) {
            try {
                object = (JEditRichText)transferable.getTransferData(JEditDataFlavor.jEditRichTextDataFlavor);
                mode = ((JEditRichText)object).getMode();
                string = ((JEditRichText)object).getText();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Log.log(9, Registers.class, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Log.log(9, Registers.class, iOException);
            }
        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            string = Registers.getTextFromTransferable(transferable, DataFlavor.stringFlavor);
        }
        if (string == null) {
            textArea.getToolkit().beep();
            return;
        }
        object = textArea.getBuffer();
        Registers.applyMode(mode, (JEditBuffer)object);
        Registers._paste(textArea, bl, string, (JEditBuffer)object);
    }

    public static void paste(TextArea textArea, char c, boolean bl, DataFlavor dataFlavor) {
        if (JEditDataFlavor.jEditRichTextDataFlavor.equals(dataFlavor)) {
            Registers.paste(textArea, c, bl);
            return;
        }
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register register = Registers.getRegister(c);
        if (register == null) {
            textArea.getToolkit().beep();
            return;
        }
        Transferable transferable = register.getTransferable();
        String string = null;
        if (transferable.isDataFlavorSupported(dataFlavor)) {
            string = Registers.getTextFromTransferable(transferable, dataFlavor);
        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            string = Registers.getTextFromTransferable(transferable, DataFlavor.stringFlavor);
        }
        if (string == null) {
            textArea.getToolkit().beep();
            return;
        }
        JEditBuffer jEditBuffer = textArea.getBuffer();
        Registers._paste(textArea, bl, string, jEditBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _paste(TextArea textArea, boolean bl, String string, JEditBuffer jEditBuffer) {
        try {
            jEditBuffer.beginCompoundEdit();
            if (bl && textArea.getSelectionCount() == 0) {
                int n = textArea.getCaretPosition();
                int n2 = textArea.getCaretLine();
                Selection.Rect rect = new Selection.Rect(n2, n, n2, n);
                textArea.setSelectedText(rect, string);
                n2 = textArea.getCaretLine();
                if (n2 != textArea.getLineCount() - 1) {
                    int n3 = rect.getStartColumn(jEditBuffer);
                    int n4 = jEditBuffer.getOffsetOfVirtualColumn(n2 + 1, n3, null);
                    if (n4 == -1) {
                        jEditBuffer.insertAtColumn(n2 + 1, n3, "");
                        textArea.setCaretPosition(jEditBuffer.getLineEndOffset(n2 + 1) - 1);
                    } else {
                        textArea.setCaretPosition(jEditBuffer.getLineStartOffset(n2 + 1) + n4);
                    }
                }
            } else {
                textArea.replaceSelection(string);
            }
        }
        finally {
            jEditBuffer.endCompoundEdit();
        }
        HistoryModel.getModel("clipboard").addItem(string);
    }

    private static void applyMode(Mode mode, JEditBuffer jEditBuffer) {
        if (mode != null && "text".equals(jEditBuffer.getMode().getName()) && !mode.equals(jEditBuffer.getMode()) && jEditBuffer.getLength() == 0) {
            jEditBuffer.setMode(mode);
        }
    }

    private static String getTextFromTransferable(Transferable transferable, DataFlavor dataFlavor) {
        try {
            Object object = transferable.getTransferData(dataFlavor);
            return Registers.stripEOLChars(object.toString());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.log(9, Registers.class, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Log.log(9, Registers.class, iOException);
        }
        return null;
    }

    public static Register getRegister(char c) {
        if (c != '$' && c != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || c >= registers.length) {
            return null;
        }
        return registers[c];
    }

    public static void setRegister(char c, Register register) {
        Registers.touchRegister(c);
        if (c >= registers.length) {
            Register[] registerArray = new Register[Math.min(65536, c << 1)];
            System.arraycopy(registers, 0, registerArray, 0, registers.length);
            registers = registerArray;
        }
        Registers.registers[c] = register;
        if (listener != null) {
            listener.registerChanged(c);
        }
    }

    public static void setRegister(char c, String string) {
        Registers.setRegister(c, new StringSelection(string));
    }

    public static void setRegister(char c, Transferable transferable) {
        Registers.touchRegister(c);
        Register register = Registers.getRegister(c);
        if (register != null) {
            register.setTransferable(transferable);
            if (listener != null) {
                listener.registerChanged(c);
            }
        } else {
            DefaultRegister defaultRegister = new DefaultRegister();
            defaultRegister.setTransferable(transferable);
            Registers.setRegister(c, defaultRegister);
        }
    }

    public static void clearRegister(char c) {
        if (c >= registers.length) {
            return;
        }
        Register register = registers[c];
        if (c == '$' || c == '%') {
            register.setTransferable(new StringSelection(""));
        } else {
            Registers.registers[c] = null;
            modified = true;
            if (listener != null) {
                listener.registerChanged(c);
            }
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuilder stringBuilder = new StringBuilder(registers.length << 1);
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append((char)i);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static void saveRegisters() {
        if (!loaded || !modified) {
            return;
        }
        if (saver != null) {
            saver.saveRegisters();
            modified = false;
        }
    }

    public static void setListener(RegistersListener registersListener) {
        listener = registersListener;
    }

    public static void setSaver(RegisterSaver registerSaver) {
        saver = registerSaver;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean bl) {
        loading = bl;
    }

    private Registers() {
    }

    private static void touchRegister(char c) {
        if (c == '%' || c == '$') {
            return;
        }
        if (!loaded) {
            Registers.loadRegisters();
        }
        if (!loading) {
            modified = true;
        }
    }

    private static void loadRegisters() {
        if (saver != null) {
            loaded = true;
            saver.loadRegisters();
        }
    }

    private static String stripEOLChars(String string) throws IOException {
        String string2;
        boolean bl = string.endsWith("\n") || string.endsWith(System.getProperty("line.separator"));
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        StringBuilder stringBuilder = new StringBuilder(string.length());
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.endsWith("\u0000")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        if (!bl && stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    protected static void debugListDataFlavors(Transferable transferable) {
        DataFlavor[] dataFlavorArray;
        for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
            Log.log(1, Registers.class, "debugListDataFlavors(): dataFlavor=" + dataFlavor + '.');
        }
        if (dataFlavorArray.length == 0) {
            Log.log(1, Registers.class, "debugListDataFlavors(): no dataFlavor supported.");
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Registers.registers[36] = new ClipboardRegister(toolkit.getSystemClipboard());
        Clipboard clipboard = toolkit.getSystemSelection();
        if (clipboard != null) {
            Registers.registers[37] = new ClipboardRegister(clipboard);
        }
    }

    private static class DefaultRegister
    implements Register {
        private Transferable transferable;

        private DefaultRegister() {
        }

        @Override
        public void setValue(String string) {
            this.transferable = new StringSelection(string);
        }

        @Override
        public String toString() {
            if (this.transferable == null) {
                return null;
            }
            if (this.transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    return this.transferable.getTransferData(DataFlavor.stringFlavor).toString();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Log.log(9, this, unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
            }
            return this.transferable.toString();
        }

        @Override
        public Transferable getTransferable() {
            return this.transferable;
        }

        @Override
        public void setTransferable(Transferable transferable) {
            this.transferable = transferable;
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        @Override
        public void setValue(String string) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, null);
        }

        @Override
        public String toString() {
            try {
                String string = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                return Registers.stripEOLChars(string);
            }
            catch (Exception exception) {
                Log.log(5, this, exception);
                return null;
            }
        }

        @Override
        public Transferable getTransferable() {
            return this.clipboard.getContents(this);
        }

        @Override
        public void setTransferable(Transferable transferable) {
            this.clipboard.setContents(transferable, null);
        }
    }

    public static interface Register {
        @Deprecated
        public String toString();

        @Deprecated
        public void setValue(String var1);

        public Transferable getTransferable();

        public void setTransferable(Transferable var1);
    }
}

