/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.jcraft.jzlib.JZlib;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.invoke.MethodHandle;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.util.MethodHandleUtils;
import org.jruby.util.ByteList;

@CoreClass(name="Truffle::Zlib")
public abstract class ZlibNodes {
    private static final int BUFFER_SIZE = 1024;

    @CoreMethod(names={"adler32"}, isModuleFunction=true, required=0, optional=2, lowerFixnumParameters={1})
    public static abstract class Adler32Node
    extends CoreMethodArrayArgumentsNode {
        private static final MethodHandle ADLER_FIELD_SETTER = MethodHandleUtils.getPrivateSetter(Adler32.class, "adler");

        public Adler32Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long adler32(NotProvided string, NotProvided adler) {
            return new Adler32().getValue();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public long adler32(DynamicObject string, NotProvided adler) {
            ByteList bytes = Layouts.STRING.getByteList(string);
            Adler32 adler32 = new Adler32();
            adler32.update(bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
            return adler32.getValue();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public long adler32(DynamicObject string, int adler) {
            ByteList bytes = Layouts.STRING.getByteList(string);
            Adler32 adler32 = new Adler32();
            try {
                ADLER_FIELD_SETTER.invokeExact(adler32, adler);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            adler32.update(bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
            return adler32.getValue();
        }

        @Specialization(guards={"isRubyBignum(adler)"})
        @CompilerDirectives.TruffleBoundary
        public long adler32(DynamicObject string, DynamicObject adler) {
            throw new RaiseException(this.getContext().getCoreLibrary().rangeError("bignum too big to convert into `unsigned long'", (Node)this));
        }
    }

    @CoreMethod(names={"inflate"}, isModuleFunction=true, required=1)
    public static abstract class InflateNode
    extends CoreMethodArrayArgumentsNode {
        public InflateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject inflate(DynamicObject message) {
            Inflater inflater = new Inflater();
            ByteList messageBytes = StringOperations.getByteList(message);
            inflater.setInput(messageBytes.unsafeBytes(), messageBytes.begin(), messageBytes.length());
            ByteList outputBytes = new ByteList(1024);
            while (!inflater.finished()) {
                int count;
                outputBytes.ensure(outputBytes.length() + 1024);
                try {
                    count = inflater.inflate(outputBytes.unsafeBytes(), outputBytes.begin() + outputBytes.length(), 1024);
                }
                catch (DataFormatException e) {
                    throw new RuntimeException(e);
                }
                outputBytes.setRealSize(outputBytes.getRealSize() + count);
            }
            inflater.end();
            return this.createString(outputBytes);
        }
    }

    @CoreMethod(names={"deflate"}, isModuleFunction=true, required=2)
    public static abstract class DeflateNode
    extends CoreMethodArrayArgumentsNode {
        public DeflateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject deflate(DynamicObject message, int level) {
            Deflater deflater = new Deflater(level);
            ByteList messageBytes = StringOperations.getByteList(message);
            deflater.setInput(messageBytes.unsafeBytes(), messageBytes.begin(), messageBytes.length());
            ByteList outputBytes = new ByteList(1024);
            deflater.finish();
            while (!deflater.finished()) {
                outputBytes.ensure(outputBytes.length() + 1024);
                int count = deflater.deflate(outputBytes.unsafeBytes(), outputBytes.begin() + outputBytes.length(), 1024);
                outputBytes.setRealSize(outputBytes.realSize() + count);
            }
            deflater.end();
            return this.createString(outputBytes);
        }
    }

    @CoreMethod(names={"crc32"}, isModuleFunction=true, optional=2)
    public static abstract class CRC32Node
    extends CoreMethodArrayArgumentsNode {
        public CRC32Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int crc32(NotProvided message, NotProvided initial) {
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public long crc32(DynamicObject message, NotProvided initial) {
            ByteList bytes = StringOperations.getByteList(message);
            CRC32 crc32 = new CRC32();
            crc32.update(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            return crc32.getValue();
        }

        @Specialization(guards={"isRubyString(message)"})
        public long crc32(DynamicObject message, int initial) {
            return this.crc32(message, (long)initial);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public long crc32(DynamicObject message, long initial) {
            ByteList bytes = StringOperations.getByteList(message);
            CRC32 crc32 = new CRC32();
            crc32.update(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            return JZlib.crc32_combine((long)initial, (long)crc32.getValue(), (long)bytes.length());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)", "isRubyBignum(initial)"})
        public long crc32(DynamicObject message, DynamicObject initial) {
            throw new RaiseException(this.getContext().getCoreLibrary().rangeError("bignum too big to convert into `unsigned long'", (Node)this));
        }
    }
}

