/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.ConsoleServicesFacade;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class WorkThread
implements Runnable {
    private static final Logger log = Logger.getLogger(WorkThread.class.getPackage().getName());
    private String[] myStringArray;

    public WorkThread(String[] myStringArray) {
        this.myStringArray = myStringArray;
    }

    @Override
    public void run() {
        try {
            ConsoleServicesFacade serviceFacade = Configuration.getInstance().getConsoleServicesFacade();
            AbstractParsedCommand cmd = serviceFacade.parseAndValidate(this.myStringArray);
            if (cmd != null) {
                serviceFacade.execute(cmd);
                SoundPlayer.getInstance().playSound();
            } else {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Command validation returned an empty value."));
            }
            log.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Command executed."));
        }
        catch (Throwable t) {
            log.error("Command Line: " + this.commandToString(), t);
            SoundPlayer.getInstance().playErrorSound();
        }
    }

    private String commandToString() {
        String command = StringUtils.join((Object[])this.myStringArray, (String)" ");
        if (command.length() > 1000) {
            command = command.substring(0, 1000) + " ...";
        }
        return command;
    }
}

