/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.renderers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.pdfsam.guiclient.commons.components.JVisualSelectionList;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.VisualPageListItem;

public class VisualListRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -6125533840590452401L;
    private static final double ZOOM_STEP = 0.1;
    private int currentZoomLevel = 0;
    private boolean drawRedCross = false;
    private BufferedImage image = null;

    public VisualListRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VisualPageListItem item = (VisualPageListItem)value;
        this.currentZoomLevel = ((JVisualSelectionList)list).getCurrentZoomLevel();
        if (!item.isDeleted() || item.isDeleted() && ((JVisualSelectionList)list).isDrawDeletedItems()) {
            if (item.getThumbnail() != null) {
                this.image = item.getThumbnail();
                this.setPreferredSize(this.getZoomedSize());
                this.drawRedCross = item.isDeleted();
            }
            String text = item.getPageNumber() + "";
            if (item.getPaperFormat() != null && item.getPaperFormat().length() > 0) {
                text = text + " - [" + item.getPaperFormat() + "]";
            }
            this.setText(text);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(3);
            this.setIconTextGap(2);
            this.setForeground(list.getForeground());
            this.setBackground(UIManager.getColor("Panel.background"));
            if (isSelected) {
                this.setBorder(BorderFactory.createLineBorder(Color.red, 1));
            } else {
                this.setBorder(BorderFactory.createLineBorder(list.getBackground()));
            }
        }
        return this;
    }

    private Dimension getZoomedSize() {
        Dimension retVal = null;
        int comSize = Configuration.getInstance().getThumbnailSize() + (int)((double)Configuration.getInstance().getThumbnailSize() * 0.1 * (double)this.currentZoomLevel);
        retVal = new Dimension(comSize + 2, comSize + 15);
        return retVal;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.image != null) {
            int imageHeight = 0;
            int imageWidth = 0;
            int x = 1;
            int y = 0;
            if (this.isHorizontal(this.image)) {
                imageWidth = this.getWidth() - 2;
                imageHeight = Math.round((float)this.image.getHeight(null) * ((float)imageWidth / (float)this.image.getWidth(null)));
                if (imageHeight > this.getHeight() - 15) {
                    imageHeight = this.getHeight() - 15;
                }
                y = (this.getHeight() - 15 - imageHeight) / 2;
            } else {
                imageHeight = this.getHeight() - 15;
                imageWidth = Math.round((float)this.image.getWidth(null) * ((float)imageHeight / (float)this.image.getHeight(null)));
                if (imageWidth > this.getWidth() - 2) {
                    imageWidth = this.getWidth() - 2;
                }
                x = (this.getWidth() - 2 - imageWidth) / 2;
            }
            if (Configuration.getInstance().isHighQualityThumbnails()) {
                g2d.setComposite(AlphaComposite.Src);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2d.drawImage(this.image, x, y, imageWidth, imageHeight, null);
        }
        if (this.drawRedCross) {
            g2d.setColor(Color.red);
            g2d.drawLine(0, this.getHeight(), this.getWidth(), 0);
            g2d.drawLine(this.getWidth(), this.getHeight(), 0, 0);
        }
    }

    private boolean isHorizontal(Image image) {
        boolean retVal = false;
        if (image != null) {
            retVal = image.getWidth(null) > image.getHeight(null);
        }
        return retVal;
    }
}

